/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.jarFinder.SourceSearchException;
import com.intellij.jarFinder.SourceSearcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenCentralSourceSearcher
extends SourceSearcher {
    private static final Logger LOG = Logger.getInstance(MavenCentralSourceSearcher.class);

    @Override
    @Nullable
    protected String findSourceJar(@NotNull ProgressIndicator indicator, @NotNull String artifactId, @NotNull String version, @NotNull VirtualFile classesJar) throws SourceSearchException {
        try {
            List<Element> artifactList;
            indicator.setText("Connecting to https://search.maven.org");
            indicator.checkCanceled();
            String url = "https://search.maven.org/solrsearch/select?rows=3&wt=xml&q=";
            String groupId = MavenCentralSourceSearcher.findMavenGroupId(classesJar, artifactId);
            if (groupId != null) {
                url = url + "g:%22" + groupId + "%22%20AND%20";
            }
            if ((artifactList = MavenCentralSourceSearcher.findElements("./result/doc/str[@name='g']", MavenCentralSourceSearcher.readElementCancelable(indicator, url = url + "a:%22" + artifactId + "%22%20AND%20v:%22" + version + "%22%20AND%20l:%22sources%22"))).isEmpty()) {
                return null;
            }
            if (artifactList.size() == 1) {
                return "https://search.maven.org/remotecontent?filepath=" + artifactList.get(0).getValue().replace('.', '/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + version + "-sources.jar";
            }
            return null;
        }
        catch (IOException e) {
            indicator.checkCanceled();
            LOG.warn((Throwable)e);
            throw new SourceSearchException("Connection problem. See log for more details.");
        }
    }
}

