/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.jarFinder.SourceSearchException;
import com.intellij.jarFinder.SourceSearcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SonatypeSourceSearcher
extends SourceSearcher {
    private static final Logger LOG = Logger.getInstance(SonatypeSourceSearcher.class);

    @Override
    @Nullable
    public String findSourceJar(@NotNull ProgressIndicator indicator, @NotNull String artifactId, @NotNull String version, @NotNull VirtualFile classesJar) throws SourceSearchException {
        try {
            List<Element> artifactList;
            indicator.setIndeterminate(true);
            indicator.setText("Connecting to https://oss.sonatype.org");
            indicator.checkCanceled();
            String url = "https://oss.sonatype.org/service/local/lucene/search?collapseresults=true&c=sources&a=" + artifactId + "&v=" + version;
            String groupId = SonatypeSourceSearcher.findMavenGroupId(classesJar, artifactId);
            if (groupId != null) {
                url = url + "&g=" + groupId;
            }
            if ((artifactList = SonatypeSourceSearcher.findElements("./data/artifact", SonatypeSourceSearcher.readElementCancelable(indicator, url))).isEmpty()) {
                return null;
            }
            if (artifactList.size() != 1) {
                return null;
            }
            Element element = artifactList.get(0);
            List<Element> artifactHintList = SonatypeSourceSearcher.findElements("artifactHits/artifactHit/artifactLinks/artifactLink/classifier[text()='sources']/../../..", element);
            if (artifactHintList.isEmpty()) {
                return null;
            }
            groupId = element.getChildTextTrim("groupId");
            String repositoryId = artifactHintList.get(0).getChildTextTrim("repositoryId");
            return "https://oss.sonatype.org/service/local/artifact/maven/redirect?r=" + repositoryId + "&g=" + groupId + "&a=" + artifactId + "&v=" + version + "&e=jar&c=sources";
        }
        catch (IOException e) {
            indicator.checkCanceled();
            LOG.warn((Throwable)e);
            throw new SourceSearchException("Connection problem. See log for more details.");
        }
    }
}

