/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.jarFinder.SourceSearchException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter2.Filters;
import org.jdom.xpath.XPathFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SourceSearcher {
    private static final String MAVEN_POM_ENTRY_PREFIX = "META-INF/maven/";

    @NotNull
    protected static List<Element> findElements(@NotNull String expression2, @NotNull Element element) {
        return XPathFactory.instance().compile(expression2, Filters.element()).evaluate((Object)element);
    }

    @Nullable
    protected String findSourceJar(@NotNull ProgressIndicator indicator, @NotNull String artifactId, @NotNull String version) throws SourceSearchException {
        return null;
    }

    @Nullable
    protected String findSourceJar(@NotNull ProgressIndicator indicator, @NotNull String artifactId, @NotNull String version, @NotNull VirtualFile classesJar) throws SourceSearchException {
        return this.findSourceJar(indicator, artifactId, version);
    }

    @NotNull
    protected static Element readElementCancelable(final ProgressIndicator indicator, String url) throws IOException {
        return (Element)HttpRequests.request((String)url).accept("application/xml").connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Element>(){

            public Element process(@NotNull HttpRequests.Request request) throws IOException {
                try {
                    return JDOMUtil.load((Reader)request.getReader(indicator));
                }
                catch (JDOMException e) {
                    throw new IOException(e);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected static String findMavenGroupId(@NotNull VirtualFile classesJar, String artifactId) {
        try (JarFile jarFile = new JarFile(VfsUtilCore.virtualToIoFile((VirtualFile)classesJar));){
            JarEntry entry;
            String name;
            Enumeration<JarEntry> entries = jarFile.entries();
            do {
                if (!entries.hasMoreElements()) return null;
            } while (!StringUtil.startsWith((CharSequence)(name = (entry = entries.nextElement()).getName()), (CharSequence)MAVEN_POM_ENTRY_PREFIX) || !StringUtil.endsWith((CharSequence)name, (CharSequence)("/" + artifactId + "/pom.xml")));
            int index = name.indexOf(47, MAVEN_POM_ENTRY_PREFIX.length());
            String string = index != -1 ? name.substring(MAVEN_POM_ENTRY_PREFIX.length(), index) : null;
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

