/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services;

import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.artifactory.ArtifactoryRepositoryService;
import com.intellij.jarRepository.services.bintray.BintrayRepositoryService;
import com.intellij.jarRepository.services.nexus.NexusRepositoryService;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="MavenServices", storages={@Storage(value="mavenServices.xml")})
public class MavenRepositoryServicesManager
implements PersistentStateComponent<MavenRepositoryServicesManager> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.repository.services.MavenRepositoryServicesManager");
    private final List<String> myUrls = new ArrayList<String>();
    public static final List<String> DEFAULT_SERVICES = ContainerUtil.immutableList((Object[])new String[]{"https://oss.sonatype.org/service/local/", "https://repo.jfrog.org/artifactory/api/", "https://repository.jboss.org/nexus/service/local/", "https://jcenter.bintray.com"});

    public MavenRepositoryServicesManager() {
        this.myUrls.addAll(DEFAULT_SERVICES);
    }

    @NotNull
    public static MavenRepositoryServicesManager getInstance(Project project) {
        return (MavenRepositoryServicesManager)ServiceManager.getService((Project)project, MavenRepositoryServicesManager.class);
    }

    @NotNull
    public static MavenRepositoryService[] getServices() {
        return new MavenRepositoryService[]{new NexusRepositoryService(), new ArtifactoryRepositoryService(), new BintrayRepositoryService()};
    }

    public static String[] getServiceUrls(Project project) {
        return ArrayUtil.toStringArray(MavenRepositoryServicesManager.getInstance(project).getUrls());
    }

    @Property(surroundWithTag=false)
    @XCollection(elementName="service-url", valueAttributeName="")
    @NotNull
    public List<String> getUrls() {
        return this.myUrls;
    }

    public void setUrls(@NotNull List<String> urls) {
        if (this.myUrls != urls) {
            this.myUrls.clear();
            this.myUrls.addAll(urls);
        }
    }

    public MavenRepositoryServicesManager getState() {
        return this;
    }

    public void loadState(@NotNull MavenRepositoryServicesManager state) {
        this.myUrls.clear();
        this.myUrls.addAll(state.getUrls());
    }

    @NotNull
    public static List<RemoteRepositoryDescription> getRepositories(String url) {
        SmartList result = new SmartList();
        for (MavenRepositoryService service : MavenRepositoryServicesManager.getServices()) {
            try {
                result.addAll(service.getRepositories(url));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return result;
    }

    @NotNull
    public static List<RepositoryArtifactDescription> findArtifacts(@NotNull RepositoryArtifactDescription template, @NotNull String url) {
        SmartList result = new SmartList();
        for (MavenRepositoryService service : MavenRepositoryServicesManager.getServices()) {
            try {
                result.addAll(service.findArtifacts(url, template));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return result;
    }
}

