/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services.nexus;

import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.nexus.ArtifactType;
import com.intellij.jarRepository.services.nexus.Endpoint;
import com.intellij.jarRepository.services.nexus.RepositoryType;
import com.intellij.jarRepository.services.nexus.SearchResults;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NexusRepositoryService
extends MavenRepositoryService {
    @Nullable
    public static RemoteRepositoryDescription convertRepositoryInfo(@NotNull RepositoryType repo) {
        String id = repo.getId();
        if (id == null) {
            return null;
        }
        String name = repo.getName();
        if (name == null) {
            return null;
        }
        String uri = repo.getContentResourceURI();
        if (uri == null) {
            return null;
        }
        return new RemoteRepositoryDescription(id, name, uri);
    }

    public static RepositoryArtifactDescription convertArtifactInfo(ArtifactType t) {
        return new RepositoryArtifactDescription(t.getGroupId(), t.getArtifactId(), t.getVersion(), t.getPackaging(), t.getClassifier(), null, t.getRepoId());
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Nexus";
    }

    @Override
    @NotNull
    public List<RemoteRepositoryDescription> getRepositories(@NotNull String url) throws IOException {
        try {
            List<RepositoryType> repos = new Endpoint.Repositories(url).getRepolistAsRepositories().getData().getRepositoriesItem();
            SmartList result = new SmartList();
            for (RepositoryType repo : repos) {
                RemoteRepositoryDescription desc;
                if (!"maven2".equals(repo.getProvider()) || (desc = NexusRepositoryService.convertRepositoryInfo(repo)) == null) continue;
                result.add(desc);
            }
            return result;
        }
        catch (UnmarshalException e) {
            return Collections.emptyList();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    @NotNull
    public List<RepositoryArtifactDescription> findArtifacts(@NotNull String url, @NotNull RepositoryArtifactDescription template) throws IOException {
        try {
            String packaging = StringUtil.notNullize((String)template.getPackaging());
            String name = StringUtil.join(Arrays.asList(template.getGroupId(), template.getArtifactId(), template.getVersion()), (String)":");
            SearchResults results = new Endpoint.DataIndex(url).getArtifactlistAsSearchResults(name, template.getGroupId(), template.getArtifactId(), template.getVersion(), null, template.getClassNames());
            SearchResults.Data data = results.getData();
            ArrayList<RepositoryArtifactDescription> result = new ArrayList<RepositoryArtifactDescription>();
            if (data != null) {
                for (ArtifactType each : data.getArtifact()) {
                    if (!Comparing.equal((String)each.packaging, (String)packaging)) continue;
                    result.add(NexusRepositoryService.convertArtifactInfo(each));
                }
            }
            return result;
        }
        catch (UnmarshalException e) {
            return Collections.emptyList();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }
}

