/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.usageView.UsageViewShortNameLocation;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaBreadcrumbsInfoProvider
implements BreadcrumbsProvider {
    private static final Language[] ourLanguages = new Language[]{JavaLanguage.INSTANCE};

    public Language[] getLanguages() {
        return ourLanguages;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        return e instanceof PsiMember || e instanceof PsiLambdaExpression;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        if (e instanceof PsiLambdaExpression) {
            return PsiExpressionTrimRenderer.render((PsiExpression)((PsiExpression)e));
        }
        if (e instanceof PsiAnonymousClass) {
            String name = ((PsiAnonymousClass)e).getBaseClassReference().getReferenceName();
            return "new " + StringUtil.notNullize((String)name, (String)"class");
        }
        String description = ElementDescriptionUtil.getElementDescription((PsiElement)e, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
        String suffix = e instanceof PsiParameterListOwner ? "()" : null;
        return suffix != null ? description + suffix : description;
    }

    @Nullable
    public Icon getElementIcon(@NotNull PsiElement element) {
        return Registry.is((String)"editor.breadcrumbs.java.icon") ? element.getIcon(0) : null;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        if (e instanceof PsiLambdaExpression) {
            return JavaBreadcrumbsInfoProvider.getLambdaDescription((PsiLambdaExpression)e);
        }
        if (e instanceof PsiMethod) {
            return JavaBreadcrumbsInfoProvider.getMethodPresentableText((PsiMethod)e);
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)e, (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT);
    }

    @NotNull
    private static String getMethodPresentableText(PsiMethod e) {
        boolean isDumb = DumbService.isDumb((Project)e.getProject());
        StringBuilder sb = new StringBuilder(e.isConstructor() ? "constructor" : "method");
        PsiType type2 = e.getReturnType();
        if (type2 != null) {
            sb.append(" ").append(StringUtil.htmlEmphasize((String)JavaBreadcrumbsInfoProvider.getTypeText(type2, isDumb)));
        }
        sb.append(" ").append(StringUtil.htmlEmphasize((String)e.getName()));
        JavaBreadcrumbsInfoProvider.appendParameters((PsiParameterListOwner)e, sb, false, isDumb);
        return sb.toString();
    }

    @NotNull
    private static String getLambdaDescription(@NotNull PsiLambdaExpression e) {
        PsiType functionalInterfaceType;
        boolean isDumb = DumbService.isDumb((Project)e.getProject());
        StringBuilder sb = new StringBuilder("lambda");
        PsiType psiType = functionalInterfaceType = isDumb ? null : e.getFunctionalInterfaceType();
        if (functionalInterfaceType != null) {
            sb.append(" ").append(StringUtil.htmlEmphasize((String)JavaBreadcrumbsInfoProvider.getTypeText(functionalInterfaceType, false)));
        }
        JavaBreadcrumbsInfoProvider.appendParameters((PsiParameterListOwner)e, sb, true, isDumb);
        return sb.toString();
    }

    private static void appendParameters(@NotNull PsiParameterListOwner e, StringBuilder sb, boolean skipIfEmpty, boolean isDumb) {
        PsiParameter[] parameters2 = e.getParameterList().getParameters();
        if (parameters2.length == 0 && skipIfEmpty) {
            return;
        }
        if (skipIfEmpty) {
            sb.append(" ");
        }
        sb.append("(");
        for (int i = 0; i < parameters2.length; ++i) {
            PsiTypeElement typeElement;
            if (i > 0) {
                sb.append(", ");
            }
            String typeStr = isDumb ? ((typeElement = parameters2[i].getTypeElement()) == null ? "" : PsiNameHelper.getShortClassName((String)typeElement.getText())) : JavaBreadcrumbsInfoProvider.getTypeText(parameters2[i].getType(), false);
            String str = StringUtil.isEmpty((String)typeStr) ? StringUtil.notNullize((String)parameters2[i].getName()) : PsiNameHelper.getShortClassName((String)typeStr);
            sb.append(StringUtil.htmlEmphasize((String)str));
        }
        sb.append(")");
    }

    @NotNull
    private static String getTypeText(@Nullable PsiType type2, boolean isDumb) {
        String result = type2 == null ? "" : (!isDumb || type2 instanceof PsiPrimitiveType ? type2.getCanonicalText(false) : (type2 instanceof PsiClassReferenceType ? ((PsiClassReferenceType)type2).getReference().getReferenceName() : ""));
        return PsiNameHelper.getShortClassName((String)StringUtil.notNullize((String)result));
    }
}

