/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.PsiBasedFormatterModelWithShiftIndentInside;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFormattingModelBuilder
implements FormattingModelBuilderEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.java.JavaFormattingModelBuilder");

    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode formattingMode) {
        FileElement fileElement = TreeUtil.getFileElement((TreeElement)((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)element)));
        LOG.assertTrue(fileElement != null, (Object)("File element should not be null for " + element));
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
        JavaCodeStyleSettings customJavaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        Block block = AbstractJavaBlock.newJavaBlock((ASTNode)fileElement, commonSettings, customJavaSettings, formattingMode);
        FormattingDocumentModelImpl model = FormattingDocumentModelImpl.createOn((PsiFile)element.getContainingFile());
        return new PsiBasedFormatterModelWithShiftIndentInside(element.getContainingFile(), block, model);
    }

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsToUse(@NotNull PsiFile file, @NotNull FormatTextRanges ranges, @NotNull CodeStyleSettings settings) {
        return null;
    }

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        return this.createModel(element, settings, FormattingMode.REFORMAT);
    }

    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return JavaFormattingModelBuilder.doGetRangeAffectingIndent(elementAtOffset);
    }

    @Nullable
    public static TextRange doGetRangeAffectingIndent(ASTNode elementAtOffset) {
        ASTNode current = elementAtOffset;
        if ((current = JavaFormattingModelBuilder.findNearestExpressionParent(current)) == null) {
            if (elementAtOffset.getElementType() == TokenType.WHITE_SPACE) {
                ASTNode prevElement = elementAtOffset.getTreePrev();
                if (prevElement == null) {
                    return elementAtOffset.getTextRange();
                }
                ASTNode prevExpressionParent = JavaFormattingModelBuilder.findNearestExpressionParent(prevElement);
                if (prevExpressionParent == null) {
                    return elementAtOffset.getTextRange();
                }
                return new TextRange(prevExpressionParent.getTextRange().getStartOffset(), elementAtOffset.getTextRange().getEndOffset());
            }
            return JavaFormattingModelBuilder.combineWithErrorElementIfPossible(elementAtOffset);
        }
        return current.getTextRange();
    }

    @Nullable
    private static TextRange combineWithErrorElementIfPossible(@NotNull ASTNode node) {
        if (node.getElementType() == TokenType.ERROR_ELEMENT) {
            return node.getTextRange();
        }
        ASTNode prevLeaf = FormatterUtil.getPreviousLeaf((ASTNode)node, (IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
        if (prevLeaf == null || prevLeaf.getElementType() != TokenType.ERROR_ELEMENT) {
            return node.getTextRange();
        }
        TextRange range = JavaFormattingModelBuilder.doGetRangeAffectingIndent(prevLeaf);
        if (range == null) {
            return node.getTextRange();
        }
        return new TextRange(range.getStartOffset(), node.getTextRange().getEndOffset());
    }

    @Nullable
    private static ASTNode findNearestExpressionParent(ASTNode current) {
        PsiElement psi;
        ASTNode result;
        for (result = current; result != null && (!((psi = result.getPsi()) instanceof PsiExpression) || psi.getParent() instanceof PsiExpression); result = result.getTreeParent()) {
        }
        return result;
    }
}

