/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.actions;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.lang.java.actions.CreateAnnotationActionKt;
import com.intellij.lang.java.actions.CreateTargetAction;
import com.intellij.lang.jvm.actions.ActionRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J%\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/java/actions/CreateAnnotationAction;", "Lcom/intellij/lang/java/actions/CreateTargetAction;", "Lcom/intellij/psi/PsiModifierListOwner;", "target", "request", "Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "(Lcom/intellij/psi/PsiModifierListOwner;Lcom/intellij/lang/jvm/actions/AnnotationRequest;)V", "getRequest", "()Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.java.impl"})
public final class CreateAnnotationAction
extends CreateTargetAction<PsiModifierListOwner> {
    @NotNull
    private final AnnotationRequest request;

    @NotNull
    public String getText() {
        return QuickFixBundle.message("create.annotation.text", StringUtilRt.getShortName((String)this.getRequest().getQualifiedName()));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.annotation.family", new Object[0]);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        PsiModifierList psiModifierList = ((PsiModifierListOwner)this.getTarget()).getModifierList();
        if (psiModifierList == null) {
            return;
        }
        PsiModifierList modifierList = psiModifierList;
        PsiAnnotation annotation = modifierList.addAnnotation(this.getRequest().getQualifiedName());
        PsiElementFactory psiElementFactory = PsiElementFactory.SERVICE.getInstance((Project)project);
        for (AnnotationAttributeRequest annotationAttributeRequest : this.getRequest().getAttributes()) {
            PsiExpression psiExpression;
            String name = annotationAttributeRequest.component1();
            AnnotationAttributeValueRequest value2 = annotationAttributeRequest.component2();
            Object object = value2;
            if (object instanceof AnnotationAttributeValueRequest.PrimitiveValue) {
                psiExpression = psiElementFactory.createExpressionFromText(((AnnotationAttributeValueRequest.PrimitiveValue)value2).getValue().toString(), null);
            } else if (object instanceof AnnotationAttributeValueRequest.StringValue) {
                psiExpression = psiElementFactory.createExpressionFromText("\"" + StringUtil.escapeStringCharacters((String)((AnnotationAttributeValueRequest.StringValue)value2).getValue()) + "\"", null);
            } else {
                CreateAnnotationActionKt.access$getLOG$p().error("adding annotation members of " + value2.getClass() + " type is not implemented");
                continue;
            }
            PsiExpression memberValue = psiExpression;
            object = name;
            PsiAnnotation psiAnnotation = annotation;
            Object it = object;
            boolean bl = false;
            Object object2 = Intrinsics.areEqual((Object)name, (Object)"value") ^ true ? object : null;
            psiAnnotation.setDeclaredAttributeValue((String)object2, (PsiAnnotationMemberValue)memberValue);
        }
        CodeStyleManager formatter = CodeStyleManager.getInstance((Project)project);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        codeStyleManager.shortenClassReferences(formatter.reformat((PsiElement)annotation));
    }

    @NotNull
    protected AnnotationRequest getRequest() {
        return this.request;
    }

    public CreateAnnotationAction(@NotNull PsiModifierListOwner target, @NotNull AnnotationRequest request) {
        super((PsiElement)target, (ActionRequest)request);
        this.request = request;
    }
}

