/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementParser {
    private static final TokenSet TRY_CLOSERS_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.CATCH_KEYWORD, JavaTokenType.FINALLY_KEYWORD});
    private final JavaParser myParser;

    public StatementParser(@NotNull JavaParser javaParser) {
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder) {
        return this.parseCodeBlock(builder, false);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder, boolean isStatement) {
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        if (isStatement && JavaParserUtil.isParseStatementCodeBlocksDeep(builder)) {
            return this.parseCodeBlockDeep(builder, false);
        }
        return PsiBuilderUtil.parseBlockLazy((PsiBuilder)builder, (IElementType)JavaTokenType.LBRACE, (IElementType)JavaTokenType.RBRACE, (IElementType)JavaElementType.CODE_BLOCK);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlockDeep(@NotNull PsiBuilder builder, boolean parseUntilEof) {
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        PsiBuilder.Marker codeBlock = builder.mark();
        builder.advanceLexer();
        this.parseStatements(builder, parseUntilEof ? BraceMode.TILL_LAST : BraceMode.TILL_FIRST);
        boolean greedyBlock = !JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
        builder.getTokenType();
        JavaParserUtil.done(codeBlock, (IElementType)JavaElementType.CODE_BLOCK);
        if (greedyBlock) {
            codeBlock.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return codeBlock;
    }

    public void parseStatements(@NotNull PsiBuilder builder) {
        this.parseStatements(builder, null);
    }

    private void parseStatements(PsiBuilder builder, @Nullable BraceMode braceMode) {
        while (builder.getTokenType() != null) {
            PsiBuilder.Marker statement = this.parseStatement(builder);
            if (statement != null) continue;
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.RBRACE && (braceMode == BraceMode.TILL_FIRST || braceMode == BraceMode.TILL_LAST && builder.lookAhead(1) == null)) break;
            PsiBuilder.Marker error = builder.mark();
            builder.advanceLexer();
            if (tokenType == JavaTokenType.ELSE_KEYWORD) {
                error.error(JavaErrorMessages.message("else.without.if", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.CATCH_KEYWORD) {
                error.error(JavaErrorMessages.message("catch.without.try", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.FINALLY_KEYWORD) {
                error.error(JavaErrorMessages.message("finally.without.try", new Object[0]));
                continue;
            }
            error.error(JavaErrorMessages.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseStatement(@NotNull PsiBuilder builder) {
        PsiBuilder.Marker statement;
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.IF_KEYWORD) {
            return this.parseIfStatement(builder);
        }
        if (tokenType == JavaTokenType.WHILE_KEYWORD) {
            return this.parseWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.FOR_KEYWORD) {
            return this.parseForStatement(builder);
        }
        if (tokenType == JavaTokenType.DO_KEYWORD) {
            return this.parseDoWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.parseSwitchStatement(builder);
        }
        if (tokenType == JavaTokenType.CASE_KEYWORD || tokenType == JavaTokenType.DEFAULT_KEYWORD) {
            return this.parseSwitchLabelStatement(builder);
        }
        if (tokenType == JavaTokenType.BREAK_KEYWORD) {
            return this.parseBreakStatement(builder);
        }
        if (tokenType == JavaTokenType.CONTINUE_KEYWORD) {
            return StatementParser.parseContinueStatement(builder);
        }
        if (tokenType == JavaTokenType.RETURN_KEYWORD) {
            return this.parseReturnStatement(builder);
        }
        if (tokenType == JavaTokenType.THROW_KEYWORD) {
            return this.parseThrowStatement(builder);
        }
        if (tokenType == JavaTokenType.SYNCHRONIZED_KEYWORD) {
            return this.parseSynchronizedStatement(builder);
        }
        if (tokenType == JavaTokenType.TRY_KEYWORD) {
            return this.parseTryStatement(builder);
        }
        if (tokenType == JavaTokenType.ASSERT_KEYWORD) {
            return this.parseAssertStatement(builder);
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseBlockStatement(builder);
        }
        if (tokenType instanceof ILazyParseableElementType) {
            builder.advanceLexer();
            return null;
        }
        if (tokenType == JavaTokenType.SEMICOLON) {
            PsiBuilder.Marker empty = builder.mark();
            builder.advanceLexer();
            JavaParserUtil.done(empty, JavaElementType.EMPTY_STATEMENT);
            return empty;
        }
        if (tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.AT) {
            PsiBuilder.Marker refPos = builder.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            StatementParser.skipQualifiedName(builder);
            IElementType suspectedLT = builder.getTokenType();
            IElementType next = builder.lookAhead(1);
            refPos.rollbackTo();
            if (suspectedLT == JavaTokenType.LT || suspectedLT == JavaTokenType.DOT && next == JavaTokenType.AT) {
                PsiBuilder.Marker declStatement = builder.mark();
                PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.CODE_BLOCK);
                if (decl == null) {
                    PsiBuilder.Marker marker = this.myParser.getReferenceParser().parseType(builder, 0);
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    if (marker == null) {
                        builder.advanceLexer();
                    }
                }
                JavaParserUtil.done(declStatement, JavaElementType.DECLARATION_STATEMENT);
                return declStatement;
            }
        }
        PsiBuilder.Marker pos = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr != null) {
            int count = 1;
            PsiBuilder.Marker list = expr.precede();
            PsiBuilder.Marker statement2 = list.precede();
            while (builder.getTokenType() == JavaTokenType.COMMA) {
                PsiBuilder.Marker commaPos = builder.mark();
                builder.advanceLexer();
                PsiBuilder.Marker expr1 = this.myParser.getExpressionParser().parse(builder);
                if (expr1 == null) {
                    commaPos.rollbackTo();
                    break;
                }
                commaPos.drop();
                ++count;
            }
            if (count > 1) {
                pos.drop();
                JavaParserUtil.done(list, JavaElementType.EXPRESSION_LIST);
                JavaParserUtil.semicolon(builder);
                JavaParserUtil.done(statement2, JavaElementType.EXPRESSION_LIST_STATEMENT);
                return statement2;
            }
            if (JavaParserUtil.exprType(expr) != JavaElementType.REFERENCE_EXPRESSION) {
                PsiBuilderUtil.drop((PsiBuilder.Marker[])new PsiBuilder.Marker[]{list, pos});
                JavaParserUtil.semicolon(builder);
                JavaParserUtil.done(statement2, JavaElementType.EXPRESSION_STATEMENT);
                return statement2;
            }
            pos.rollbackTo();
        } else {
            pos.drop();
        }
        PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.CODE_BLOCK);
        if (decl != null) {
            statement = decl.precede();
            JavaParserUtil.done(statement, JavaElementType.DECLARATION_STATEMENT);
            return statement;
        }
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && builder.lookAhead(1) == JavaTokenType.COLON) {
            statement = builder.mark();
            PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
            this.parseStatement(builder);
            JavaParserUtil.done(statement, JavaElementType.LABELED_STATEMENT);
            return statement;
        }
        if (expr != null) {
            statement = builder.mark();
            this.myParser.getExpressionParser().parse(builder);
            JavaParserUtil.semicolon(builder);
            JavaParserUtil.done(statement, JavaElementType.EXPRESSION_STATEMENT);
            return statement;
        }
        return null;
    }

    private static void skipQualifiedName(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            return;
        }
        while (builder.getTokenType() == JavaTokenType.DOT && builder.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
        }
    }

    @NotNull
    private PsiBuilder.Marker parseIfStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.parseExprInParenth(builder)) {
            PsiBuilder.Marker elseStatement;
            PsiBuilder.Marker thenStatement = this.parseStatement(builder);
            if (thenStatement == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            } else if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.ELSE_KEYWORD) && (elseStatement = this.parseStatement(builder)) == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            }
        }
        JavaParserUtil.done(statement, JavaElementType.IF_STATEMENT);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseWhileStatement(PsiBuilder builder) {
        return this.parseExprInParenthWithBlock(builder, JavaElementType.WHILE_STATEMENT, false);
    }

    @NotNull
    private PsiBuilder.Marker parseForStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
            return statement;
        }
        PsiBuilder.Marker afterParenth = builder.mark();
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, false, true);
        if (param == null || JavaParserUtil.exprType(param) != JavaElementType.PARAMETER || builder.getTokenType() != JavaTokenType.COLON) {
            afterParenth.rollbackTo();
            return this.parseForLoopFromInitializer(builder, statement);
        }
        afterParenth.drop();
        return this.parseForEachFromColon(builder, statement);
    }

    @NotNull
    private PsiBuilder.Marker parseForLoopFromInitializer(PsiBuilder builder, PsiBuilder.Marker statement) {
        PsiBuilder.Marker bodyStatement;
        if (this.parseStatement(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
                JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
                return statement;
            }
        } else {
            PsiBuilder.Marker expr;
            boolean missingSemicolon = false;
            if (StatementParser.getLastToken(builder) != JavaTokenType.SEMICOLON) {
                missingSemicolon = !JavaParserUtil.expectOrError(builder, JavaTokenType.SEMICOLON, "expected.semicolon");
            }
            missingSemicolon &= (expr = this.myParser.getExpressionParser().parse(builder)) == null;
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON)) {
                if (!missingSemicolon) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.semicolon", new Object[0]));
                }
                if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
                    JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
                    return statement;
                }
            } else {
                this.parseForUpdateExpressions(builder);
                if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
                    JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
                    return statement;
                }
            }
        }
        if ((bodyStatement = this.parseStatement(builder)) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.FOR_STATEMENT);
        return statement;
    }

    private static IElementType getLastToken(PsiBuilder builder) {
        IElementType token;
        int offset = -1;
        while (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(token = builder.rawLookup(offset))) {
            --offset;
        }
        return token;
    }

    private void parseForUpdateExpressions(PsiBuilder builder) {
        PsiBuilder.Marker expressionStatement;
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            return;
        }
        if (builder.getTokenType() != JavaTokenType.COMMA) {
            expressionStatement = expr.precede();
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_STATEMENT);
        } else {
            PsiBuilder.Marker expressionList = expr.precede();
            expressionStatement = expressionList.precede();
            do {
                builder.advanceLexer();
                PsiBuilder.Marker nextExpression = this.myParser.getExpressionParser().parse(builder);
                if (nextExpression != null) continue;
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            } while (builder.getTokenType() == JavaTokenType.COMMA);
            JavaParserUtil.done(expressionList, JavaElementType.EXPRESSION_LIST);
            JavaParserUtil.done(expressionStatement, JavaElementType.EXPRESSION_LIST_STATEMENT);
        }
        expressionStatement.setCustomEdgeTokenBinders(null, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @NotNull
    private PsiBuilder.Marker parseForEachFromColon(PsiBuilder builder, PsiBuilder.Marker statement) {
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
        }
        if (JavaParserUtil.expectOrError(builder, JavaTokenType.RPARENTH, "expected.rparen") && this.parseStatement(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
        }
        JavaParserUtil.done(statement, JavaElementType.FOREACH_STATEMENT);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseDoWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker body2 = this.parseStatement(builder);
        if (body2 == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.statement", new Object[0]));
        } else if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.WHILE_KEYWORD)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.while", new Object[0]));
        } else if (this.parseExprInParenth(builder)) {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.DO_WHILE_STATEMENT);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseSwitchStatement(PsiBuilder builder) {
        return this.parseExprInParenthWithBlock(builder, JavaElementType.SWITCH_STATEMENT, true);
    }

    private PsiBuilder.Marker parseSwitchLabelStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        boolean isCase = builder.getTokenType() == JavaTokenType.CASE_KEYWORD;
        builder.advanceLexer();
        if (isCase) {
            PsiBuilder.Marker expressionList = builder.mark();
            do {
                PsiBuilder.Marker nextExpression;
                if ((nextExpression = this.myParser.getExpressionParser().parseCaseLabel(builder)) != null) continue;
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            } while (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COMMA));
            JavaParserUtil.done(expressionList, JavaElementType.EXPRESSION_LIST);
        }
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.ARROW)) {
            PsiBuilder.Marker body2;
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                body2 = builder.mark();
                this.parseCodeBlock(builder, true);
                body2.done(JavaElementType.BLOCK_STATEMENT);
                if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                    PsiBuilder.Marker mark = builder.mark();
                    while (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                        builder.advanceLexer();
                    }
                    mark.error(JavaErrorMessages.message("expected.switch.label", new Object[0]));
                }
            } else if (builder.getTokenType() == JavaTokenType.THROW_KEYWORD) {
                this.parseThrowStatement(builder);
            } else {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
                if (expr != null) {
                    body2 = expr.precede();
                    JavaParserUtil.semicolon(builder);
                    body2.done(JavaElementType.EXPRESSION_STATEMENT);
                } else {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.switch.rule", new Object[0]));
                    PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON);
                }
            }
            JavaParserUtil.done(statement, JavaElementType.SWITCH_LABELED_RULE);
        } else {
            JavaParserUtil.expectOrError(builder, JavaTokenType.COLON, "expected.colon");
            JavaParserUtil.done(statement, JavaElementType.SWITCH_LABEL_STATEMENT);
        }
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseBreakStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() != JavaTokenType.SEMICOLON) {
            this.myParser.getExpressionParser().parse(builder);
        }
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.BREAK_STATEMENT);
        return statement;
    }

    @NotNull
    private static PsiBuilder.Marker parseContinueStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.CONTINUE_STATEMENT);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseReturnStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        this.myParser.getExpressionParser().parse(builder);
        JavaParserUtil.semicolon(builder);
        JavaParserUtil.done(statement, JavaElementType.RETURN_STATEMENT);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseThrowStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.THROW_STATEMENT);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseSynchronizedStatement(PsiBuilder builder) {
        return this.parseExprInParenthWithBlock(builder, JavaElementType.SYNCHRONIZED_STATEMENT, true);
    }

    @NotNull
    private PsiBuilder.Marker parseTryStatement(PsiBuilder builder) {
        PsiBuilder.Marker tryBlock;
        boolean hasResourceList;
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        boolean bl = hasResourceList = builder.getTokenType() == JavaTokenType.LPARENTH;
        if (hasResourceList) {
            this.myParser.getDeclarationParser().parseResourceList(builder);
        }
        if ((tryBlock = this.parseCodeBlock(builder, true)) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
        } else if (!hasResourceList && !TRY_CLOSERS_SET.contains(builder.getTokenType())) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.catch.or.finally", new Object[0]));
        } else {
            PsiBuilder.Marker finallyBlock;
            while (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD && this.parseCatchBlock(builder)) {
            }
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.FINALLY_KEYWORD) && (finallyBlock = this.parseCodeBlock(builder, true)) == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
            }
        }
        JavaParserUtil.done(statement, JavaElementType.TRY_STATEMENT);
        return statement;
    }

    public boolean parseCatchBlock(@NotNull PsiBuilder builder) {
        assert (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD) : builder.getTokenType();
        PsiBuilder.Marker section = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, true, false);
        if (param == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.parameter", new Object[0]));
        }
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        PsiBuilder.Marker body2 = this.parseCodeBlock(builder, true);
        if (body2 == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lbrace", new Object[0]));
            JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
            return false;
        }
        JavaParserUtil.done(section, JavaElementType.CATCH_SECTION);
        return true;
    }

    @NotNull
    private PsiBuilder.Marker parseAssertStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.boolean.expression", new Object[0]));
        } else if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COLON) && this.myParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
        } else {
            JavaParserUtil.semicolon(builder);
        }
        JavaParserUtil.done(statement, JavaElementType.ASSERT_STATEMENT);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseBlockStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        this.parseCodeBlock(builder, true);
        JavaParserUtil.done(statement, JavaElementType.BLOCK_STATEMENT);
        return statement;
    }

    @NotNull
    public PsiBuilder.Marker parseExprInParenthWithBlock(@NotNull PsiBuilder builder, @NotNull IElementType type2, boolean block) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.parseExprInParenth(builder)) {
            PsiBuilder.Marker body2;
            PsiBuilder.Marker marker = body2 = block ? this.parseCodeBlock(builder, true) : this.parseStatement(builder);
            if (body2 == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message(block ? "expected.lbrace" : "expected.statement", new Object[0]));
            }
        }
        JavaParserUtil.done(statement, type2);
        return statement;
    }

    private boolean parseExprInParenth(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.lparen", new Object[0]));
            return false;
        }
        PsiBuilder.Marker beforeExpr = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null || builder.getTokenType() == JavaTokenType.SEMICOLON) {
            beforeExpr.rollbackTo();
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                return false;
            }
        } else {
            beforeExpr.drop();
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
                return false;
            }
        }
        builder.advanceLexer();
        return true;
    }

    private static enum BraceMode {
        TILL_FIRST,
        TILL_LAST;

    }
}

