/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.facade;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.facade.JvmElementProvider;
import com.intellij.lang.jvm.facade.JvmFacade;
import com.intellij.lang.jvm.util.JvmClassUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JvmFacadeImpl
implements JvmFacade {
    private static final Logger LOG = Logger.getInstance(JvmFacadeImpl.class);
    private final DumbService myDumbService;
    private final JavaPsiFacadeImpl myJavaPsiFacade;
    private final JvmElementProvider[] myElementProviders;
    private final Map<GlobalSearchScope, Map<String, List<JvmClass>>> myClassCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();

    public JvmFacadeImpl(@NotNull Project project, MessageBus bus) {
        this.myDumbService = DumbService.getInstance((Project)project);
        this.myJavaPsiFacade = (JavaPsiFacadeImpl)JavaPsiFacade.getInstance((Project)project);
        this.myElementProviders = (JvmElementProvider[])JvmElementProvider.EP_NAME.getExtensions((AreaInstance)project);
        if (bus != null) {
            bus.connect().subscribe(PsiModificationTracker.TOPIC, () -> this.myClassCache.clear());
        }
    }

    @NotNull
    public List<? extends JvmClass> findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        Map map2 = this.myClassCache.computeIfAbsent(scope, s -> ContainerUtil.createConcurrentWeakValueMap());
        return map2.computeIfAbsent(qualifiedName, fqn -> this.doFindClassesWithJavaFacade((String)fqn, scope));
    }

    private List<JvmClass> doFindClassesWithJavaFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        return JvmFacadeImpl.sortByScope(this.findClassesWithJavaFacade(qualifiedName, scope), scope);
    }

    private List<JvmClass> findClassesWithJavaFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        List<PsiClass> javaClasses;
        ArrayList<JvmClass> result = null;
        List<JvmClass> ownClasses = this.findClassesWithoutJavaFacade(qualifiedName, scope);
        if (!ownClasses.isEmpty()) {
            result = new ArrayList<JvmClass>(ownClasses);
        }
        if (!(javaClasses = this.myJavaPsiFacade.findClassesWithoutJvmFacade(qualifiedName, scope)).isEmpty()) {
            if (result == null) {
                result = new ArrayList<PsiClass>(javaClasses);
            } else {
                result.addAll(javaClasses);
            }
        }
        return result == null ? Collections.emptyList() : result;
    }

    @NotNull
    public List<JvmClass> findClassesWithoutJavaFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        ArrayList result = null;
        for (JvmElementProvider provider : this.filteredProviders()) {
            List providedClasses = provider.getClasses(qualifiedName, scope);
            if (providedClasses.isEmpty()) continue;
            JvmFacadeImpl.assertNotNullClasses(provider, providedClasses);
            if (result == null) {
                result = new ArrayList(providedClasses);
                continue;
            }
            result.addAll(providedClasses);
        }
        return result == null ? Collections.emptyList() : result;
    }

    @NotNull
    private static List<JvmClass> sortByScope(@NotNull List<JvmClass> classes2, @NotNull GlobalSearchScope scope) {
        if (classes2.size() == 1) {
            return classes2;
        }
        classes2.sort(JvmClassUtil.createScopeComparator((GlobalSearchScope)scope));
        return classes2;
    }

    private static void assertNotNullClasses(@NotNull JvmElementProvider provider, @NotNull List<? extends JvmClass> classes2) {
        for (JvmClass jvmClass : classes2) {
            LOG.assertTrue(jvmClass != null, (Object)("Provider " + provider + "returned null JvmClass"));
        }
    }

    @NotNull
    private List<JvmElementProvider> filteredProviders() {
        return this.myDumbService.filterByDumbAwareness((Object[])this.myElementProviders);
    }
}

