/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVersionServiceImpl
extends JavaVersionService {
    public boolean isAtLeast(@NotNull PsiElement element, @NotNull JavaSdkVersion version) {
        return JavaSdkVersionUtil.isAtLeast((PsiElement)element, (JavaSdkVersion)version);
    }

    @Nullable
    public JavaSdkVersion getJavaSdkVersion(@NotNull PsiElement element) {
        return JavaSdkVersionUtil.getJavaSdkVersion((PsiElement)element);
    }

    public boolean isCompilerVersionAtLeast(@NotNull PsiElement element, @NotNull JavaSdkVersion version) {
        if (super.isCompilerVersionAtLeast(element, version)) {
            return true;
        }
        Project project = element.getProject();
        JavaSdkVersion projectVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)ProjectRootManager.getInstance((Project)project).getProjectSdk());
        if (projectVersion != null && projectVersion.isAtLeast(version)) {
            return true;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            JavaSdkVersion moduleVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)ModuleRootManager.getInstance((Module)module).getSdk());
            if (moduleVersion == null || !moduleVersion.isAtLeast(version)) continue;
            return true;
        }
        return false;
    }
}

