/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ex;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.rt.compiler.JavacRunner;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.ReflectionUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSdkUtil {
    private static final String IDEA_PREPEND_RT_JAR = "idea.prepend.rtjar";

    public static void addRtJar(@NotNull PathsList pathsList) {
        String ideaRtJarPath = JavaSdkUtil.getIdeaRtJarPath();
        if (Boolean.getBoolean(IDEA_PREPEND_RT_JAR)) {
            pathsList.addFirst(ideaRtJarPath);
        } else {
            pathsList.addTail(ideaRtJarPath);
        }
    }

    @NotNull
    public static String getJunit4JarPath() {
        return PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"org.junit.Test"));
    }

    @NotNull
    public static String getJunit3JarPath() {
        return PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"junit.runner.TestSuiteLoader"));
    }

    @NotNull
    public static String getIdeaRtJarPath() {
        return PathUtil.getJarPathForClass(JavacRunner.class);
    }

    @NotNull
    public static List<String> getJUnit4JarPaths() {
        return Arrays.asList(JavaSdkUtil.getJunit4JarPath(), PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"org.hamcrest.Matcher")));
    }

    public static boolean isLanguageLevelAcceptable(@NotNull Project project, @NotNull Module module, @NotNull LanguageLevel level) {
        return JavaSdkUtil.isJdkSupportsLevel(JavaSdkUtil.getRelevantJdk(project, module), level);
    }

    private static boolean isJdkSupportsLevel(@Nullable Sdk jdk, @NotNull LanguageLevel level) {
        if (jdk == null) {
            return true;
        }
        JavaSdkVersion version = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)jdk);
        JavaSdkVersion required = JavaSdkVersion.fromLanguageLevel((LanguageLevel)level);
        return version != null && (level.isPreview() ? version.equals((Object)required) : version.isAtLeast(required));
    }

    @Nullable
    private static Sdk getRelevantJdk(@NotNull Project project, @NotNull Module module) {
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Sdk moduleJdk = ModuleRootManager.getInstance((Module)module).getSdk();
        return moduleJdk == null ? projectJdk : moduleJdk;
    }

    @Contract(value="null, _ -> false")
    public static boolean isJdkAtLeast(@Nullable Sdk jdk, @NotNull JavaSdkVersion expected) {
        return JavaSdkVersionUtil.isAtLeast((Sdk)jdk, (JavaSdkVersion)expected);
    }
}

