/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkTableImpl;
import com.intellij.util.SystemProperties;
import com.intellij.util.lang.JavaVersion;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class JavaAwareProjectJdkTableImpl
extends ProjectJdkTableImpl {
    private final JavaSdk myJavaSdk;
    private Sdk myInternalJdk;

    public static JavaAwareProjectJdkTableImpl getInstanceEx() {
        return (JavaAwareProjectJdkTableImpl)((Object)ServiceManager.getService(ProjectJdkTable.class));
    }

    public JavaAwareProjectJdkTableImpl(@NotNull JavaSdk javaSdk) {
        this.myJavaSdk = javaSdk;
    }

    @NotNull
    public Sdk getInternalJdk() {
        if (this.myInternalJdk == null) {
            String jdkHome = SystemProperties.getJavaHome();
            String versionName = JdkVersionDetector.formatVersionString((JavaVersion)JavaVersion.current());
            this.myInternalJdk = this.myJavaSdk.createJdk(versionName, jdkHome);
        }
        return this.myInternalJdk;
    }

    public void removeJdk(@NotNull Sdk jdk) {
        super.removeJdk(jdk);
        if (jdk.equals(this.myInternalJdk)) {
            this.myInternalJdk = null;
        }
    }

    @NotNull
    public SdkTypeId getDefaultSdkType() {
        return this.myJavaSdk;
    }

    public void loadState(@NotNull Element element) {
        this.myInternalJdk = null;
        try {
            super.loadState(element);
        }
        finally {
            this.getInternalJdk();
        }
    }

    public static void removeInternalJdkInTests() {
        WriteAction.run(() -> {
            JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
            if (table.myInternalJdk != null) {
                table.removeJdk(table.myInternalJdk);
            }
        });
    }
}

