/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;

public class JavaSdkImpl
extends JavaSdk {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.JavaSdkImpl");
    public static final DataKey<Boolean> KEY = DataKey.create((String)"JavaSdk");
    private static final String VM_EXE_NAME = SystemInfo.isWindows ? "java.exe" : "java";
    private final Map<String, String> myCachedSdkHomeToVersionString = new ConcurrentHashMap<String, String>();
    private final Map<String, JavaVersion> myCachedVersionStringToJdkVersion = new ConcurrentHashMap<String, JavaVersion>();

    public JavaSdkImpl(VirtualFileManager fileManager, final FileTypeManager fileTypeManager) {
        super("JavaSDK");
        fileManager.addVirtualFileListener(new VirtualFileListener(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                this.updateCache(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                this.updateCache(event);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                this.updateCache(event);
            }

            private void updateCache(VirtualFileEvent event) {
                if (ArchiveFileType.INSTANCE.equals(fileTypeManager.getFileTypeByFileName(event.getFileName()))) {
                    String filePath = event.getFile().getPath();
                    if (JavaSdkImpl.this.myCachedSdkHomeToVersionString.keySet().removeIf(sdkHome -> FileUtil.isAncestor((String)sdkHome, (String)filePath, (boolean)false))) {
                        JavaSdkImpl.this.myCachedVersionStringToJdkVersion.clear();
                    }
                }
            }
        });
    }

    @NotNull
    public String getPresentableName() {
        return ProjectBundle.message((String)"sdk.java.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.Nodes.PpJdk;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.project.structure.sdk.java";
    }

    @NotNull
    public Icon getIconForAddAction() {
        return AllIcons.General.AddJdk;
    }

    @Nullable
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        JavaSdkVersion version = this.getVersion(sdk);
        if (version != null) {
            if (version == JavaSdkVersion.JDK_1_5) {
                return "https://docs.oracle.com/javase/1.5.0/docs/api/";
            }
            if (version == JavaSdkVersion.JDK_12) {
                return "https://download.java.net/java/early_access/jdk12/docs/api/";
            }
            if (version.compareTo((Enum)JavaSdkVersion.JDK_11) >= 0) {
                return "https://docs.oracle.com/en/java/javase/" + version.ordinal() + "/docs/api/";
            }
            if (version.compareTo((Enum)JavaSdkVersion.JDK_1_6) >= 0) {
                return "https://docs.oracle.com/javase/" + version.ordinal() + "/docs/api/";
            }
        }
        return null;
    }

    @Nullable
    public String getDownloadSdkUrl() {
        return "https://www.oracle.com/technetwork/java/javase/downloads/index.html";
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
    }

    @NotNull
    public Comparator<Sdk> versionComparator() {
        return (sdk1, sdk2) -> {
            assert (sdk1.getSdkType() == this) : sdk1;
            assert (sdk2.getSdkType() == this) : sdk2;
            return Comparing.compare((Comparable)this.getJavaVersion((Sdk)sdk1), (Comparable)this.getJavaVersion((Sdk)sdk2));
        };
    }

    public String getBinPath(@NotNull Sdk sdk) {
        return JavaSdkImpl.getConvertedHomePath(sdk) + "bin";
    }

    public String getToolsPath(@NotNull Sdk sdk) {
        String versionString = sdk.getVersionString();
        boolean isJdk1_x = versionString != null && (versionString.contains("1.0") || versionString.contains("1.1"));
        return JavaSdkImpl.getConvertedHomePath(sdk) + "lib" + File.separator + (isJdk1_x ? "classes.zip" : "tools.jar");
    }

    public String getVMExecutablePath(@NotNull Sdk sdk) {
        return this.getBinPath(sdk) + File.separator + VM_EXE_NAME;
    }

    private static String getConvertedHomePath(Sdk sdk) {
        String homePath = sdk.getHomePath();
        assert (homePath != null) : sdk;
        String path = FileUtil.toSystemDependentName((String)homePath);
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public String suggestHomePath() {
        Collection<String> paths = this.suggestHomePaths();
        return paths.isEmpty() ? null : paths.iterator().next();
    }

    @NotNull
    public Collection<String> suggestHomePaths() {
        return JavaHomeFinder.suggestHomePaths();
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = super.getHomeChooserDescriptor();
        descriptor.putUserData(KEY, (Object)Boolean.TRUE);
        return descriptor;
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        if (SystemInfo.isMac) {
            File home = new File(homePath, "/Home");
            if (home.exists()) {
                return home.getPath();
            }
            home = new File(homePath, "Contents/Home");
            if (home.exists()) {
                return home.getPath();
            }
        }
        return homePath;
    }

    public boolean isValidSdkHome(String path) {
        return JdkUtil.checkForJdk((String)path);
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, String sdkHome) {
        String suggestedName = JdkUtil.suggestJdkName((String)this.getVersionString(sdkHome));
        return suggestedName != null ? suggestedName : (currentSdkName != null ? currentSdkName : "");
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        this.setupSdkPaths(sdk);
        if (sdk.getSdkModificator().getRoots(OrderRootType.CLASSES).length == 0) {
            String title = ProjectBundle.message((String)"sdk.cannot.create", (Object[])new Object[0]);
            String message2 = ProjectBundle.message((String)"sdk.java.no.classes", (Object[])new Object[]{sdk.getHomePath()});
            Messages.showMessageDialog((String)message2, (String)title, (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        String homePath = sdk.getHomePath();
        assert (homePath != null) : sdk;
        File jdkHome = new File(homePath);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        List<String> classes2 = JavaSdkImpl.findClasses(jdkHome, false);
        LinkedHashSet<String> previousRoots = new LinkedHashSet<String>(Arrays.asList(sdkModificator.getUrls(OrderRootType.CLASSES)));
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        previousRoots.removeAll(new HashSet<String>(classes2));
        for (String url : classes2) {
            sdkModificator.addRoot(url, OrderRootType.CLASSES);
        }
        for (String url : previousRoots) {
            sdkModificator.addRoot(url, OrderRootType.CLASSES);
        }
        JavaSdkImpl.addSources(jdkHome, sdkModificator);
        this.addDocs(jdkHome, sdkModificator, sdk);
        JavaSdkImpl.attachJdkAnnotations(sdkModificator);
        sdkModificator.commitChanges();
    }

    public static void attachJdkAnnotations(@NotNull SdkModificator modificator) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        ArrayList<String> pathsChecked = new ArrayList<String>();
        String path = FileUtil.toSystemIndependentName((String)PathManager.getCommunityHomePath()) + "/java/jdkAnnotations";
        VirtualFile root = lfs.findFileByPath(path);
        pathsChecked.add(path);
        if (root == null) {
            String url = "jar://" + FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/lib/jdkAnnotations.jar!/";
            root = VirtualFileManager.getInstance().findFileByUrl(url);
            pathsChecked.add(FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/lib/jdkAnnotations.jar");
        }
        if (root == null) {
            StringBuilder msg = new StringBuilder("Paths checked:\n");
            for (String p : pathsChecked) {
                File f = new File(p);
                msg.append(p).append("; ").append(f.exists()).append("; ").append(Arrays.toString(f.getParentFile().list())).append('\n');
            }
            LOG.error("JDK annotations not found", new String[]{msg.toString()});
            return;
        }
        OrderRootType annoType = AnnotationOrderRootType.getInstance();
        modificator.removeRoot(root, annoType);
        modificator.addRoot(root, annoType);
    }

    public final String getVersionString(String sdkHome) {
        return this.myCachedSdkHomeToVersionString.computeIfAbsent(sdkHome, k -> {
            JdkVersionDetector.JdkVersionInfo jdkInfo = SdkVersionUtil.getJdkVersionInfo((String)k);
            return jdkInfo != null ? JdkVersionDetector.formatVersionString((JavaVersion)jdkInfo.version) : null;
        });
    }

    public JavaSdkVersion getVersion(@NotNull Sdk sdk) {
        JavaVersion version = this.getJavaVersion(sdk);
        return version != null ? JavaSdkVersion.fromJavaVersion((JavaVersion)version) : null;
    }

    private JavaVersion getJavaVersion(Sdk sdk) {
        String versionString = sdk.getVersionString();
        return versionString != null ? this.myCachedVersionStringToJdkVersion.computeIfAbsent(versionString, JavaVersion::tryParse) : null;
    }

    @Nullable
    public JavaSdkVersion getVersion(@NotNull String versionString) {
        return JavaSdkVersion.fromVersionString((String)versionString);
    }

    public boolean isOfVersionOrHigher(@NotNull Sdk sdk, @NotNull JavaSdkVersion version) {
        JavaSdkVersion sdkVersion = this.getVersion(sdk);
        return sdkVersion != null && sdkVersion.isAtLeast(version);
    }

    @NotNull
    public Sdk createJdk(@NotNull String jdkName, @NotNull String home, boolean isJre) {
        ProjectJdkImpl jdk = new ProjectJdkImpl(jdkName, (SdkTypeId)this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.setHomePath(FileUtil.toSystemIndependentName((String)home));
        if (JdkVersionDetector.isVersionString((String)jdkName)) {
            sdkModificator.setVersionString(jdkName);
        }
        File jdkHomeFile = new File(home);
        JavaSdkImpl.addClasses(jdkHomeFile, sdkModificator, isJre);
        JavaSdkImpl.addSources(jdkHomeFile, sdkModificator);
        this.addDocs(jdkHomeFile, sdkModificator, null);
        sdkModificator.commitChanges();
        return jdk;
    }

    @NotNull
    public Sdk createMockJdk(@NotNull String jdkName, @NotNull String home, boolean isJre) {
        String homePath = PathUtil.toSystemIndependentName((String)home);
        File jdkHomeFile = new File(homePath);
        final MultiMap roots = MultiMap.create();
        SdkModificator sdkModificator = new SdkModificator(){

            @NotNull
            public String getName() {
                throw new UnsupportedOperationException();
            }

            public void setName(@NotNull String name) {
                throw new UnsupportedOperationException();
            }

            public String getHomePath() {
                throw new UnsupportedOperationException();
            }

            public void setHomePath(String path) {
                throw new UnsupportedOperationException();
            }

            public String getVersionString() {
                throw new UnsupportedOperationException();
            }

            public void setVersionString(String versionString) {
                throw new UnsupportedOperationException();
            }

            public SdkAdditionalData getSdkAdditionalData() {
                throw new UnsupportedOperationException();
            }

            public void setSdkAdditionalData(SdkAdditionalData data) {
                throw new UnsupportedOperationException();
            }

            @NotNull
            public VirtualFile[] getRoots(@NotNull OrderRootType rootType) {
                throw new UnsupportedOperationException();
            }

            public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
                throw new UnsupportedOperationException();
            }

            public void removeRoots(@NotNull OrderRootType rootType) {
                throw new UnsupportedOperationException();
            }

            public void removeAllRoots() {
                throw new UnsupportedOperationException();
            }

            public void commitChanges() {
                throw new UnsupportedOperationException();
            }

            public boolean isWritable() {
                throw new UnsupportedOperationException();
            }

            public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
                roots.putValue((Object)rootType, (Object)root);
            }
        };
        JavaSdkImpl.addClasses(jdkHomeFile, sdkModificator, isJre);
        JavaSdkImpl.addSources(jdkHomeFile, sdkModificator);
        return new MockSdk(jdkName, homePath, jdkName, roots, (SdkTypeId)this);
    }

    private static void addClasses(@NotNull File file, @NotNull SdkModificator sdkModificator, boolean isJre) {
        for (String url : JavaSdkImpl.findClasses(file, isJre)) {
            sdkModificator.addRoot(url, OrderRootType.CLASSES);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static List<String> readModulesFromReleaseFile(File jrtBaseDir) {
        File releaseFile = new File(jrtBaseDir, "release");
        if (!releaseFile.isFile()) return null;
        Properties p = new Properties();
        try (FileInputStream stream = new FileInputStream(releaseFile);){
            p.load(stream);
            String modules = p.getProperty("MODULES");
            if (modules == null) return null;
            List list = StringUtil.split((String)StringUtil.unquoteString((String)modules), (String)" ");
            return list;
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    @NotNull
    private static List<String> findClasses(@NotNull File file, boolean isJre) {
        ArrayList result = ContainerUtil.newArrayList();
        if (JdkUtil.isExplodedModularRuntime((String)file.getPath())) {
            File[] exploded = new File(file, "modules").listFiles();
            if (exploded != null) {
                for (File root : exploded) {
                    result.add(VfsUtil.getUrlForLibraryRoot((File)root));
                }
            }
        } else if (JdkUtil.isModularRuntime((File)file)) {
            String jrtBaseUrl = "jrt://" + JavaSdkImpl.getPath(file) + "!/";
            List<String> modules = JavaSdkImpl.readModulesFromReleaseFile(file);
            if (modules != null) {
                for (String module : modules) {
                    result.add(jrtBaseUrl + module);
                }
            } else {
                VirtualFile jrt = VirtualFileManager.getInstance().findFileByUrl(jrtBaseUrl);
                if (jrt != null) {
                    for (VirtualFile virtualFile : jrt.getChildren()) {
                        result.add(virtualFile.getUrl());
                    }
                }
            }
        } else {
            for (File root : JavaSdkUtil.getJdkClassesRoots((File)file, (boolean)isJre)) {
                result.add(VfsUtil.getUrlForLibraryRoot((File)root));
            }
        }
        Collections.sort(result);
        return result;
    }

    private static void addSources(@NotNull File jdkHome, @NotNull SdkModificator sdkModificator) {
        VirtualFile fxSrc;
        VirtualFile jdkSrc = JavaSdkImpl.findSources(jdkHome, "src");
        if (jdkSrc != null) {
            if (jdkSrc.findChild("java.base") != null) {
                Stream.of(jdkSrc.getChildren()).filter(VirtualFile::isDirectory).forEach(root -> sdkModificator.addRoot(root, OrderRootType.SOURCES));
            } else {
                sdkModificator.addRoot(jdkSrc, OrderRootType.SOURCES);
            }
        }
        if ((fxSrc = JavaSdkImpl.findSources(jdkHome, "javafx-src")) != null) {
            sdkModificator.addRoot(fxSrc, OrderRootType.SOURCES);
        }
    }

    @Nullable
    private static VirtualFile findSources(File jdkHome, String srcName) {
        File srcArc = new File(jdkHome, srcName + ".jar");
        if (!srcArc.exists()) {
            srcArc = new File(jdkHome, srcName + ".zip");
        }
        if (!srcArc.exists()) {
            srcArc = new File(jdkHome, "lib/" + srcName + ".zip");
        }
        if (srcArc.exists()) {
            VirtualFile srcRoot = JavaSdkImpl.findInJar(srcArc, "src");
            if (srcRoot == null) {
                srcRoot = JavaSdkImpl.findInJar(srcArc, "");
            }
            return srcRoot;
        }
        File srcDir = new File(jdkHome, "src");
        if (srcDir.isDirectory()) {
            return LocalFileSystem.getInstance().findFileByPath(JavaSdkImpl.getPath(srcDir));
        }
        return null;
    }

    private void addDocs(File jdkHome, SdkModificator sdkModificator, @Nullable Sdk sdk) {
        OrderRootType docRootType = JavadocOrderRootType.getInstance();
        VirtualFile apiDocs = JavaSdkImpl.findDocs(jdkHome, "docs/api");
        if (apiDocs != null) {
            sdkModificator.addRoot(apiDocs, docRootType);
        } else if (SystemInfo.isMac) {
            VirtualFile appleDocs;
            VirtualFile commonDocs = JavaSdkImpl.findDocs(jdkHome, "docs");
            if (commonDocs == null) {
                commonDocs = JavaSdkImpl.findInJar(new File(jdkHome, "docs.jar"), "doc/api");
            }
            if (commonDocs == null) {
                commonDocs = JavaSdkImpl.findInJar(new File(jdkHome, "docs.jar"), "docs/api");
            }
            if (commonDocs != null) {
                sdkModificator.addRoot(commonDocs, docRootType);
            }
            if ((appleDocs = JavaSdkImpl.findDocs(jdkHome, "appledocs")) == null) {
                appleDocs = JavaSdkImpl.findInJar(new File(jdkHome, "appledocs.jar"), "appledoc/api");
            }
            if (appleDocs != null) {
                sdkModificator.addRoot(appleDocs, docRootType);
            }
        }
        if (sdk != null && sdkModificator.getRoots(docRootType).length == 0 && sdkModificator.getRoots(OrderRootType.SOURCES).length == 0) {
            VirtualFile fxDocUrl;
            VirtualFile onlineDoc;
            String docUrl = this.getDefaultDocumentationUrl(sdk);
            if (docUrl != null && (onlineDoc = VirtualFileManager.getInstance().findFileByUrl(docUrl)) != null) {
                sdkModificator.addRoot(onlineDoc, docRootType);
            }
            if (this.getVersion(sdk) == JavaSdkVersion.JDK_1_7 && (fxDocUrl = VirtualFileManager.getInstance().findFileByUrl("https://docs.oracle.com/javafx/2/api/")) != null) {
                sdkModificator.addRoot(fxDocUrl, docRootType);
            }
        }
    }

    @Nullable
    private static VirtualFile findDocs(@NotNull File jdkHome, @NotNull String relativePath) {
        File docDir = new File(jdkHome.getAbsolutePath(), relativePath);
        return docDir.isDirectory() ? LocalFileSystem.getInstance().findFileByPath(JavaSdkImpl.getPath(docDir)) : null;
    }

    private static VirtualFile findInJar(File jarFile, String relativePath) {
        if (!jarFile.exists()) {
            return null;
        }
        String url = "jar://" + JavaSdkImpl.getPath(jarFile) + "!/" + relativePath;
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    private static String getPath(File jarFile) {
        return FileUtil.toSystemIndependentName((String)jarFile.getAbsolutePath());
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type2) {
        return type2 == OrderRootType.CLASSES || type2 == OrderRootType.SOURCES || type2 == JavadocOrderRootType.getInstance() || type2 == AnnotationOrderRootType.getInstance();
    }
}

