/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.util.Comparing;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

class WindowsJavaFinder
extends JavaHomeFinder {
    WindowsJavaFinder() {
    }

    @Override
    @NotNull
    protected List<String> findExistingJdks() {
        ArrayList<String> result = new ArrayList<String>();
        Set<File> roots = WindowsJavaFinder.findRootsToScan();
        for (File root : roots) {
            this.scanFolder(root, result);
        }
        result.sort((o1, o2) -> {
            String name1 = new File((String)o1).getName();
            String name2 = new File((String)o2).getName();
            return Comparing.compare((Comparable)JavaSdkVersion.fromVersionString((String)name2), (Comparable)JavaSdkVersion.fromVersionString((String)name1));
        });
        return result;
    }

    private static Set<File> findRootsToScan() {
        File[] fsRoots;
        TreeSet<File> roots = new TreeSet<File>();
        File javaHome = WindowsJavaFinder.getJavaHome();
        if (javaHome != null) {
            roots.add(javaHome);
        }
        for (File root : fsRoots = File.listRoots()) {
            if (!root.exists()) continue;
            File candidate = new File(new File(root, "Program Files"), "Java");
            if (candidate.isDirectory()) {
                roots.add(candidate);
            }
            if (!(candidate = new File(new File(root, "Program Files (x86)"), "Java")).isDirectory()) continue;
            roots.add(candidate);
        }
        return roots;
    }
}

