/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalLibraryDescriptor {
    private static final Logger LOG = Logger.getInstance(ExternalLibraryDescriptor.class);
    private final String myLibraryGroupId;
    @NotNull
    private final String myLibraryArtifactId;
    private final String myMinVersion;
    private final String myMaxVersion;
    private final String myPreferredVersion;

    public ExternalLibraryDescriptor(String libraryGroupId, String libraryArtifactId) {
        this(libraryGroupId, libraryArtifactId, null, null, null);
    }

    public ExternalLibraryDescriptor(@NotNull String libraryGroupId, @NotNull String libraryArtifactId, @Nullable String minVersion, @Nullable String maxVersion) {
        this(libraryGroupId, libraryArtifactId, minVersion, maxVersion, null);
    }

    public ExternalLibraryDescriptor(@NotNull String libraryGroupId, @NotNull String libraryArtifactId, @Nullable String minVersion, @Nullable String maxVersion, @Nullable String preferredVersion) {
        this.myLibraryGroupId = libraryGroupId;
        this.myLibraryArtifactId = libraryArtifactId;
        this.myMinVersion = minVersion;
        this.myMaxVersion = maxVersion;
        this.myPreferredVersion = preferredVersion;
        if (preferredVersion != null && maxVersion != null) {
            LOG.assertTrue(VersionComparatorUtil.compare((String)preferredVersion, (String)maxVersion) <= 0, (Object)("Preferred version (" + preferredVersion + ") must not be newer than max version (" + maxVersion + ")"));
        }
        if (preferredVersion != null && minVersion != null) {
            LOG.assertTrue(VersionComparatorUtil.compare((String)minVersion, (String)preferredVersion) <= 0, (Object)("Preferred version (" + preferredVersion + ") must not be older than min version (" + minVersion + ")"));
        }
        if (minVersion != null && maxVersion != null) {
            LOG.assertTrue(VersionComparatorUtil.compare((String)minVersion, (String)maxVersion) <= 0, (Object)("Max version (" + maxVersion + ") must not be older than min version (" + minVersion + ")"));
        }
    }

    @NotNull
    public String getLibraryGroupId() {
        return this.myLibraryGroupId;
    }

    @NotNull
    public String getLibraryArtifactId() {
        return this.myLibraryArtifactId;
    }

    @Nullable
    public String getMinVersion() {
        return this.myMinVersion;
    }

    @Nullable
    public String getMaxVersion() {
        return this.myMaxVersion;
    }

    @Nullable
    public String getPreferredVersion() {
        return this.myPreferredVersion;
    }

    @NotNull
    public String getPresentableName() {
        return this.myLibraryArtifactId;
    }

    @NotNull
    public List<String> getLibraryClassesRoots() {
        return Collections.emptyList();
    }
}

