/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class CompilerProjectExtensionImpl
extends CompilerProjectExtension {
    private static final String OUTPUT_TAG = "output";
    private static final String URL = "url";
    private VirtualFilePointer myCompilerOutput;
    private LocalFileSystem.WatchRequest myCompilerOutputWatchRequest;
    private final Project myProject;

    public CompilerProjectExtensionImpl(@NotNull Project project) {
        this.myProject = project;
    }

    private void readExternal(Element element) {
        Element pathElement = element.getChild(OUTPUT_TAG);
        if (pathElement != null) {
            String outputPath = pathElement.getAttributeValue(URL);
            this.myCompilerOutput = outputPath != null ? VirtualFilePointerManager.getInstance().create(outputPath, (Disposable)this.myProject, null) : null;
        }
    }

    private void writeExternal(Element element) {
        if (this.myCompilerOutput != null) {
            Element pathElement = new Element(OUTPUT_TAG);
            pathElement.setAttribute(URL, this.myCompilerOutput.getUrl());
            element.addContent(pathElement);
        }
    }

    public VirtualFile getCompilerOutput() {
        return this.myCompilerOutput != null ? this.myCompilerOutput.getFile() : null;
    }

    public String getCompilerOutputUrl() {
        return this.myCompilerOutput != null ? this.myCompilerOutput.getUrl() : null;
    }

    public VirtualFilePointer getCompilerOutputPointer() {
        return this.myCompilerOutput;
    }

    public void setCompilerOutputPointer(VirtualFilePointer pointer) {
        this.myCompilerOutput = pointer;
    }

    public void setCompilerOutputUrl(String compilerOutputUrl) {
        VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(compilerOutputUrl, (Disposable)this.myProject, null);
        this.setCompilerOutputPointer(pointer);
        String path = VfsUtilCore.urlToPath((String)compilerOutputUrl);
        this.myCompilerOutputWatchRequest = LocalFileSystem.getInstance().replaceWatchedRoot(this.myCompilerOutputWatchRequest, path, true);
    }

    @NotNull
    private Set<String> getRootsToWatch() {
        HashSet<String> rootsToWatch = new HashSet<String>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String testOutputUrl;
            CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
            if (extension == null) continue;
            String outputUrl = extension.getCompilerOutputUrl();
            if (!StringUtil.isEmpty((String)outputUrl)) {
                rootsToWatch.add(ProjectRootManagerImpl.extractLocalPath((String)outputUrl));
            }
            if (StringUtil.isEmpty((String)(testOutputUrl = extension.getCompilerOutputUrlForTests()))) continue;
            rootsToWatch.add(ProjectRootManagerImpl.extractLocalPath((String)testOutputUrl));
        }
        if (this.myCompilerOutput != null) {
            rootsToWatch.add(ProjectRootManagerImpl.extractLocalPath((String)this.myCompilerOutput.getUrl()));
        }
        return rootsToWatch;
    }

    private static CompilerProjectExtensionImpl getImpl(Project project) {
        return (CompilerProjectExtensionImpl)CompilerProjectExtension.getInstance((Project)project);
    }

    public static class MyWatchedRootsProvider
    implements WatchedRootsProvider {
        private final Project myProject;

        public MyWatchedRootsProvider(Project project) {
            this.myProject = project;
        }

        @NotNull
        public Set<String> getRootsToWatch() {
            return CompilerProjectExtensionImpl.getImpl(this.myProject).getRootsToWatch();
        }
    }

    public static class MyProjectExtension
    extends ProjectExtension {
        private final Project myProject;

        public MyProjectExtension(Project project) {
            this.myProject = project;
        }

        public void readExternal(@NotNull Element element) {
            CompilerProjectExtensionImpl.getImpl(this.myProject).readExternal(element);
        }

        public void writeExternal(@NotNull Element element) {
            CompilerProjectExtensionImpl.getImpl(this.myProject).writeExternal(element);
        }
    }
}

