/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.JavaLanguageLevelPusher;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ObjectUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageLevelProjectExtensionImpl
extends LanguageLevelProjectExtension {
    private static final String LANGUAGE_LEVEL = "languageLevel";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private final Project myProject;
    private LanguageLevel myLanguageLevel;
    private LanguageLevel myCurrentLevel;

    public LanguageLevelProjectExtensionImpl(Project project) {
        this.myProject = project;
        this.setDefault(project.isDefault() ? Boolean.valueOf(true) : null);
    }

    public static LanguageLevelProjectExtensionImpl getInstanceImpl(Project project) {
        return (LanguageLevelProjectExtensionImpl)LanguageLevelProjectExtensionImpl.getInstance((Project)project);
    }

    private void readExternal(Element element) {
        String level = element.getAttributeValue(LANGUAGE_LEVEL);
        this.myLanguageLevel = level == null ? null : LanguageLevelProjectExtensionImpl.readLanguageLevel(level);
        String aDefault = element.getAttributeValue(DEFAULT_ATTRIBUTE);
        this.setDefault(aDefault == null ? null : Boolean.valueOf(Boolean.parseBoolean(aDefault)));
    }

    private static LanguageLevel readLanguageLevel(String level) {
        for (LanguageLevel languageLevel : LanguageLevel.values()) {
            if (!level.equals(languageLevel.name())) continue;
            return languageLevel;
        }
        return LanguageLevel.HIGHEST;
    }

    private void writeExternal(Element element) {
        Boolean aBoolean;
        if (this.myLanguageLevel != null) {
            element.setAttribute(LANGUAGE_LEVEL, this.myLanguageLevel.name());
        }
        if (!this.myProject.isDefault() && (aBoolean = this.getDefault()) != null) {
            element.setAttribute(DEFAULT_ATTRIBUTE, Boolean.toString(aBoolean));
        }
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        return this.getLanguageLevelOrDefault();
    }

    @NotNull
    private LanguageLevel getLanguageLevelOrDefault() {
        return (LanguageLevel)ObjectUtils.chooseNotNull((Object)this.myLanguageLevel, (Object)LanguageLevel.HIGHEST);
    }

    public void setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (this.myLanguageLevel != languageLevel) {
            this.myLanguageLevel = languageLevel;
            this.languageLevelsChanged();
        }
    }

    public void languageLevelsChanged() {
        if (!this.myProject.isDefault()) {
            ProjectRootManager.getInstance((Project)this.myProject).incModificationCount();
            JavaLanguageLevelPusher.pushLanguageLevel(this.myProject);
        }
    }

    private void projectSdkChanged(@Nullable Sdk sdk) {
        JavaSdkVersion version;
        if (this.isDefault() && sdk != null && (version = JavaSdk.getInstance().getVersion(sdk)) != null) {
            this.setLanguageLevel(version.getMaxLanguageLevel());
        }
    }

    public void setCurrentLevel(LanguageLevel level) {
        this.myCurrentLevel = level;
    }

    public LanguageLevel getCurrentLevel() {
        return this.myCurrentLevel;
    }

    public static class MyProjectExtension
    extends ProjectExtension {
        private final LanguageLevelProjectExtensionImpl myInstance;

        public MyProjectExtension(Project project) {
            this.myInstance = (LanguageLevelProjectExtensionImpl)LanguageLevelProjectExtension.getInstance((Project)project);
        }

        public void readExternal(@NotNull Element element) {
            this.myInstance.readExternal(element);
        }

        public void writeExternal(@NotNull Element element) {
            this.myInstance.writeExternal(element);
        }

        public void projectSdkChanged(@Nullable Sdk sdk) {
            this.myInstance.projectSdkChanged(sdk);
        }
    }
}

