/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.codeStyle.JavaReferenceAdjuster;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQualifiedReference<T extends AbstractQualifiedReference<T>>
extends ASTWrapperPsiElement
implements PsiPolyVariantReference,
PsiQualifiedReferenceElement {
    private static final ResolveCache.PolyVariantResolver<AbstractQualifiedReference> MY_RESOLVER = (expression2, incompleteCode) -> expression2.resolveInner();

    protected AbstractQualifiedReference(@NotNull ASTNode node) {
        super(node);
    }

    public final PsiReference getReference() {
        return this;
    }

    @NotNull
    public final PsiElement getElement() {
        return this;
    }

    @NotNull
    protected abstract ResolveResult[] resolveInner();

    @NotNull
    public final ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file = this.getContainingFile();
        return ResolveCache.getInstance((Project)file.getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, false, file);
    }

    @Nullable
    public final PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    protected boolean processVariantsInner(PsiScopeProcessor processor) {
        T qualifier = this.getQualifier();
        if (qualifier == null) {
            return this.processUnqualifiedVariants(processor);
        }
        PsiElement psiElement = ((AbstractQualifiedReference)((Object)qualifier)).resolve();
        return psiElement == null || psiElement.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)this);
    }

    protected boolean processUnqualifiedVariants(PsiScopeProcessor processor) {
        return PsiScopesUtil.treeWalkUp(processor, (PsiElement)this, null);
    }

    @NotNull
    public String getCanonicalText() {
        return this.getText();
    }

    @Nullable
    public T getQualifier() {
        return (T)((Object)((AbstractQualifiedReference)((Object)this.findChildByClass(((Object)((Object)this)).getClass()))));
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        PsiElement firstChildNode = (PsiElement)ObjectUtils.assertNotNull((Object)this.getFirstChild());
        PsiElement firstInIdentifier = ((Object)((Object)this)).getClass().isInstance(firstChildNode) ? ((PsiElement)ObjectUtils.assertNotNull((Object)firstChildNode.getNextSibling())).getNextSibling() : firstChildNode;
        this.getNode().removeRange(firstInIdentifier.getNode(), null);
        PsiElement referenceName = (PsiElement)ObjectUtils.assertNotNull((Object)((AbstractQualifiedReference)((Object)this.parseReference(newElementName))).getReferenceNameElement());
        this.getNode().addChild(referenceName.getNode());
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String name;
        PsiMetaData metaData;
        CheckUtil.checkWritable((PsiElement)this);
        if (this.isReferenceTo(element)) {
            return this;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String methodName = method.getName();
            if (this.isDirectlyVisible(method)) {
                return this.replaceReference(methodName);
            }
            AbstractQualifiedReference result = this.replaceReference(method.getContainingClass().getQualifiedName() + "." + methodName);
            T qualifier = result.getQualifier();
            assert (qualifier != null);
            ((AbstractQualifiedReference)((Object)qualifier)).shortenReferences();
            return result;
        }
        if (element instanceof PsiClass) {
            return this.replaceReference(((PsiClass)element).getQualifiedName()).shortenReferences();
        }
        if (element instanceof PsiPackage) {
            return this.replaceReference(((PsiPackage)element).getQualifiedName());
        }
        if (element instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)element).getMetaData()) != null && (name = metaData.getName((PsiElement)this)) != null) {
            return this.replaceReference(name);
        }
        return this;
    }

    private boolean isDirectlyVisible(final PsiMethod method) {
        AbstractQualifiedReferenceResolvingProcessor processor = new AbstractQualifiedReferenceResolvingProcessor(){

            @Override
            protected void process(PsiElement element) {
                if (AbstractQualifiedReference.this.getManager().areElementsEquivalent(element, (PsiElement)method) && AbstractQualifiedReference.this.isAccessible(element)) {
                    this.setFound();
                }
            }
        };
        this.processUnqualifiedVariants(processor);
        return processor.isFound();
    }

    protected final AbstractQualifiedReference replaceReference(String newText) {
        ASTNode newNode = this.parseReference(newText).getNode();
        this.getNode().getTreeParent().replaceChild(this.getNode(), newNode);
        return (AbstractQualifiedReference)newNode.getPsi();
    }

    @NotNull
    protected abstract T parseReference(String var1);

    protected boolean isAccessible(PsiElement element) {
        if (element instanceof PsiMember) {
            PsiMember member = (PsiMember)element;
            return JavaResolveUtil.isAccessible(member, member.getContainingClass(), member.getModifierList(), (PsiElement)this, null, null);
        }
        return true;
    }

    @NotNull
    protected AbstractQualifiedReference shortenReferences() {
        PsiQualifiedReferenceElement reference;
        PsiElement refElement = this.resolve();
        if (refElement instanceof PsiClass && (reference = JavaReferenceAdjuster.getClassReferenceToShorten((PsiClass)refElement, false, this)) instanceof AbstractQualifiedReference) {
            ((AbstractQualifiedReference)reference).dequalify();
        }
        return this;
    }

    private void dequalify() {
        T qualifier = this.getQualifier();
        if (qualifier != null) {
            ASTNode separatorNode;
            this.getNode().removeChild(qualifier.getNode());
            PsiElement separator = this.getSeparator();
            if (separator != null && (separatorNode = separator.getNode()) != null) {
                this.getNode().removeChild(separatorNode);
            }
        }
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        PsiManagerEx manager = this.getManager();
        for (ResolveResult result : this.multiResolve(false)) {
            if (!manager.areElementsEquivalent(result.getElement(), element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract PsiElement getSeparator();

    @Nullable
    protected abstract PsiElement getReferenceNameElement();

    @NotNull
    public TextRange getRangeInElement() {
        PsiElement element = this.getSeparator();
        int length = this.getTextLength();
        return element == null ? TextRange.from((int)0, (int)length) : new TextRange(element.getStartOffsetInParent() + element.getTextLength(), length);
    }

    @Nullable
    @NonNls
    public String getReferenceName() {
        PsiElement element = this.getReferenceNameElement();
        return element == null ? null : element.getText().trim();
    }

    public final boolean isSoft() {
        return false;
    }

    protected static abstract class AbstractQualifiedReferenceResolvingProcessor
    implements PsiScopeProcessor {
        private boolean myFound;
        private final Set<ResolveResult> myResults = new LinkedHashSet<ResolveResult>();

        protected AbstractQualifiedReferenceResolvingProcessor() {
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (this.isFound()) {
                return false;
            }
            this.process(element);
            return true;
        }

        protected final void addResult(ResolveResult resolveResult) {
            this.myResults.add(resolveResult);
        }

        private boolean isFound() {
            return this.myFound;
        }

        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
            if (!(event != JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT && event != PsiScopeProcessor.Event.SET_DECLARATION_HOLDER || this.myResults.isEmpty())) {
                this.setFound();
            }
        }

        protected final void setFound() {
            this.myFound = true;
        }

        protected abstract void process(PsiElement var1);

        public Set<ResolveResult> getResults() {
            return this.myResults;
        }
    }
}

