/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class ClassFileViewProvider
extends SingleRootFileViewProvider {
    private static final Key<Boolean> IS_INNER_CLASS = Key.create((String)"java.is.inner.class.key");

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file) {
        this(manager, file, true);
    }

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file, boolean eventSystemEnabled) {
        super(manager, file, eventSystemEnabled, (Language)JavaLanguage.INSTANCE, (FileType)JavaClassFileType.INSTANCE);
    }

    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileType fileType) {
        FileIndexFacade fileIndex = (FileIndexFacade)ServiceManager.getService((Project)project, FileIndexFacade.class);
        if (!fileIndex.isInLibraryClasses(file) && fileIndex.isInSource(file)) {
            return new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), (FileViewProvider)this);
        }
        try {
            if (!ClassFileViewProvider.isInnerClass(file)) {
                return new ClsFileImpl((FileViewProvider)this);
            }
        }
        catch (Exception e) {
            Logger.getInstance(ClassFileViewProvider.class).debug(file.getPath(), (Throwable)e);
        }
        return null;
    }

    public static boolean isInnerClass(@NotNull VirtualFile file) {
        return ClassFileViewProvider.detectInnerClass(file, null);
    }

    public static boolean isInnerClass(@NotNull VirtualFile file, @NotNull byte[] content) {
        return ClassFileViewProvider.detectInnerClass(file, content);
    }

    private static boolean detectInnerClass(VirtualFile file, @Nullable byte[] content) {
        String name = file.getNameWithoutExtension();
        int p = name.lastIndexOf(36, name.length() - 2);
        if (p <= 0) {
            return false;
        }
        Boolean isInner = (Boolean)IS_INNER_CLASS.get((UserDataHolder)file);
        if (isInner != null) {
            return isInner;
        }
        if (content == null) {
            try {
                content = file.contentsToByteArray(false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ClassReader reader = new ClassReader(content);
        final Ref ref = Ref.create((Object)Boolean.FALSE);
        final String className = reader.getClassName();
        reader.accept(new ClassVisitor(458752){

            public void visitOuterClass(String owner, String name, String desc) {
                ref.set((Object)Boolean.TRUE);
            }

            public void visitInnerClass(String name, String outer, String inner, int access) {
                if (className.equals(name)) {
                    ref.set((Object)Boolean.TRUE);
                }
            }
        }, ClsFileImpl.EMPTY_ATTRIBUTES, 7);
        isInner = (Boolean)ref.get();
        IS_INNER_CLASS.set((UserDataHolder)file, (Object)isInner);
        return isInner;
    }

    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        return new ClassFileViewProvider((PsiManager)this.getManager(), copy, false);
    }

    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, this.getBaseLanguage());
    }

    public PsiElement findElementAt(int offset, @NotNull Language language) {
        PsiFile file = this.getPsi(language);
        if (file instanceof PsiCompiledFile) {
            file = ((PsiCompiledFile)file).getDecompiledPsiFile();
        }
        return ClassFileViewProvider.findElementAt((PsiElement)file, (int)offset);
    }

    public PsiReference findReferenceAt(int offset) {
        return this.findReferenceAt(offset, this.getBaseLanguage());
    }

    @Nullable
    public PsiReference findReferenceAt(int offset, @NotNull Language language) {
        PsiFile file = this.getPsi(language);
        if (file instanceof PsiCompiledFile) {
            file = ((PsiCompiledFile)file).getDecompiledPsiFile();
        }
        return ClassFileViewProvider.findReferenceAt((PsiFile)file, (int)offset);
    }
}

