/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.externalSystem.service.project.settings.CodeStyleConfigurationImporter;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaCodeStyleImporter
implements CodeStyleConfigurationImporter<JavaCodeStyleSettings> {
    public void processSettings(@NotNull JavaCodeStyleSettings settings, @NotNull Map config) {
        ObjectUtils.consumeIfCast(config.get("CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND"), Number.class, it -> {
            settings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = it.intValue();
        });
        ObjectUtils.consumeIfCast(config.get("JD_ALIGN_PARAM_COMMENTS"), Boolean.class, it -> {
            settings.JD_ALIGN_PARAM_COMMENTS = it;
        });
        ObjectUtils.consumeIfCast(config.get("JD_ALIGN_EXCEPTION_COMMENTS"), Boolean.class, it -> {
            settings.JD_ALIGN_EXCEPTION_COMMENTS = it;
        });
        ObjectUtils.consumeIfCast(config.get("JD_P_AT_EMPTY_LINES"), Boolean.class, it -> {
            settings.JD_P_AT_EMPTY_LINES = it;
        });
        ObjectUtils.consumeIfCast(config.get("JD_KEEP_EMPTY_PARAMETER"), Boolean.class, it -> {
            settings.JD_KEEP_EMPTY_PARAMETER = it;
        });
        ObjectUtils.consumeIfCast(config.get("JD_KEEP_EMPTY_EXCEPTION"), Boolean.class, it -> {
            settings.JD_KEEP_EMPTY_EXCEPTION = it;
        });
        ObjectUtils.consumeIfCast(config.get("JD_KEEP_EMPTY_RETURN"), Boolean.class, it -> {
            settings.JD_KEEP_EMPTY_RETURN = it;
        });
    }

    public boolean canImport(@NotNull String langName) {
        return "java".equals(langName);
    }

    @NotNull
    public Class<JavaCodeStyleSettings> getCustomClass() {
        return JavaCodeStyleSettings.class;
    }

    @NotNull
    public Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }
}

