/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntryDependencyInfo;
import com.intellij.psi.codeStyle.arrangement.FieldDependenciesManager;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementOverriddenMethodsInfo;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementPropertyInfo;
import com.intellij.psi.codeStyle.arrangement.JavaElementArrangementEntry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaArrangementParseInfo {
    private final List<JavaElementArrangementEntry> myEntries = new ArrayList<JavaElementArrangementEntry>();
    private final Map<Pair<String, String>, JavaArrangementPropertyInfo> myProperties = new HashMap<Pair<String, String>, JavaArrangementPropertyInfo>();
    private final List<ArrangementEntryDependencyInfo> myMethodDependencyRoots = new ArrayList<ArrangementEntryDependencyInfo>();
    private final Map<PsiMethod, Set<PsiMethod>> myMethodDependencies = new HashMap<PsiMethod, Set<PsiMethod>>();
    private final Map<PsiMethod, JavaElementArrangementEntry> myMethodEntriesMap = new HashMap<PsiMethod, JavaElementArrangementEntry>();
    private final Map<PsiClass, List<OverriddenMethodPair>> myOverriddenMethods = new LinkedHashMap<PsiClass, List<OverriddenMethodPair>>();
    private final Set<PsiMethod> myTmpMethodDependencyRoots = new LinkedHashSet<PsiMethod>();
    private final Set<PsiMethod> myDependentMethods = new HashSet<PsiMethod>();
    private boolean myRebuildMethodDependencies;
    private final HashMap<PsiField, JavaElementArrangementEntry> myFields = ContainerUtil.newLinkedHashMap();
    private final Map<PsiField, Set<PsiField>> myFieldDependencies = ContainerUtil.newHashMap();

    @NotNull
    public List<JavaElementArrangementEntry> getEntries() {
        return this.myEntries;
    }

    public void addEntry(@NotNull JavaElementArrangementEntry entry) {
        this.myEntries.add(entry);
    }

    @NotNull
    public Collection<JavaArrangementPropertyInfo> getProperties() {
        return this.myProperties.values();
    }

    @NotNull
    public List<ArrangementEntryDependencyInfo> getMethodDependencyRoots() {
        if (this.myRebuildMethodDependencies) {
            this.myMethodDependencyRoots.clear();
            HashMap<PsiMethod, ArrangementEntryDependencyInfo> cache = new HashMap<PsiMethod, ArrangementEntryDependencyInfo>();
            for (PsiMethod method : this.myTmpMethodDependencyRoots) {
                ArrangementEntryDependencyInfo info = this.buildMethodDependencyInfo(method, cache);
                if (info == null) continue;
                this.myMethodDependencyRoots.add(info);
            }
            this.myRebuildMethodDependencies = false;
        }
        return this.myMethodDependencyRoots;
    }

    @Nullable
    private ArrangementEntryDependencyInfo buildMethodDependencyInfo(@NotNull PsiMethod method, @NotNull Map<PsiMethod, ArrangementEntryDependencyInfo> cache) {
        JavaElementArrangementEntry entry = this.myMethodEntriesMap.get(method);
        if (entry == null) {
            return null;
        }
        ArrangementEntryDependencyInfo result = new ArrangementEntryDependencyInfo(entry);
        Stack toProcess = new Stack();
        toProcess.push((Object)Pair.create((Object)method, (Object)result));
        HashSet usedMethods = ContainerUtilRt.newHashSet();
        while (!toProcess.isEmpty()) {
            Pair pair = (Pair)toProcess.pop();
            Set<PsiMethod> dependentMethods = this.myMethodDependencies.get(pair.first);
            if (dependentMethods == null) continue;
            usedMethods.add(pair.first);
            for (PsiMethod dependentMethod : dependentMethods) {
                if (usedMethods.contains(dependentMethod)) {
                    return null;
                }
                JavaElementArrangementEntry dependentEntry = this.myMethodEntriesMap.get(dependentMethod);
                if (dependentEntry == null) continue;
                ArrangementEntryDependencyInfo dependentMethodInfo = cache.get(dependentMethod);
                if (dependentMethodInfo == null) {
                    dependentMethodInfo = new ArrangementEntryDependencyInfo(dependentEntry);
                    cache.put(dependentMethod, dependentMethodInfo);
                }
                Pair dependentPair = Pair.create((Object)dependentMethod, (Object)dependentMethodInfo);
                ((ArrangementEntryDependencyInfo)pair.second).addDependentEntryInfo((ArrangementEntryDependencyInfo)dependentPair.second);
                toProcess.push((Object)dependentPair);
            }
        }
        return result;
    }

    public void registerGetter(@NotNull String propertyName, @NotNull String className, @NotNull JavaElementArrangementEntry entry) {
        this.getPropertyInfo(propertyName, className).setGetter(entry);
    }

    public void registerSetter(@NotNull String propertyName, @NotNull String className, @NotNull JavaElementArrangementEntry entry) {
        this.getPropertyInfo(propertyName, className).addSetter(entry);
    }

    @NotNull
    private JavaArrangementPropertyInfo getPropertyInfo(@NotNull String propertyName, @NotNull String className) {
        Pair key2 = Pair.create((Object)propertyName, (Object)className);
        JavaArrangementPropertyInfo propertyInfo = this.myProperties.get(key2);
        if (propertyInfo == null) {
            propertyInfo = new JavaArrangementPropertyInfo();
            this.myProperties.put((Pair<String, String>)key2, propertyInfo);
        }
        return propertyInfo;
    }

    public void onMethodEntryCreated(@NotNull PsiMethod method, @NotNull JavaElementArrangementEntry entry) {
        this.myMethodEntriesMap.put(method, entry);
    }

    public void onFieldEntryCreated(@NotNull PsiField field, @NotNull JavaElementArrangementEntry entry) {
        this.myFields.put(field, entry);
    }

    public void onOverriddenMethod(@NotNull PsiMethod baseMethod, @NotNull PsiMethod overridingMethod) {
        PsiClass clazz = baseMethod.getContainingClass();
        if (clazz == null) {
            return;
        }
        List<OverriddenMethodPair> methods = this.myOverriddenMethods.get(clazz);
        if (methods == null) {
            methods = new ArrayList<OverriddenMethodPair>();
            this.myOverriddenMethods.put(clazz, methods);
        }
        methods.add(new OverriddenMethodPair(baseMethod, overridingMethod));
    }

    @NotNull
    public List<JavaArrangementOverriddenMethodsInfo> getOverriddenMethods() {
        ArrayList<JavaArrangementOverriddenMethodsInfo> result = new ArrayList<JavaArrangementOverriddenMethodsInfo>();
        for (Map.Entry<PsiClass, List<OverriddenMethodPair>> entry : this.myOverriddenMethods.entrySet()) {
            String name = entry.getKey().getName();
            Map<PsiClass, List<OverriddenMethodPair>> groupedByClass = entry.getValue().stream().collect(Collectors.groupingBy(pair -> pair.overriding.getContainingClass()));
            for (Map.Entry<PsiClass, List<OverriddenMethodPair>> listEntry : groupedByClass.entrySet()) {
                JavaArrangementOverriddenMethodsInfo info = new JavaArrangementOverriddenMethodsInfo(name);
                result.add(info);
                List<OverriddenMethodPair> value2 = listEntry.getValue();
                value2.sort(Comparator.comparingInt(pair -> pair.overridden.getTextOffset()));
                for (OverriddenMethodPair methodPair : value2) {
                    JavaElementArrangementEntry methodEntry = this.myMethodEntriesMap.get(methodPair.overriding);
                    info.addMethodEntry(methodEntry);
                }
            }
        }
        return result;
    }

    public void registerMethodCallDependency(@NotNull PsiMethod caller, @NotNull PsiMethod callee) {
        this.myTmpMethodDependencyRoots.remove(callee);
        if (!this.myDependentMethods.contains(caller)) {
            this.myTmpMethodDependencyRoots.add(caller);
        }
        this.myDependentMethods.add(callee);
        Set<PsiMethod> methods = this.myMethodDependencies.get(caller);
        if (methods == null) {
            methods = new LinkedHashSet<PsiMethod>();
            this.myMethodDependencies.put(caller, methods);
        }
        methods.add(callee);
        this.myRebuildMethodDependencies = true;
    }

    public void registerFieldInitializationDependency(@NotNull PsiField fieldToInitialize, @NotNull PsiField usedInInitialization) {
        HashSet fields = this.myFieldDependencies.get(fieldToInitialize);
        if (fields == null) {
            fields = ContainerUtil.newHashSet();
            this.myFieldDependencies.put(fieldToInitialize, fields);
        }
        fields.add(usedInInitialization);
    }

    @NotNull
    public List<ArrangementEntryDependencyInfo> getFieldDependencyRoots() {
        return new FieldDependenciesManager(this.myFieldDependencies, this.myFields).getRoots();
    }

    @NotNull
    public Collection<JavaElementArrangementEntry> getFields() {
        return this.myFields.values();
    }

    private static class OverriddenMethodPair {
        @NotNull
        final PsiMethod overridden;
        @NotNull
        final PsiMethod overriding;

        private OverriddenMethodPair(@NotNull PsiMethod overridden, @NotNull PsiMethod overriding) {
            this.overridden = overridden;
            this.overriding = overriding;
        }
    }
}

