/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.psi.PsiElement;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ControlFlowSubRange
implements ControlFlow {
    private final ControlFlow myControlFlow;
    private final int myStart;
    private final int myEnd;
    private List<Instruction> myInstructions;

    public ControlFlowSubRange(ControlFlow controlFlow, int start, int end) {
        this.myControlFlow = controlFlow;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    @NotNull
    public List<Instruction> getInstructions() {
        if (this.myInstructions == null) {
            ArrayList<Instruction> list = new ArrayList<Instruction>(this.myEnd - this.myStart);
            List<Instruction> oldList = this.myControlFlow.getInstructions();
            for (int i = this.myStart; i < this.myEnd; ++i) {
                Instruction instruction = oldList.get(i).clone();
                if (instruction instanceof BranchingInstruction) {
                    BranchingInstruction branchingInstruction = (BranchingInstruction)instruction;
                    branchingInstruction.offset = this.patchOffset(branchingInstruction.offset);
                }
                if (instruction instanceof CallInstruction) {
                    CallInstruction callInstruction = (CallInstruction)instruction;
                    callInstruction.procBegin = this.patchOffset(callInstruction.procBegin);
                    callInstruction.procEnd = this.patchOffset(callInstruction.procEnd);
                }
                if (instruction instanceof ReturnInstruction) {
                    ReturnInstruction returnInstruction = (ReturnInstruction)instruction;
                    CallInstruction callInstruction = new CallInstruction(this.patchOffset(returnInstruction.getProcBegin()), this.patchOffset(returnInstruction.getProcEnd()), returnInstruction.getStack());
                    returnInstruction.setCallInstruction(callInstruction);
                }
                list.add(instruction);
            }
            this.myInstructions = list;
        }
        return this.myInstructions;
    }

    private int patchOffset(int offset) {
        if (offset < this.myStart) {
            offset = this.myStart;
        } else if (offset > this.myEnd) {
            offset = this.myEnd;
        }
        return offset -= this.myStart;
    }

    @Override
    public int getSize() {
        return this.myEnd - this.myStart;
    }

    @Override
    public int getStartOffset(@NotNull PsiElement element) {
        return this.patchOffset(this.myControlFlow.getStartOffset(element));
    }

    @Override
    public int getEndOffset(@NotNull PsiElement element) {
        return this.patchOffset(this.myControlFlow.getEndOffset(element));
    }

    @Override
    public PsiElement getElement(int offset) {
        return this.myControlFlow.getElement(this.myStart + offset);
    }

    @Override
    public boolean isConstantConditionOccurred() {
        return this.myControlFlow.isConstantConditionOccurred();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CF range:[").append(this.myStart).append("-").append(this.myEnd).append("]\n");
        List<Instruction> instructions = this.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            buffer.append(i).append(": ").append(instruction.toString()).append("\n");
        }
        return buffer.toString();
    }
}

