/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import com.intellij.psi.controlFlow.ControlFlowStack;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.InstructionClientVisitor;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.ReturnStatementsVisitor;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.containers.IntStack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.controlFlow.ControlFlowUtil");
    public static final Class<? extends PsiStatement>[] DEFAULT_EXIT_STATEMENTS_CLASSES = new Class[]{PsiReturnStatement.class, PsiBreakStatement.class, PsiContinueStatement.class};
    public static final int NORMAL_COMPLETION_REASON = 1;
    private static final int RETURN_COMPLETION_REASON = 2;

    @NotNull
    public static List<PsiVariable> getSSAVariables(@NotNull ControlFlow flow) {
        return ControlFlowUtil.getSSAVariables(flow, 0, flow.getSize(), false);
    }

    @NotNull
    public static List<PsiVariable> getSSAVariables(@NotNull ControlFlow flow, int from, int to, boolean reportVarsIfNonInitializingPathExists) {
        List<Instruction> instructions = flow.getInstructions();
        Collection<PsiVariable> writtenVariables = ControlFlowUtil.getWrittenVariables(flow, from, to, false);
        ArrayList<PsiVariable> result = new ArrayList<PsiVariable>(1);
        block0: for (PsiVariable psiVariable : writtenVariables) {
            ArrayList<SSAInstructionState> queue = new ArrayList<SSAInstructionState>();
            queue.add(new SSAInstructionState(0, from));
            THashSet processedStates = new THashSet();
            while (!queue.isEmpty()) {
                SSAInstructionState state = (SSAInstructionState)queue.remove(0);
                if (state.getWriteCount() > 1) continue block0;
                if (processedStates.contains(state)) continue;
                processedStates.add(state);
                int i = state.getInstructionIdx();
                if (i < to) {
                    Instruction instruction = instructions.get(i);
                    if (instruction instanceof ReturnInstruction) {
                        int[] offsets;
                        for (int offset : offsets = ((ReturnInstruction)instruction).getPossibleReturnOffsets()) {
                            queue.add(new SSAInstructionState(state.getWriteCount(), Math.min(offset, to)));
                        }
                        continue;
                    }
                    if (instruction instanceof GoToInstruction) {
                        int nextOffset = ((GoToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state.getWriteCount(), nextOffset));
                        continue;
                    }
                    if (instruction instanceof ThrowToInstruction) {
                        int nextOffset = ((ThrowToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state.getWriteCount(), nextOffset));
                        continue;
                    }
                    if (instruction instanceof ConditionalGoToInstruction) {
                        int nextOffset = ((ConditionalGoToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state.getWriteCount(), nextOffset));
                        queue.add(new SSAInstructionState(state.getWriteCount(), i + 1));
                        continue;
                    }
                    if (instruction instanceof ConditionalThrowToInstruction) {
                        int nextOffset = ((ConditionalThrowToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state.getWriteCount(), nextOffset));
                        queue.add(new SSAInstructionState(state.getWriteCount(), i + 1));
                        continue;
                    }
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction write = (WriteVariableInstruction)instruction;
                        queue.add(new SSAInstructionState(state.getWriteCount() + (write.variable == psiVariable ? 1 : 0), i + 1));
                        continue;
                    }
                    if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction read2 = (ReadVariableInstruction)instruction;
                        if (read2.variable == psiVariable && state.getWriteCount() == 0) continue block0;
                        queue.add(new SSAInstructionState(state.getWriteCount(), i + 1));
                        continue;
                    }
                    queue.add(new SSAInstructionState(state.getWriteCount(), i + 1));
                    continue;
                }
                if (reportVarsIfNonInitializingPathExists || state.getWriteCount() != 0) continue;
                continue block0;
            }
            result.add(psiVariable);
        }
        return result;
    }

    public static boolean needVariableValueAt(final @NotNull PsiVariable variable, final @NotNull ControlFlow flow, final int offset) {
        InstructionClientVisitor<Boolean> visitor = new InstructionClientVisitor<Boolean>(){
            final boolean[] neededBelow;
            {
                this.neededBelow = new boolean[flow.getSize() + 1];
            }

            @Override
            public void procedureEntered(int startOffset, int endOffset) {
                for (int i = startOffset; i < endOffset; ++i) {
                    this.neededBelow[i] = false;
                }
            }

            @Override
            public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                if (instruction.variable.equals(variable)) {
                    needed = true;
                }
                int n = offset2;
                this.neededBelow[n] = this.neededBelow[n] | needed;
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                if (instruction.variable.equals(variable)) {
                    needed = false;
                }
                this.neededBelow[offset2] = needed;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                int n = offset2;
                this.neededBelow[n] = this.neededBelow[n] | needed;
            }

            @Override
            public Boolean getResult() {
                return this.neededBelow[offset];
            }
        };
        ControlFlowUtil.depthFirstSearch(flow, visitor, offset, flow.getSize());
        return (Boolean)visitor.getResult();
    }

    @NotNull
    public static Collection<PsiVariable> getWrittenVariables(@NotNull ControlFlow flow, int start, int end, boolean ignoreNotReachingWrites) {
        HashSet<PsiVariable> set = new HashSet<PsiVariable>();
        ControlFlowUtil.getWrittenVariables(flow, start, end, ignoreNotReachingWrites, set);
        return set;
    }

    public static void getWrittenVariables(@NotNull ControlFlow flow, int start, int end, boolean ignoreNotReachingWrites, @NotNull Collection<? super PsiVariable> set) {
        List<Instruction> instructions = flow.getInstructions();
        for (int i = start; i < end; ++i) {
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof WriteVariableInstruction) || ignoreNotReachingWrites && !ControlFlowUtil.isInstructionReachable(flow, end, i)) continue;
            set.add((PsiVariable)((WriteVariableInstruction)instruction).variable);
        }
    }

    @NotNull
    public static List<PsiVariable> getUsedVariables(@NotNull ControlFlow flow, int start, int end) {
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        if (start < 0) {
            return array;
        }
        List<Instruction> instructions = flow.getInstructions();
        for (int i = start; i < end; ++i) {
            PsiVariable variable;
            Instruction instruction = instructions.get(i);
            if (instruction instanceof ReadVariableInstruction) {
                variable = ((ReadVariableInstruction)instruction).variable;
                if (array.contains(variable)) continue;
                array.add(variable);
                continue;
            }
            if (!(instruction instanceof WriteVariableInstruction) || array.contains(variable = ((WriteVariableInstruction)instruction).variable)) continue;
            array.add(variable);
        }
        return array;
    }

    public static boolean isVariableUsed(@NotNull ControlFlow flow, int start, int end, @NotNull PsiVariable variable) {
        List<Instruction> instructions = flow.getInstructions();
        LOG.assertTrue(start >= 0, (Object)"flow start");
        LOG.assertTrue(end <= instructions.size(), (Object)"flow end");
        for (int i = start; i < end; ++i) {
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof ReadVariableInstruction ? ((ReadVariableInstruction)instruction).variable == variable : instruction instanceof WriteVariableInstruction && ((WriteVariableInstruction)instruction).variable == variable)) continue;
            return true;
        }
        return false;
    }

    private static int findSingleReadOffset(@NotNull ControlFlow flow, int startOffset, int endOffset, @NotNull PsiVariable variable) {
        List<Instruction> instructions = flow.getInstructions();
        if (startOffset < 0 || endOffset < 0 || endOffset > instructions.size()) {
            return -1;
        }
        int readOffset = -1;
        for (int i = startOffset; i < endOffset; ++i) {
            Instruction instruction = instructions.get(i);
            if (instruction instanceof ReadVariableInstruction) {
                if (((ReadVariableInstruction)instruction).variable != variable) continue;
                if (readOffset < 0) {
                    readOffset = i;
                    continue;
                }
                return -1;
            }
            if (!(instruction instanceof WriteVariableInstruction) || ((WriteVariableInstruction)instruction).variable != variable) continue;
            return -1;
        }
        return readOffset;
    }

    public static PsiReferenceExpression findSingleReadOccurrence(@NotNull ControlFlow flow, @NotNull PsiElement element, @NotNull PsiVariable variable) {
        int readOffset = ControlFlowUtil.findSingleReadOffset(flow, flow.getStartOffset(element), flow.getEndOffset(element), variable);
        if (readOffset >= 0) {
            PsiElement readElement = flow.getElement(readOffset);
            if ((readElement = PsiTreeUtil.findFirstParent((PsiElement)readElement, (boolean)false, e -> e == element || e instanceof PsiReferenceExpression)) instanceof PsiReferenceExpression) {
                return (PsiReferenceExpression)readElement;
            }
        }
        return null;
    }

    public static boolean isVariableReadInFinally(@NotNull ControlFlow flow, @Nullable PsiElement startElement, @NotNull PsiElement enclosingCodeFragment, @NotNull PsiVariable variable) {
        for (PsiElement element = startElement; element != null && element != enclosingCodeFragment; element = element.getParent()) {
            PsiCodeBlock finallyBlock;
            PsiTryStatement tryStatement;
            PsiElement parent;
            if (!(element instanceof PsiCodeBlock) || !((parent = element.getParent()) instanceof PsiTryStatement) || (tryStatement = (PsiTryStatement)parent).getTryBlock() != element || (finallyBlock = tryStatement.getFinallyBlock()) == null) continue;
            List<Instruction> instructions = flow.getInstructions();
            int startOffset = flow.getStartOffset((PsiElement)finallyBlock);
            int endOffset = flow.getEndOffset((PsiElement)finallyBlock);
            LOG.assertTrue(startOffset >= 0, (Object)"flow start");
            LOG.assertTrue(endOffset <= instructions.size(), (Object)"flow end");
            for (int i = startOffset; i < endOffset; ++i) {
                Instruction instruction = instructions.get(i);
                if (!(instruction instanceof ReadVariableInstruction) || ((ReadVariableInstruction)instruction).variable != variable) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static List<PsiVariable> getInputVariables(@NotNull ControlFlow flow, int start, int end) {
        List<PsiVariable> usedVariables = ControlFlowUtil.getUsedVariables(flow, start, end);
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>(usedVariables.size());
        for (PsiVariable variable : usedVariables) {
            if (!ControlFlowUtil.needVariableValueAt(variable, flow, start)) continue;
            array.add(variable);
        }
        return array;
    }

    @NotNull
    public static PsiVariable[] getOutputVariables(@NotNull ControlFlow flow, int start, int end, @NotNull int[] exitPoints) {
        Collection<PsiVariable> writtenVariables = ControlFlowUtil.getWrittenVariables(flow, start, end, false);
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        for (PsiVariable variable : writtenVariables) {
            int[] nArray = exitPoints;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int exitPoint = nArray[i];
                if (!ControlFlowUtil.needVariableValueAt(variable, flow, exitPoint)) continue;
                array.add(variable);
            }
        }
        PsiVariable[] outputVariables = array.toArray(new PsiVariable[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("output variables:");
            for (PsiVariable variable : outputVariables) {
                LOG.debug("  " + variable);
            }
        }
        return outputVariables;
    }

    @NotNull
    public static Collection<PsiStatement> findExitPointsAndStatements(@NotNull ControlFlow flow, int start, int end, @NotNull IntArrayList exitPoints, Class<? extends PsiStatement> ... classesFilter) {
        if (end == start) {
            exitPoints.add(end);
            return Collections.emptyList();
        }
        THashSet exitStatements = new THashSet();
        InstructionClientVisitor visitor = new InstructionClientVisitor((Collection)exitStatements, flow, classesFilter, start, end, exitPoints){
            final /* synthetic */ Collection val$exitStatements;
            final /* synthetic */ ControlFlow val$flow;
            final /* synthetic */ Class[] val$classesFilter;
            final /* synthetic */ int val$start;
            final /* synthetic */ int val$end;
            final /* synthetic */ IntArrayList val$exitPoints;
            {
                this.val$exitStatements = collection;
                this.val$flow = controlFlow;
                this.val$classesFilter = classArray;
                this.val$start = n;
                this.val$end = n2;
                this.val$exitPoints = intArrayList;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                ControlFlowUtil.processGotoStatement(this.val$exitStatements, ControlFlowUtil.findStatement(this.val$flow, offset), this.val$classesFilter);
            }

            @Override
            public void visitBranchingInstruction(BranchingInstruction instruction, int offset, int nextOffset) {
                ControlFlowUtil.processGoto(this.val$flow, this.val$start, this.val$end, this.val$exitPoints, this.val$exitStatements, instruction, ControlFlowUtil.findStatement(this.val$flow, offset), this.val$classesFilter);
            }

            @Override
            public void visitReturnInstruction(ReturnInstruction instruction, int offset, int nextOffset) {
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                this.visitInstruction(instruction, offset, nextOffset);
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (offset >= this.val$end - 1) {
                    int exitOffset = this.val$end;
                    if (!this.val$exitPoints.contains(exitOffset = ControlFlowUtil.promoteThroughGotoChain(this.val$flow, exitOffset))) {
                        this.val$exitPoints.add(exitOffset);
                    }
                }
            }

            public Object getResult() {
                return null;
            }
        };
        ControlFlowUtil.depthFirstSearch(flow, visitor, start, end);
        return exitStatements;
    }

    private static void processGoto(@NotNull ControlFlow flow, int start, int end, @NotNull IntArrayList exitPoints, @NotNull Collection<? super PsiStatement> exitStatements, @NotNull BranchingInstruction instruction, PsiStatement statement, Class ... classesFilter) {
        if (statement == null) {
            return;
        }
        int gotoOffset = instruction.offset;
        if (start > gotoOffset || gotoOffset >= end || ControlFlowUtil.isElementOfClass((PsiElement)statement, classesFilter)) {
            if (!((gotoOffset = ControlFlowUtil.promoteThroughGotoChain(flow, gotoOffset)) <= 0 || gotoOffset < end && gotoOffset >= start || exitPoints.contains(gotoOffset))) {
                exitPoints.add(gotoOffset);
            }
            if (gotoOffset >= end || gotoOffset < start) {
                ControlFlowUtil.processGotoStatement(exitStatements, statement, classesFilter);
            } else {
                boolean isReturn = instruction instanceof GoToInstruction && ((GoToInstruction)instruction).isReturn;
                Instruction gotoInstruction = flow.getInstructions().get(gotoOffset);
                if (isReturn |= gotoInstruction instanceof GoToInstruction && ((GoToInstruction)gotoInstruction).isReturn) {
                    ControlFlowUtil.processGotoStatement(exitStatements, statement, classesFilter);
                }
            }
        }
    }

    private static void processGotoStatement(@NotNull Collection<? super PsiStatement> exitStatements, PsiStatement statement, Class ... classesFilter) {
        if (statement != null && ControlFlowUtil.isElementOfClass((PsiElement)statement, classesFilter)) {
            exitStatements.add((PsiStatement)statement);
        }
    }

    private static boolean isElementOfClass(@NotNull PsiElement element, Class ... classesFilter) {
        for (Class aClassesFilter : classesFilter) {
            if (!ReflectionUtil.isAssignable((Class)aClassesFilter, element.getClass())) continue;
            return true;
        }
        return false;
    }

    private static int promoteThroughGotoChain(@NotNull ControlFlow flow, int offset) {
        Instruction instruction;
        List<Instruction> instructions = flow.getInstructions();
        while (offset < instructions.size() && (instruction = instructions.get(offset)) instanceof GoToInstruction && !((GoToInstruction)instruction).isReturn) {
            offset = ((BranchingInstruction)instruction).offset;
        }
        return offset;
    }

    private static PsiStatement findStatement(@NotNull ControlFlow flow, int offset) {
        PsiElement element = flow.getElement(offset);
        return (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)false);
    }

    public static boolean hasObservableThrowExitPoints(final @NotNull ControlFlow flow, final int flowStart, final int flowEnd, @NotNull PsiElement[] elements, @NotNull PsiElement enclosingCodeFragment) {
        final List<Instruction> instructions = flow.getInstructions();
        class Worker {
            Worker() {
            }

            @NotNull
            private Map<PsiVariable, IntArrayList> getWritesOffsets() {
                THashMap writeOffsets = new THashMap();
                for (int i = flowStart; i < flowEnd; ++i) {
                    PsiVariable variable;
                    Instruction instruction = (Instruction)instructions.get(i);
                    if (!(instruction instanceof WriteVariableInstruction) || !((variable = ((WriteVariableInstruction)instruction).variable) instanceof PsiLocalVariable) && !(variable instanceof PsiParameter)) continue;
                    IntArrayList offsets = (IntArrayList)writeOffsets.get(variable);
                    if (offsets == null) {
                        offsets = new IntArrayList();
                        writeOffsets.put(variable, offsets);
                    }
                    offsets.add(i);
                }
                LOG.debug("writeOffsets:", new Object[]{writeOffsets});
                return writeOffsets;
            }

            @NotNull
            private Map<PsiVariable, IntArrayList> getVisibleReadsOffsets(@NotNull Map<PsiVariable, IntArrayList> writeOffsets, @NotNull PsiCodeBlock tryBlock) {
                THashMap visibleReadOffsets = new THashMap();
                for (PsiVariable variable : writeOffsets.keySet()) {
                    if (PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)variable, (boolean)true)) continue;
                    visibleReadOffsets.put(variable, new IntArrayList());
                }
                if (visibleReadOffsets.isEmpty()) {
                    return visibleReadOffsets;
                }
                for (int i = 0; i < instructions.size(); ++i) {
                    PsiVariable variable;
                    IntArrayList readOffsets;
                    Instruction instruction = (Instruction)instructions.get(i);
                    if (!(instruction instanceof ReadVariableInstruction) || (readOffsets = (IntArrayList)visibleReadOffsets.get(variable = ((ReadVariableInstruction)instruction).variable)) == null) continue;
                    readOffsets.add(i);
                }
                LOG.debug("visibleReadOffsets:", new Object[]{visibleReadOffsets});
                return visibleReadOffsets;
            }

            @NotNull
            private Map<PsiVariable, Set<PsiElement>> getReachableAfterWrite(@NotNull Map<PsiVariable, IntArrayList> writeOffsets, @NotNull Map<PsiVariable, IntArrayList> visibleReadOffsets) {
                THashMap afterWrite = new THashMap();
                for (PsiVariable variable : visibleReadOffsets.keySet()) {
                    Function<Integer, BitSet> calculator = this.getReachableInstructionsCalculator();
                    BitSet collectedOffsets = new BitSet(flowEnd);
                    for (int writeOffset : writeOffsets.get(variable).toArray()) {
                        LOG.assertTrue(writeOffset >= flowStart, (Object)"writeOffset");
                        BitSet reachableOffsets = (BitSet)calculator.fun((Object)writeOffset);
                        collectedOffsets.or(reachableOffsets);
                    }
                    Set throwSources = (Set)afterWrite.get(variable);
                    if (throwSources == null) {
                        throwSources = new THashSet();
                        afterWrite.put(variable, throwSources);
                    }
                    for (int i = flowStart; i < flowEnd; ++i) {
                        if (!collectedOffsets.get(i)) continue;
                        throwSources.add(flow.getElement(i));
                    }
                    ArrayList<PsiElement> subordinates = new ArrayList<PsiElement>();
                    for (PsiElement element : throwSources) {
                        if (!throwSources.contains(element.getParent())) continue;
                        subordinates.add(element);
                    }
                    throwSources.removeAll(subordinates);
                }
                LOG.debug("afterWrite:", new Object[]{afterWrite});
                return afterWrite;
            }

            @NotNull
            private IntArrayList getCatchOrFinallyOffsets(@NotNull List<? extends PsiTryStatement> tryStatements, @NotNull List<? extends PsiClassType> thrownExceptions) {
                IntArrayList catchOrFinallyOffsets = new IntArrayList();
                for (PsiTryStatement psiTryStatement : tryStatements) {
                    int offset;
                    PsiCodeBlock finallyBlock = psiTryStatement.getFinallyBlock();
                    if (finallyBlock != null && (offset = flow.getStartOffset((PsiElement)finallyBlock)) >= 0) {
                        catchOrFinallyOffsets.add(offset - 2);
                    }
                    for (PsiCatchSection catchSection : psiTryStatement.getCatchSections()) {
                        PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                        PsiParameter parameter2 = catchSection.getParameter();
                        if (catchBlock == null || parameter2 == null) continue;
                        for (PsiClassType psiClassType : thrownExceptions) {
                            int offset2;
                            if (!ControlFlowUtil.isCaughtExceptionType(psiClassType, parameter2.getType()) || (offset2 = flow.getStartOffset((PsiElement)catchBlock)) < 0) continue;
                            catchOrFinallyOffsets.add(offset2 - 1);
                        }
                    }
                }
                return catchOrFinallyOffsets;
            }

            private boolean isAnyReadOffsetReachableFrom(@Nullable IntArrayList readOffsets, @NotNull IntArrayList fromOffsets) {
                if (readOffsets != null && !readOffsets.isEmpty()) {
                    int[] readOffsetsArray = readOffsets.toArray();
                    for (int j = 0; j < fromOffsets.size(); ++j) {
                        int fromOffset = fromOffsets.get(j);
                        if (!ControlFlowUtil.areInstructionsReachable(flow, readOffsetsArray, fromOffset)) continue;
                        LOG.debug("reachableFromOffset:", new Object[]{fromOffset});
                        return true;
                    }
                }
                return false;
            }

            @NotNull
            private Function<Integer, BitSet> getReachableInstructionsCalculator() {
                ControlFlowGraph graph = new ControlFlowGraph(flow.getSize()){

                    @Override
                    void addArc(int offset, int nextOffset) {
                        if ((nextOffset = ControlFlowUtil.promoteThroughGotoChain(flow, nextOffset)) >= flowStart && nextOffset < flowEnd) {
                            super.addArc(offset, nextOffset);
                        }
                    }
                };
                graph.buildFrom(flow);
                return startOffset -> {
                    BitSet visitedOffsets = new BitSet(flowEnd);
                    graph.depthFirstSearch((int)startOffset, visitedOffsets);
                    return visitedOffsets;
                };
            }
        }
        Worker worker = new Worker();
        Map writeOffsets = worker.getWritesOffsets();
        if (writeOffsets.isEmpty()) {
            return false;
        }
        PsiElement commonParent = elements.length != 1 ? PsiTreeUtil.findCommonParent((PsiElement[])elements) : elements[0].getParent();
        List<PsiTryStatement> tryStatements = ControlFlowUtil.collectTryStatementStack(commonParent, enclosingCodeFragment);
        if (tryStatements.isEmpty()) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatements.get(0).getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        Map visibleReadOffsets = worker.getVisibleReadsOffsets(writeOffsets, tryBlock);
        if (visibleReadOffsets.isEmpty()) {
            return false;
        }
        Map afterWrite = worker.getReachableAfterWrite(writeOffsets, visibleReadOffsets);
        if (afterWrite.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : afterWrite.entrySet()) {
            PsiVariable variable = (PsiVariable)entry.getKey();
            PsiElement[] psiElements = ((Set)entry.getValue()).toArray(PsiElement.EMPTY_ARRAY);
            List<PsiClassType> thrownExceptions = ExceptionUtil.getThrownExceptions(psiElements);
            if (thrownExceptions.isEmpty()) continue;
            IntArrayList catchOrFinallyOffsets = worker.getCatchOrFinallyOffsets(tryStatements, thrownExceptions);
            if (!worker.isAnyReadOffsetReachableFrom((IntArrayList)visibleReadOffsets.get(variable), catchOrFinallyOffsets)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiTryStatement getEnclosingTryStatementHavingCatchOrFinally(@Nullable PsiElement startElement, @NotNull PsiElement enclosingCodeFragment) {
        for (PsiElement element = startElement; element != null && element != enclosingCodeFragment; element = element.getParent()) {
            PsiTryStatement tryStatement;
            PsiElement parent;
            if (!(element instanceof PsiCodeBlock) || !((parent = element.getParent()) instanceof PsiTryStatement) || (tryStatement = (PsiTryStatement)parent).getTryBlock() != element || tryStatement.getFinallyBlock() == null && tryStatement.getCatchBlocks().length == 0) continue;
            return tryStatement;
        }
        return null;
    }

    @NotNull
    private static List<PsiTryStatement> collectTryStatementStack(@Nullable PsiElement startElement, @NotNull PsiElement enclosingCodeFragment) {
        ArrayList<PsiTryStatement> stack = new ArrayList<PsiTryStatement>();
        PsiTryStatement tryStatement = ControlFlowUtil.getEnclosingTryStatementHavingCatchOrFinally(startElement, enclosingCodeFragment);
        while (tryStatement != null) {
            stack.add(tryStatement);
            tryStatement = ControlFlowUtil.getEnclosingTryStatementHavingCatchOrFinally((PsiElement)tryStatement, enclosingCodeFragment);
        }
        return stack;
    }

    @NotNull
    public static PsiElement findCodeFragment(@NotNull PsiElement element) {
        PsiElement codeFragment = element;
        for (PsiElement parent = codeFragment.getParent(); !(parent == null || parent instanceof PsiDirectory || parent instanceof PsiMethod || parent instanceof PsiField || parent instanceof PsiClassInitializer || parent instanceof DummyHolder || parent instanceof PsiLambdaExpression); parent = parent.getParent()) {
            codeFragment = parent;
        }
        return codeFragment;
    }

    private static boolean checkReferenceExpressionScope(@NotNull PsiReferenceExpression ref, @NotNull PsiElement targetClassMember) {
        JavaResolveResult resolveResult = ref.advancedResolve(false);
        PsiElement def = resolveResult.getElement();
        if (def != null) {
            PsiElement commonParent;
            PsiElement parent = def.getParent();
            PsiElement psiElement = commonParent = parent == null ? null : PsiTreeUtil.findCommonParent((PsiElement)parent, (PsiElement)targetClassMember);
            if (commonParent == null) {
                parent = resolveResult.getCurrentFileResolveScope();
            }
            if (parent instanceof PsiClass) {
                PsiClass clss = (PsiClass)parent;
                if (PsiTreeUtil.isAncestor((PsiElement)targetClassMember, (PsiElement)clss, (boolean)false)) {
                    return false;
                }
                for (PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class); containingClass != null; containingClass = containingClass.getContainingClass()) {
                    if (!containingClass.isInheritor(clss, true) || !PsiTreeUtil.isAncestor((PsiElement)targetClassMember, (PsiElement)containingClass, (boolean)false)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean collectOuterLocals(@NotNull List<? super PsiVariable> array, @NotNull PsiElement scope, @NotNull PsiElement member, @NotNull PsiElement targetClassMember) {
        PsiJavaCodeReferenceElement qualifier;
        PsiMethodCallExpression call;
        if (scope instanceof PsiMethodCallExpression ? !ControlFlowUtil.checkReferenceExpressionScope((call = (PsiMethodCallExpression)scope).getMethodExpression(), targetClassMember) : scope instanceof PsiReferenceExpression && !ControlFlowUtil.checkReferenceExpressionScope((PsiReferenceExpression)scope, targetClassMember)) {
            return false;
        }
        if (scope instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)scope;
            JavaResolveResult result = ref.advancedResolve(false);
            PsiElement refElement = result.getElement();
            if (refElement != null) {
                PsiElement parent = refElement.getParent();
                PsiElement psiElement = parent = parent != null ? PsiTreeUtil.findCommonParent((PsiElement)parent, (PsiElement)member) : null;
                if (parent == null) {
                    parent = result.getCurrentFileResolveScope();
                }
                if (parent != null && !member.equals(parent) && targetClassMember.equals(parent = PsiTreeUtil.findCommonParent((PsiElement)parent, (PsiElement)targetClassMember))) {
                    if (!(refElement instanceof PsiVariable)) return false;
                    if (scope instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiReferenceExpression)scope))) {
                        return false;
                    }
                    PsiVariable variable = (PsiVariable)refElement;
                    if (!array.contains(variable)) {
                        array.add((PsiVariable)variable);
                    }
                }
            }
        } else if (scope instanceof PsiThisExpression ? (qualifier = ((PsiThisExpression)scope).getQualifier()) == null : scope instanceof PsiSuperExpression && ((PsiSuperExpression)scope).getQualifier() == null) {
            return false;
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (ControlFlowUtil.collectOuterLocals(array, child, member, targetClassMember)) continue;
            return false;
        }
        return true;
    }

    public static boolean returnPresent(@NotNull ControlFlow flow) {
        ReturnPresentClientVisitor visitor = new ReturnPresentClientVisitor(flow);
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        return (Boolean)((InstructionClientVisitor)visitor).getResult();
    }

    public static boolean processReturns(@NotNull ControlFlow flow, @NotNull ReturnStatementsVisitor afterVisitor) throws IncorrectOperationException {
        ConvertReturnClientVisitor instructionsVisitor = new ConvertReturnClientVisitor(flow, afterVisitor);
        ControlFlowUtil.depthFirstSearch(flow, instructionsVisitor);
        instructionsVisitor.afterProcessing();
        return instructionsVisitor.getResult();
    }

    public static boolean returnPresentBetween(final @NotNull ControlFlow flow, final int startOffset, final int endOffset) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private final boolean[] isNormalCompletion;

            MyVisitor() {
                int i;
                this.isNormalCompletion = new boolean[flow.getSize() + 1];
                int length = flow.getSize();
                for (i = 0; i < startOffset; ++i) {
                    this.isNormalCompletion[i] = true;
                }
                for (i = endOffset; i <= length; ++i) {
                    this.isNormalCompletion[i] = true;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                boolean isNormal;
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                int throwToOffset = instruction.offset;
                if (throwToOffset == nextOffset) {
                    if (throwToOffset > endOffset) return;
                    isNormal = !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset];
                } else {
                    isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
                }
                int n = offset;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset <= endOffset) {
                    boolean isNormal = !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset];
                    int n = offset;
                    this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
                }
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset > endOffset && nextOffset != offset + 1) {
                    return;
                }
                boolean isNormal = this.isNormalCompletion[nextOffset];
                int n = offset;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                boolean isRethrowFromFinally = instruction instanceof ReturnInstruction && ((ReturnInstruction)instruction).isRethrowFromFinally();
                boolean isNormal = !instruction.isReturn && this.isNormalCompletion[nextOffset] && !isRethrowFromFinally;
                int n = offset;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                boolean isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
                int n = offset;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            @NotNull
            public Boolean getResult() {
                return !this.isNormalCompletion[startOffset];
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor, startOffset, endOffset);
        return visitor.getResult();
    }

    public static boolean canCompleteNormally(final @NotNull ControlFlow flow, final int startOffset, final int endOffset) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private final boolean[] canCompleteNormally;

            MyVisitor() {
                this.canCompleteNormally = new boolean[flow.getSize() + 1];
            }

            @Override
            public void visitConditionalGoToInstruction(ConditionalGoToInstruction instruction, int offset, int nextOffset) {
                this.checkInstruction(offset, nextOffset, false);
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
                this.checkInstruction(offset, nextOffset, instruction.isReturn);
            }

            private void checkInstruction(int offset, int nextOffset, boolean isReturn) {
                boolean isNormal;
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean bl = isNormal = nextOffset <= endOffset && !isReturn && (nextOffset == endOffset || this.canCompleteNormally[nextOffset]);
                if (isNormal && nextOffset == endOffset) {
                    PsiStatement continuedStatement;
                    PsiElement element = flow.getElement(offset);
                    if (element instanceof PsiBreakStatement) {
                        PsiStatement exitedStatement = ((PsiBreakStatement)element).findExitedStatement();
                        if (exitedStatement == null || flow.getStartOffset((PsiElement)exitedStatement) < startOffset) {
                            isNormal = false;
                        }
                    } else if (element instanceof PsiContinueStatement && ((continuedStatement = ((PsiContinueStatement)element).findContinuedStatement()) == null || flow.getStartOffset((PsiElement)continuedStatement) < startOffset)) {
                        isNormal = false;
                    }
                }
                int n = offset;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                int throwToOffset = instruction.offset;
                boolean isNormal = throwToOffset == nextOffset ? throwToOffset <= endOffset && !this.isLeaf(nextOffset) && this.canCompleteNormally[nextOffset] : this.canCompleteNormally[nextOffset];
                int n = offset;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset <= endOffset) {
                    boolean isNormal = !this.isLeaf(nextOffset) && this.canCompleteNormally[nextOffset];
                    int n = offset;
                    this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
                }
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset > endOffset && nextOffset != offset + 1) {
                    return;
                }
                boolean isNormal = this.canCompleteNormally[nextOffset];
                int n = offset;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                this.checkInstruction(offset, nextOffset, false);
            }

            @Override
            @NotNull
            public Boolean getResult() {
                return this.canCompleteNormally[startOffset];
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor, startOffset, endOffset);
        return visitor.getResult();
    }

    public static PsiElement getUnreachableStatement(@NotNull ControlFlow flow) {
        UnreachableStatementClientVisitor visitor = new UnreachableStatementClientVisitor(flow);
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        return (PsiElement)((InstructionClientVisitor)visitor).getResult();
    }

    private static PsiReferenceExpression getEnclosingReferenceExpression(@NotNull PsiElement element, @NotNull PsiVariable variable) {
        PsiReferenceExpression reference = ControlFlowUtil.findReferenceTo(element, variable);
        if (reference != null) {
            return reference;
        }
        while (element != null) {
            if (element instanceof PsiReferenceExpression) {
                return (PsiReferenceExpression)element;
            }
            if (element instanceof PsiMethod || element instanceof PsiClass) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    private static PsiReferenceExpression findReferenceTo(@NotNull PsiElement element, @NotNull PsiVariable variable) {
        PsiElement[] children;
        if (element instanceof PsiReferenceExpression && ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)element) && ((PsiReferenceExpression)element).resolve() == variable) {
            return (PsiReferenceExpression)element;
        }
        for (PsiElement child : children = element.getChildren()) {
            PsiReferenceExpression reference = ControlFlowUtil.findReferenceTo(child, variable);
            if (reference == null) continue;
            return reference;
        }
        return null;
    }

    public static boolean isDominator(ControlFlow flow, final int maybeDominator, final int target) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            final BitSet myReachedWithoutDominator = new BitSet();

            MyVisitor() {
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                super.visitInstruction(instruction, offset, nextOffset);
                if (nextOffset != maybeDominator && (target == nextOffset || this.myReachedWithoutDominator.get(nextOffset))) {
                    this.myReachedWithoutDominator.set(offset);
                }
            }

            @Override
            public Boolean getResult() {
                return this.myReachedWithoutDominator.get(0);
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor, 0, target);
        return visitor.getResult() == false;
    }

    public static boolean isVariableDefinitelyAssigned(@NotNull PsiVariable variable, @NotNull ControlFlow flow) {
        int variableDeclarationOffset = flow.getStartOffset(variable.getParent());
        int offset = variableDeclarationOffset > -1 ? variableDeclarationOffset : 0;
        boolean[] unassignedOffsets = ControlFlowUtil.getVariablePossiblyUnassignedOffsets(variable, flow);
        return !unassignedOffsets[offset];
    }

    public static boolean[] getVariablePossiblyUnassignedOffsets(final @NotNull PsiVariable variable, final @NotNull ControlFlow flow) {
        if (flow.getSize() == 0) {
            return new boolean[]{true};
        }
        class MyVisitor
        extends InstructionClientVisitor<boolean[]> {
            private final boolean[] maybeUnassigned;

            MyVisitor() {
                this.maybeUnassigned = new boolean[flow.getSize() + 1];
                this.maybeUnassigned[this.maybeUnassigned.length - 1] = true;
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset, int nextOffset) {
                if (instruction.variable == variable) {
                    this.maybeUnassigned[offset] = false;
                } else {
                    this.visitInstruction(instruction, offset, nextOffset);
                }
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = offset == flow.getSize() - 1 || !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                int n = offset;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
                this.visitInstruction(instruction, offset, nextOffset);
                for (int i = instruction.procBegin; i < instruction.procEnd + 3; ++i) {
                    this.maybeUnassigned[i] = false;
                }
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
                if (instruction.isReturn && variable instanceof PsiLocalVariable) {
                    if (nextOffset > flow.getSize()) {
                        nextOffset = flow.getSize();
                    }
                    boolean unassigned = !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                    int n = offset;
                    this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
                } else {
                    super.visitGoToInstruction(instruction, offset, nextOffset);
                }
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                int n = offset;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = this.isLeaf(nextOffset) || this.maybeUnassigned[nextOffset];
                int n = offset;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            @NotNull
            public boolean[] getResult() {
                return this.maybeUnassigned;
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        return visitor.getResult();
    }

    public static boolean isVariableDefinitelyNotAssigned(final @NotNull PsiVariable variable, final @NotNull ControlFlow flow) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private final boolean[] maybeAssigned;

            MyVisitor() {
                this.maybeAssigned = new boolean[flow.getSize() + 1];
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = instruction.variable == variable || this.maybeAssigned[nextOffset];
                int n = offset;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = !this.isLeaf(nextOffset) && this.maybeAssigned[nextOffset];
                int n = offset;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                int throwToOffset;
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = (throwToOffset = instruction.offset) == nextOffset ? !this.isLeaf(nextOffset) && this.maybeAssigned[nextOffset] : this.maybeAssigned[nextOffset];
                int n = offset;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = this.maybeAssigned[nextOffset];
                int n = offset;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            @NotNull
            public Boolean getResult() {
                return !this.maybeAssigned[0];
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        return visitor.getResult();
    }

    public static boolean isValueUsedWithoutVisitingStop(final @NotNull ControlFlow flow, final int start, final int stop, final @NotNull PsiVariable variable) {
        if (start == stop) {
            return false;
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private final boolean[] maybeReferenced;

            MyVisitor() {
                this.maybeReferenced = new boolean[flow.getSize() + 1];
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                boolean nextState;
                if (offset == stop) {
                    this.maybeReferenced[offset] = false;
                    return;
                }
                if (instruction instanceof WriteVariableInstruction && ((WriteVariableInstruction)instruction).variable == variable) {
                    this.maybeReferenced[offset] = false;
                    return;
                }
                if (this.maybeReferenced[offset]) {
                    return;
                }
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                this.maybeReferenced[offset] = (nextState = this.maybeReferenced[nextOffset]) || instruction instanceof ReadVariableInstruction && ((ReadVariableInstruction)instruction).variable == variable;
            }

            @Override
            @NotNull
            public Boolean getResult() {
                return this.maybeReferenced[start];
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor, start, flow.getSize());
        return visitor.getResult();
    }

    public static boolean isVariableAccess(@NotNull ControlFlow flow, int offset, @NotNull PsiVariable variable) {
        Instruction instruction = flow.getInstructions().get(offset);
        return instruction instanceof ReadVariableInstruction && ((ReadVariableInstruction)instruction).variable == variable || instruction instanceof WriteVariableInstruction && ((WriteVariableInstruction)instruction).variable == variable;
    }

    @NotNull
    public static List<ControlFlowEdge> getEdges(@NotNull ControlFlow flow, int start) {
        final ArrayList<ControlFlowEdge> list = new ArrayList<ControlFlowEdge>();
        ControlFlowUtil.depthFirstSearch(flow, new InstructionClientVisitor<Void>(){

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                list.add(new ControlFlowEdge(offset, nextOffset));
            }

            @Override
            public Void getResult() {
                return null;
            }
        }, start, flow.getSize());
        return list;
    }

    public static int getMinDefinitelyReachedOffset(final @NotNull ControlFlow flow, final int sourceOffset, final @NotNull List<? extends PsiElement> references) {
        class MyVisitor
        extends InstructionClientVisitor<Integer> {
            private final TIntHashSet[] exitPoints;

            MyVisitor() {
                this.exitPoints = new TIntHashSet[flow.getSize()];
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (this.exitPoints[offset] == null) {
                    this.exitPoints[offset] = new TIntHashSet();
                }
                if (this.isLeaf(nextOffset)) {
                    this.exitPoints[offset].add(offset);
                } else if (this.exitPoints[nextOffset] != null) {
                    this.exitPoints[offset].addAll(this.exitPoints[nextOffset].toArray());
                }
            }

            @Override
            @NotNull
            public Integer getResult() {
                int minOffset = flow.getSize();
                int maxExitPoints = 0;
                block0: for (int i = sourceOffset; i < this.exitPoints.length; ++i) {
                    int size;
                    TIntHashSet exitPointSet = this.exitPoints[i];
                    int n = size = exitPointSet == null ? 0 : exitPointSet.size();
                    if (size <= maxExitPoints) continue;
                    for (PsiElement element : references) {
                        int endOffset;
                        PsiElement statement = PsiUtil.getEnclosingStatement((PsiElement)element);
                        if (statement == null || (endOffset = flow.getEndOffset(statement)) == -1 || i == endOffset || ControlFlowUtil.isInstructionReachable(flow, i, endOffset)) continue;
                        continue block0;
                    }
                    minOffset = i;
                    maxExitPoints = size;
                }
                return minOffset;
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        return visitor.getResult();
    }

    private static int findUnprocessed(int startOffset, int endOffset, @NotNull InstructionClientVisitor<?> visitor) {
        for (int i = startOffset; i < endOffset; ++i) {
            if (visitor.processedInstructions[i]) continue;
            return i;
        }
        return endOffset;
    }

    private static void depthFirstSearch(@NotNull ControlFlow flow, @NotNull InstructionClientVisitor visitor) {
        ControlFlowUtil.depthFirstSearch(flow, visitor, 0, flow.getSize());
    }

    private static void depthFirstSearch(@NotNull ControlFlow flow, @NotNull InstructionClientVisitor visitor, int startOffset, int endOffset) {
        visitor.processedInstructions = new boolean[endOffset];
        ControlFlowUtil.internalDepthFirstSearch(flow.getInstructions(), visitor, startOffset, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalDepthFirstSearch(final @NotNull List<? extends Instruction> instructions, final @NotNull InstructionClientVisitor clientVisitor, int startOffset, int endOffset) {
        final WalkThroughStack walkThroughStack = new WalkThroughStack(instructions.size() / 2);
        walkThroughStack.push(startOffset);
        List<? extends Instruction> list = instructions;
        synchronized (list) {
            final IntArrayList currentProcedureReturnOffsets = new IntArrayList();
            ControlFlowInstructionVisitor getNextOffsetVisitor = new ControlFlowInstructionVisitor(){

                @Override
                public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
                    int i;
                    instruction.execute(offset + 1);
                    int newOffset = instruction.offset;
                    for (i = instruction.procBegin; i < clientVisitor.processedInstructions.length && (i < instruction.procEnd || i < instructions.size() && instructions.get(i) instanceof ReturnInstruction); ++i) {
                        clientVisitor.processedInstructions[i] = false;
                    }
                    clientVisitor.procedureEntered(instruction.procBegin, i);
                    walkThroughStack.push(offset, newOffset);
                    walkThroughStack.push(newOffset);
                    currentProcedureReturnOffsets.add(offset + 1);
                }

                @Override
                public void visitReturnInstruction(ReturnInstruction instruction, int offset, int nextOffset) {
                    int newOffset = instruction.execute(false);
                    if (newOffset != -1) {
                        walkThroughStack.push(offset, newOffset);
                        walkThroughStack.push(newOffset);
                    }
                }

                @Override
                public void visitBranchingInstruction(BranchingInstruction instruction, int offset, int nextOffset) {
                    int newOffset = instruction.offset;
                    walkThroughStack.push(offset, newOffset);
                    walkThroughStack.push(newOffset);
                }

                @Override
                public void visitConditionalBranchingInstruction(ConditionalBranchingInstruction instruction, int offset, int nextOffset) {
                    int newOffset = instruction.offset;
                    walkThroughStack.push(offset, newOffset);
                    walkThroughStack.push(offset, offset + 1);
                    walkThroughStack.push(newOffset);
                    walkThroughStack.push(offset + 1);
                }

                @Override
                public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                    int newOffset = offset + 1;
                    walkThroughStack.push(offset, newOffset);
                    walkThroughStack.push(newOffset);
                }
            };
            while (!walkThroughStack.isEmpty()) {
                int offset = walkThroughStack.peekOldOffset();
                int newOffset = walkThroughStack.popNewOffset();
                if (offset >= endOffset) continue;
                Instruction instruction = instructions.get(offset);
                if (clientVisitor.processedInstructions[offset]) {
                    if (newOffset != -1) {
                        instruction.accept(clientVisitor, offset, newOffset);
                    }
                    if (currentProcedureReturnOffsets.isEmpty() || currentProcedureReturnOffsets.get(currentProcedureReturnOffsets.size() - 1) - 1 != offset) continue;
                    currentProcedureReturnOffsets.remove(currentProcedureReturnOffsets.size() - 1);
                    continue;
                }
                if (!currentProcedureReturnOffsets.isEmpty()) {
                    int returnOffset = currentProcedureReturnOffsets.get(currentProcedureReturnOffsets.size() - 1);
                    CallInstruction callInstruction = (CallInstruction)instructions.get(returnOffset - 1);
                    ControlFlowStack controlFlowStack = callInstruction.stack;
                    synchronized (controlFlowStack) {
                        if (callInstruction.procBegin <= offset && offset < callInstruction.procEnd + 2 && (callInstruction.stack.size() == 0 || callInstruction.stack.peekReturnOffset() != returnOffset)) {
                            callInstruction.stack.push(returnOffset, callInstruction);
                        }
                    }
                }
                clientVisitor.processedInstructions[offset] = true;
                instruction.accept(getNextOffsetVisitor, offset, newOffset);
            }
        }
    }

    private static boolean isInsideReturnStatement(PsiElement element) {
        while (element instanceof PsiExpression) {
            element = element.getParent();
        }
        return element instanceof PsiReturnStatement;
    }

    private static void merge(int offset, CopyOnWriteList source, @NotNull CopyOnWriteList[] target) {
        if (source != null) {
            CopyOnWriteList existing = target[offset];
            target[offset] = existing == null ? source : existing.addAll(source);
        }
    }

    @NotNull
    public static List<PsiReferenceExpression> getReadBeforeWriteLocals(@NotNull ControlFlow flow) {
        ReadBeforeWriteClientVisitor visitor = new ReadBeforeWriteClientVisitor(flow, true);
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        return (List)((InstructionClientVisitor)visitor).getResult();
    }

    @NotNull
    public static List<PsiReferenceExpression> getReadBeforeWrite(@NotNull ControlFlow flow) {
        return ControlFlowUtil.getReadBeforeWrite(flow, 0);
    }

    @NotNull
    private static List<PsiReferenceExpression> getReadBeforeWrite(@NotNull ControlFlow flow, int startOffset) {
        if (startOffset < 0 || startOffset >= flow.getSize()) {
            return Collections.emptyList();
        }
        ReadBeforeWriteClientVisitor visitor = new ReadBeforeWriteClientVisitor(flow, false);
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        return visitor.getResult(startOffset);
    }

    public static int getCompletionReasons(final @NotNull ControlFlow flow, final int offset, final int endOffset) {
        class MyVisitor
        extends InstructionClientVisitor<Integer> {
            private final boolean[] normalCompletion;
            private final boolean[] returnCalled;

            MyVisitor() {
                this.normalCompletion = new boolean[endOffset];
                this.returnCalled = new boolean[endOffset];
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                boolean goToReturn;
                boolean ret = nextOffset < endOffset && this.returnCalled[nextOffset];
                boolean normal = nextOffset < endOffset && this.normalCompletion[nextOffset];
                PsiElement element = flow.getElement(offset2);
                boolean bl = goToReturn = instruction instanceof GoToInstruction && ((GoToInstruction)instruction).isReturn;
                if (goToReturn || ControlFlowUtil.isInsideReturnStatement(element)) {
                    ret = true;
                } else if (instruction instanceof ConditionalThrowToInstruction) {
                    int throwOffset = ((ConditionalThrowToInstruction)instruction).offset;
                    boolean normalWhenThrow = throwOffset < endOffset && this.normalCompletion[throwOffset];
                    boolean normalWhenNotThrow = offset2 == endOffset - 1 || this.normalCompletion[offset2 + 1];
                    normal = normalWhenThrow || normalWhenNotThrow;
                } else if (!(instruction instanceof ThrowToInstruction) && nextOffset >= endOffset) {
                    normal = true;
                }
                int n = offset2;
                this.returnCalled[n] = this.returnCalled[n] | ret;
                int n2 = offset2;
                this.normalCompletion[n2] = this.normalCompletion[n2] | normal;
            }

            @Override
            @NotNull
            public Integer getResult() {
                return (this.returnCalled[offset] ? 2 : 0) | (this.normalCompletion[offset] ? 1 : 0);
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor, offset, endOffset);
        return visitor.getResult();
    }

    @NotNull
    public static Collection<VariableInfo> getInitializedTwice(@NotNull ControlFlow flow) {
        return ControlFlowUtil.getInitializedTwice(flow, 0, flow.getSize());
    }

    @NotNull
    public static Collection<VariableInfo> getInitializedTwice(@NotNull ControlFlow flow, int startOffset, int endOffset) {
        while (startOffset < endOffset) {
            InitializedTwiceClientVisitor visitor = new InitializedTwiceClientVisitor(flow, startOffset);
            ControlFlowUtil.depthFirstSearch(flow, visitor, startOffset, endOffset);
            Object result = visitor.getResult();
            if (!result.isEmpty()) {
                return result;
            }
            startOffset = ControlFlowUtil.findUnprocessed(startOffset, endOffset, visitor);
        }
        return Collections.emptyList();
    }

    @NotNull
    public static Map<PsiElement, PsiVariable> getWritesBeforeReads(@NotNull ControlFlow flow, @NotNull Set<PsiVariable> writeVars, @NotNull Set<PsiVariable> readVars, int stopPoint) {
        HashMap<PsiElement, PsiVariable> writes = new HashMap<PsiElement, PsiVariable>();
        List<Instruction> instructions = flow.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            PsiVariable writtenVar;
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof WriteVariableInstruction) || !writeVars.contains(writtenVar = ((WriteVariableInstruction)instruction).variable) || !ControlFlowUtil.readBeforeStopPoint(flow, readVars, i, stopPoint)) continue;
            writes.put(flow.getElement(i), writtenVar);
        }
        return writes;
    }

    private static boolean readBeforeStopPoint(@NotNull ControlFlow flow, final @NotNull Set<PsiVariable> readVars, int startOffset, final int stopPoint) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private boolean reachable = false;

            MyVisitor() {
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (offset == stopPoint || this.isWriteToReadVar(instruction)) {
                    this.reachable = false;
                    return;
                }
                boolean foundRead = instruction instanceof ReadVariableInstruction && readVars.contains(((ReadVariableInstruction)instruction).variable);
                this.reachable |= foundRead;
            }

            private boolean isWriteToReadVar(Instruction instruction) {
                return instruction instanceof WriteVariableInstruction && readVars.contains(((WriteVariableInstruction)instruction).variable);
            }

            @Override
            public Boolean getResult() {
                return this.reachable;
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor, startOffset, flow.getSize());
        return visitor.getResult();
    }

    public static boolean isInstructionReachable(@NotNull ControlFlow flow, int instructionOffset, int startOffset) {
        return ControlFlowUtil.areInstructionsReachable(flow, new int[]{instructionOffset}, startOffset);
    }

    private static boolean areInstructionsReachable(@NotNull ControlFlow flow, @NotNull int[] instructionOffsets, int startOffset) {
        if (startOffset != 0 && ControlFlowUtil.hasCalls(flow)) {
            return ControlFlowUtil.areInstructionsReachableWithCalls(flow, instructionOffsets, startOffset);
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private boolean reachable;
            final /* synthetic */ int[] val$instructionOffsets;

            MyVisitor(int[] nArray) {
                this.val$instructionOffsets = nArray;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                this.reachable |= ArrayUtil.indexOf((int[])this.val$instructionOffsets, (int)nextOffset) >= 0;
            }

            @Override
            @NotNull
            public Boolean getResult() {
                return this.reachable;
            }
        }
        MyVisitor visitor = new MyVisitor(instructionOffsets);
        ControlFlowUtil.depthFirstSearch(flow, visitor, startOffset, flow.getSize());
        return visitor.getResult();
    }

    private static boolean hasCalls(@NotNull ControlFlow flow) {
        for (Instruction instruction : flow.getInstructions()) {
            if (!(instruction instanceof CallInstruction)) continue;
            return true;
        }
        return false;
    }

    private static boolean areInstructionsReachableWithCalls(@NotNull ControlFlow flow, final @NotNull int[] instructionOffsets, int startOffset) {
        ControlFlowGraph graph = new ControlFlowGraph(flow.getSize()){

            @Override
            boolean isComplete(int offset, int nextOffset) {
                return ArrayUtil.indexOf((int[])instructionOffsets, (int)nextOffset) >= 0;
            }
        };
        graph.buildFrom(flow);
        return graph.depthFirstSearch(startOffset);
    }

    public static boolean isVariableAssignedInLoop(@NotNull PsiReferenceExpression expression2, @NotNull PsiElement resolved) {
        ControlFlow flow;
        if (!(expression2.getParent() instanceof PsiAssignmentExpression) || ((PsiAssignmentExpression)expression2.getParent()).getLExpression() != expression2) {
            return false;
        }
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
            return false;
        }
        if (!(resolved instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)resolved;
        PsiElement codeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, (PsiElement)expression2);
        if (codeBlock == null) {
            return false;
        }
        try {
            flow = ControlFlowFactory.getInstance(codeBlock.getProject()).getControlFlow(codeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), true);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2.getParent();
        int startOffset = flow.getStartOffset((PsiElement)assignmentExpression);
        return startOffset != -1 && ControlFlowUtil.isInstructionReachable(flow, startOffset, startOffset);
    }

    static boolean isCaughtExceptionType(@NotNull PsiClassType throwType, @NotNull PsiType catchType) {
        return catchType.isAssignableFrom((PsiType)throwType) || ControlFlowUtil.mightBeAssignableFromSubclass(throwType, catchType);
    }

    private static boolean mightBeAssignableFromSubclass(@NotNull PsiClassType throwType, @NotNull PsiType catchType) {
        if (catchType instanceof PsiDisjunctionType) {
            for (PsiType catchDisjunction : ((PsiDisjunctionType)catchType).getDisjunctions()) {
                if (!throwType.isAssignableFrom(catchDisjunction)) continue;
                return true;
            }
            return false;
        }
        return throwType.isAssignableFrom(catchType);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean areVariablesUnmodifiedAtLocations(@NotNull ControlFlow flow, int startOffset, int endOffset, @NotNull Set<? extends PsiVariable> variables, @NotNull Iterable<? extends PsiElement> locations) {
        void var8_10;
        List<Instruction> instructions = flow.getInstructions();
        startOffset = Math.max(startOffset, 0);
        endOffset = Math.min(endOffset, instructions.size());
        IntArrayList locationOffsetList = new IntArrayList();
        for (PsiElement psiElement : locations) {
            int offset = flow.getStartOffset(psiElement);
            if (offset < startOffset || offset >= endOffset) continue;
            locationOffsetList.add(offset);
        }
        int[] locationOffsets = locationOffsetList.toArray();
        int n = startOffset;
        while (var8_10 < endOffset) {
            Instruction instruction = instructions.get((int)var8_10);
            if (instruction instanceof WriteVariableInstruction && variables.contains(((WriteVariableInstruction)instruction).variable) && ControlFlowUtil.areInstructionsReachable(flow, locationOffsets, (int)var8_10)) {
                return false;
            }
            ++var8_10;
        }
        return true;
    }

    private static abstract class ControlFlowGraph
    extends InstructionClientVisitor<Void> {
        final int[][] nextOffsets;

        ControlFlowGraph(int size) {
            this.nextOffsets = new int[size][];
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.size()) {
                nextOffset = this.size();
            }
            this.addArc(offset, nextOffset);
        }

        void addArc(int offset, int nextOffset) {
            if (this.nextOffsets[offset] == null) {
                this.nextOffsets[offset] = new int[]{nextOffset, -1};
            } else {
                int[] targets = this.nextOffsets[offset];
                if (ArrayUtil.indexOf((int[])targets, (int)nextOffset) < 0) {
                    int freeIndex = ArrayUtil.indexOf((int[])targets, (int)-1);
                    if (freeIndex >= 0) {
                        targets[freeIndex] = nextOffset;
                    } else {
                        int oldLength = targets.length;
                        targets = ArrayUtil.realloc((int[])targets, (int)(oldLength * 3 / 2));
                        this.nextOffsets[offset] = targets;
                        Arrays.fill(targets, oldLength, targets.length, -1);
                        targets[oldLength] = nextOffset;
                    }
                }
            }
        }

        @NotNull
        int[] getNextOffsets(int offset) {
            return this.nextOffsets[offset] != null ? this.nextOffsets[offset] : ArrayUtil.EMPTY_INT_ARRAY;
        }

        int size() {
            return this.nextOffsets.length;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.nextOffsets.length; ++i) {
                int[] targets = this.nextOffsets[i];
                if (targets == null || targets.length == 0 || targets[0] == -1) continue;
                if (s.length() != 0) {
                    s.append(' ');
                }
                s.append('(').append(i).append("->");
                for (int j = 0; j < targets.length && targets[j] != -1; ++j) {
                    if (j != 0) {
                        s.append(",");
                    }
                    s.append(targets[j]);
                }
                s.append(')');
            }
            return s.toString();
        }

        boolean depthFirstSearch(int startOffset) {
            return this.depthFirstSearch(startOffset, new BitSet(this.size()));
        }

        boolean depthFirstSearch(int startOffset, @NotNull BitSet visitedOffsets) {
            IntStack walkThroughStack = new IntStack(Math.max(this.size() / 2, 2));
            visitedOffsets.clear();
            walkThroughStack.push(startOffset);
            while (!walkThroughStack.empty()) {
                int[] nextOffsets;
                int currentOffset = walkThroughStack.pop();
                if (currentOffset >= this.size() || visitedOffsets.get(currentOffset)) continue;
                visitedOffsets.set(currentOffset);
                for (int nextOffset : nextOffsets = this.getNextOffsets(currentOffset)) {
                    if (nextOffset == -1) break;
                    if (this.isComplete(currentOffset, nextOffset)) {
                        return true;
                    }
                    walkThroughStack.push(nextOffset);
                }
            }
            return false;
        }

        @Override
        public Void getResult() {
            return null;
        }

        boolean isComplete(int offset, int nextOffset) {
            return false;
        }

        void buildFrom(@NotNull ControlFlow flow) {
            ControlFlowUtil.depthFirstSearch(flow, this, 0, flow.getSize());
        }
    }

    private static class InitializedTwiceClientVisitor
    extends InstructionClientVisitor<Collection<VariableInfo>> {
        private final CopyOnWriteList[] writtenVariables;
        private final CopyOnWriteList[] writtenTwiceVariables;
        private final ControlFlow myFlow;
        private final int myStartOffset;

        InitializedTwiceClientVisitor(@NotNull ControlFlow flow, int startOffset) {
            this.myFlow = flow;
            this.myStartOffset = startOffset;
            this.writtenVariables = new CopyOnWriteList[this.myFlow.getSize() + 1];
            this.writtenTwiceVariables = new CopyOnWriteList[this.myFlow.getSize() + 1];
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
            int safeNextOffset = Math.min(nextOffset, this.myFlow.getSize());
            CopyOnWriteList writeVars = this.writtenVariables[safeNextOffset];
            CopyOnWriteList writeTwiceVars = this.writtenTwiceVariables[safeNextOffset];
            if (instruction instanceof WriteVariableInstruction) {
                PsiVariable variable = ((WriteVariableInstruction)instruction).variable;
                PsiElement latestWriteVarExpression = InitializedTwiceClientVisitor.getLatestWriteVarExpression(writeVars, variable);
                if (latestWriteVarExpression == null) {
                    PsiElement expression2 = InitializedTwiceClientVisitor.getExpression(this.myFlow.getElement(offset));
                    writeVars = CopyOnWriteList.add(writeVars, new VariableInfo(variable, expression2));
                } else {
                    writeTwiceVars = CopyOnWriteList.add(writeTwiceVars, new VariableInfo(variable, latestWriteVarExpression));
                }
            }
            ControlFlowUtil.merge(offset, writeVars, this.writtenVariables);
            ControlFlowUtil.merge(offset, writeTwiceVars, this.writtenTwiceVariables);
        }

        @Nullable
        private static PsiElement getExpression(@NotNull PsiElement element) {
            if (element instanceof PsiAssignmentExpression) {
                PsiExpression target = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)element).getLExpression());
                return (PsiElement)ObjectUtils.tryCast((Object)target, PsiReferenceExpression.class);
            }
            if (element instanceof PsiUnaryExpression) {
                PsiExpression target = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiUnaryExpression)element).getOperand());
                return (PsiElement)ObjectUtils.tryCast((Object)target, PsiReferenceExpression.class);
            }
            if (element instanceof PsiDeclarationStatement) {
                return element;
            }
            return null;
        }

        @Nullable
        private static PsiElement getLatestWriteVarExpression(@Nullable CopyOnWriteList writeVars, @NotNull PsiVariable variable) {
            if (writeVars == null) {
                return null;
            }
            for (VariableInfo variableInfo : writeVars.getList()) {
                if (variableInfo.variable != variable) continue;
                return variableInfo.expression;
            }
            return null;
        }

        @Override
        @NotNull
        public Collection<VariableInfo> getResult() {
            CopyOnWriteList writtenTwiceVariable = this.writtenTwiceVariables[this.myStartOffset];
            if (writtenTwiceVariable == null) {
                return Collections.emptyList();
            }
            return writtenTwiceVariable.getList();
        }
    }

    private static class ReadBeforeWriteClientVisitor
    extends InstructionClientVisitor<List<PsiReferenceExpression>> {
        private final CopyOnWriteList[] readVariables;
        private final ControlFlow myFlow;
        private final boolean localVariablesOnly;

        ReadBeforeWriteClientVisitor(@NotNull ControlFlow flow, boolean localVariablesOnly) {
            this.myFlow = flow;
            this.localVariablesOnly = localVariablesOnly;
            this.readVariables = new CopyOnWriteList[this.myFlow.getSize() + 1];
        }

        @Override
        public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset, int nextOffset) {
            PsiReferenceExpression expression2;
            CopyOnWriteList readVars = this.readVariables[Math.min(nextOffset, this.myFlow.getSize())];
            PsiVariable variable = instruction.variable;
            if (!(this.localVariablesOnly && ReadBeforeWriteClientVisitor.isMethodParameter(variable) || (expression2 = ControlFlowUtil.getEnclosingReferenceExpression(this.myFlow.getElement(offset), variable)) == null)) {
                readVars = CopyOnWriteList.add(readVars, new VariableInfo(variable, (PsiElement)expression2));
            }
            ControlFlowUtil.merge(offset, readVars, this.readVariables);
        }

        @Override
        public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset, int nextOffset) {
            CopyOnWriteList readVars = this.readVariables[Math.min(nextOffset, this.myFlow.getSize())];
            if (readVars == null) {
                return;
            }
            PsiVariable variable = instruction.variable;
            if (!this.localVariablesOnly || !ReadBeforeWriteClientVisitor.isMethodParameter(variable)) {
                readVars = readVars.remove(new VariableInfo(variable, null));
            }
            ControlFlowUtil.merge(offset, readVars, this.readVariables);
        }

        private static boolean isMethodParameter(@NotNull PsiVariable variable) {
            if (variable instanceof PsiParameter) {
                PsiParameter parameter2 = (PsiParameter)variable;
                return !(parameter2.getDeclarationScope() instanceof PsiForeachStatement);
            }
            return false;
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
            ControlFlowUtil.merge(offset, this.readVariables[Math.min(nextOffset, this.myFlow.getSize())], this.readVariables);
        }

        @Override
        public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
            this.visitInstruction(instruction, offset, nextOffset);
            for (int i = instruction.procBegin; i <= instruction.procEnd; ++i) {
                this.readVariables[i] = null;
            }
        }

        @Override
        @NotNull
        public List<PsiReferenceExpression> getResult() {
            return this.getResult(0);
        }

        @NotNull
        public List<PsiReferenceExpression> getResult(int startOffset) {
            CopyOnWriteList topReadVariables = this.readVariables[startOffset];
            if (topReadVariables == null) {
                return Collections.emptyList();
            }
            ArrayList<PsiReferenceExpression> result = new ArrayList<PsiReferenceExpression>();
            List<VariableInfo> list = topReadVariables.getList();
            for (VariableInfo variableInfo : list) {
                result.add((PsiReferenceExpression)variableInfo.expression);
            }
            return result;
        }
    }

    public static class VariableInfo {
        private final PsiVariable variable;
        public final PsiElement expression;

        public VariableInfo(@NotNull PsiVariable variable, @Nullable PsiElement expression2) {
            this.variable = variable;
            this.expression = expression2;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof VariableInfo && this.variable.equals(((VariableInfo)o).variable);
        }

        public int hashCode() {
            return this.variable.hashCode();
        }
    }

    private static class CopyOnWriteList {
        private final List<VariableInfo> list;

        @NotNull
        public CopyOnWriteList add(@NotNull VariableInfo value2) {
            CopyOnWriteList newList = new CopyOnWriteList();
            List<VariableInfo> list = this.getList();
            for (VariableInfo variableInfo : list) {
                if (value2.equals(variableInfo)) continue;
                newList.list.add(variableInfo);
            }
            newList.list.add(value2);
            return newList;
        }

        @NotNull
        public CopyOnWriteList remove(@NotNull VariableInfo value2) {
            CopyOnWriteList newList = new CopyOnWriteList();
            List<VariableInfo> list = this.getList();
            for (VariableInfo variableInfo : list) {
                if (value2.equals(variableInfo)) continue;
                newList.list.add(variableInfo);
            }
            return newList;
        }

        @NotNull
        public List<VariableInfo> getList() {
            return this.list;
        }

        CopyOnWriteList() {
            this(Collections.emptyList());
        }

        CopyOnWriteList(VariableInfo ... infos) {
            this(Arrays.asList(infos));
        }

        CopyOnWriteList(@NotNull Collection<? extends VariableInfo> infos) {
            this.list = new SmartList(infos);
        }

        @NotNull
        public CopyOnWriteList addAll(@NotNull CopyOnWriteList addList) {
            CopyOnWriteList newList = new CopyOnWriteList();
            List<VariableInfo> list = this.getList();
            newList.list.addAll(list);
            List<VariableInfo> toAdd = addList.getList();
            for (VariableInfo variableInfo : toAdd) {
                if (newList.list.contains(variableInfo)) continue;
                newList.list.add(variableInfo);
            }
            return newList;
        }

        @NotNull
        public static CopyOnWriteList add(@Nullable CopyOnWriteList list, @NotNull VariableInfo value2) {
            return list == null ? new CopyOnWriteList(value2) : list.add(value2);
        }
    }

    private static class WalkThroughStack {
        private int[] oldOffsets;
        private int[] newOffsets;
        private int size;

        WalkThroughStack(int initialSize) {
            if (initialSize < 2) {
                initialSize = 2;
            }
            this.oldOffsets = new int[initialSize];
            this.newOffsets = new int[initialSize];
        }

        void push(int oldOffset, int newOffset) {
            LOG.assertTrue(oldOffset >= 0, (Object)"negative offset is pushed to walk-through stack");
            if (this.size >= this.newOffsets.length) {
                this.oldOffsets = ArrayUtil.realloc((int[])this.oldOffsets, (int)(this.size * 3 / 2));
                this.newOffsets = ArrayUtil.realloc((int[])this.newOffsets, (int)(this.size * 3 / 2));
            }
            this.oldOffsets[this.size] = oldOffset;
            this.newOffsets[this.size] = newOffset;
            ++this.size;
        }

        void push(int offset) {
            this.push(offset, -1);
        }

        int peekOldOffset() {
            return this.oldOffsets[this.size - 1];
        }

        int popNewOffset() {
            return this.newOffsets[--this.size];
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.size; ++i) {
                if (s.length() != 0) {
                    s.append(' ');
                }
                if (this.newOffsets[i] != -1) {
                    s.append('(').append(this.oldOffsets[i]).append("->").append(this.newOffsets[i]).append(')');
                    continue;
                }
                s.append('[').append(this.oldOffsets[i]).append(']');
            }
            return s.toString();
        }
    }

    public static class ControlFlowEdge {
        public final int myFrom;
        public final int myTo;

        ControlFlowEdge(int from, int to) {
            this.myFrom = from;
            this.myTo = to;
        }

        public String toString() {
            return this.myFrom + "->" + this.myTo;
        }
    }

    private static class UnreachableStatementClientVisitor
    extends InstructionClientVisitor<PsiElement> {
        private final ControlFlow myFlow;

        UnreachableStatementClientVisitor(@NotNull ControlFlow flow) {
            this.myFlow = flow;
        }

        @Override
        public PsiElement getResult() {
            for (int i = 0; i < this.processedInstructions.length; ++i) {
                int startOffset;
                int endOffset;
                if (this.processedInstructions[i]) continue;
                PsiElement element = this.myFlow.getElement(i);
                PsiElement unreachableParent = UnreachableStatementClientVisitor.getUnreachableExpressionParent(element);
                if (unreachableParent != null) {
                    return unreachableParent;
                }
                if (element == null || !PsiUtil.isStatement((PsiElement)element) || element.getParent() instanceof PsiExpression) continue;
                while (element instanceof PsiExpression) {
                    element = element.getParent();
                }
                if (element instanceof PsiStatement && element.getParent() instanceof PsiForStatement && element == ((PsiForStatement)element.getParent()).getUpdate() || (endOffset = this.myFlow.getEndOffset(element)) != i + 1 || 0 <= (startOffset = this.myFlow.getStartOffset(element)) && startOffset < this.processedInstructions.length && this.processedInstructions[startOffset]) continue;
                PsiElement enclosingStatement = UnreachableStatementClientVisitor.getEnclosingUnreachableStatement(element);
                return enclosingStatement != null ? enclosingStatement : element;
            }
            return null;
        }

        @Nullable
        private static PsiElement getUnreachableExpressionParent(@Nullable PsiElement element) {
            PsiElement expression2;
            if (element instanceof PsiExpression && (expression2 = PsiTreeUtil.findFirstParent((PsiElement)element, e -> !(e.getParent() instanceof PsiParenthesizedExpression))) != null) {
                PsiElement parent = expression2.getParent();
                if (parent instanceof PsiExpressionStatement) {
                    return UnreachableStatementClientVisitor.getUnreachableStatementParent(parent);
                }
                if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getCondition() == expression2 || parent instanceof PsiSwitchBlock && ((PsiSwitchBlock)parent).getExpression() == expression2 || parent instanceof PsiWhileStatement && ((PsiWhileStatement)parent).getCondition() == expression2 || parent instanceof PsiForeachStatement && ((PsiForeachStatement)parent).getIteratedValue() == expression2) {
                    return parent;
                }
            }
            return null;
        }

        @Nullable
        private static PsiElement getEnclosingUnreachableStatement(@NotNull PsiElement statement) {
            PsiElement blockParent;
            PsiBlockStatement blockStatement;
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiDoWhileStatement && ((PsiDoWhileStatement)parent).getBody() == statement) {
                return parent;
            }
            if (parent instanceof PsiCodeBlock && PsiTreeUtil.getNextSiblingOfType((PsiElement)parent.getFirstChild(), PsiStatement.class) == statement && (blockStatement = (PsiBlockStatement)ObjectUtils.tryCast((Object)parent.getParent(), PsiBlockStatement.class)) != null && (blockParent = blockStatement.getParent()) instanceof PsiDoWhileStatement && ((PsiDoWhileStatement)blockParent).getBody() == blockStatement) {
                return blockParent;
            }
            return UnreachableStatementClientVisitor.getUnreachableStatementParent(statement);
        }

        @Nullable
        private static PsiElement getUnreachableStatementParent(@NotNull PsiElement statement) {
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiForStatement && ((PsiForStatement)parent).getInitialization() == statement) {
                return parent;
            }
            return null;
        }
    }

    private static class ReturnPresentClientVisitor
    extends InstructionClientVisitor<Boolean> {
        private final boolean[] isNormalCompletion;
        protected final ControlFlow myFlow;

        ReturnPresentClientVisitor(@NotNull ControlFlow flow) {
            this.myFlow = flow;
            this.isNormalCompletion = new boolean[this.myFlow.getSize() + 1];
            this.isNormalCompletion[this.myFlow.getSize()] = true;
        }

        @Override
        public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            boolean isNormal = instruction.offset == nextOffset && nextOffset != offset + 1 ? !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset] : this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
            int n = offset;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
        }

        @Override
        public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            int n = offset;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | (!this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset]);
        }

        @Override
        public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            int n = offset;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | (!instruction.isReturn && this.isNormalCompletion[nextOffset]);
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            boolean isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
            int n = offset;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
        }

        @Override
        @NotNull
        public Boolean getResult() {
            return !this.isNormalCompletion[0];
        }
    }

    private static class ConvertReturnClientVisitor
    extends ReturnPresentClientVisitor {
        private final List<PsiReturnStatement> myAffectedReturns = new ArrayList<PsiReturnStatement>();
        private final ReturnStatementsVisitor myVisitor;

        ConvertReturnClientVisitor(@NotNull ControlFlow flow, @NotNull ReturnStatementsVisitor visitor) {
            super(flow);
            this.myVisitor = visitor;
        }

        @Override
        public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
            PsiElement element;
            super.visitGoToInstruction(instruction, offset, nextOffset);
            if (instruction.isReturn && (element = this.myFlow.getElement(offset)) instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                this.myAffectedReturns.add(returnStatement);
            }
        }

        void afterProcessing() throws IncorrectOperationException {
            this.myVisitor.visit(this.myAffectedReturns);
        }
    }

    private static class SSAInstructionState
    implements Cloneable {
        private final int myWriteCount;
        private final int myInstructionIdx;

        SSAInstructionState(int writeCount, int instructionIdx) {
            this.myWriteCount = writeCount;
            this.myInstructionIdx = instructionIdx;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SSAInstructionState)) {
                return false;
            }
            SSAInstructionState ssaInstructionState = (SSAInstructionState)o;
            if (this.myInstructionIdx != ssaInstructionState.myInstructionIdx) {
                return false;
            }
            return Math.min(2, this.myWriteCount) == Math.min(2, ssaInstructionState.myWriteCount);
        }

        public int hashCode() {
            int result = Math.min(2, this.myWriteCount);
            result = 29 * result + this.myInstructionIdx;
            return result;
        }

        int getWriteCount() {
            return this.myWriteCount;
        }

        int getInstructionIdx() {
            return this.myInstructionIdx;
        }
    }
}

