/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import org.jetbrains.annotations.NotNull;

public class GoToInstruction
extends BranchingInstruction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.controlFlow.GoToInstruction");
    public final boolean isReturn;

    GoToInstruction(int offset) {
        this(offset, BranchingInstruction.Role.END);
    }

    GoToInstruction(int offset, @NotNull BranchingInstruction.Role role) {
        this(offset, role, false);
    }

    GoToInstruction(int offset, @NotNull BranchingInstruction.Role role, boolean isReturn) {
        super(offset, role);
        this.isReturn = isReturn;
    }

    @Override
    public String toString() {
        String sRole = "[" + this.role.toString() + "]";
        return "GOTO " + sRole + " " + this.offset + (this.isReturn ? " RETURN" : "");
    }

    @Override
    public int nNext() {
        return 1;
    }

    @Override
    public int getNext(int index, int no) {
        LOG.assertTrue(no == 0);
        return this.offset;
    }

    @Override
    public void accept(@NotNull ControlFlowInstructionVisitor visitor, int offset, int nextOffset) {
        visitor.visitGoToInstruction(this, offset, nextOffset);
    }
}

