/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class InstructionKey
implements Comparable<InstructionKey> {
    private final int myOffset;
    private final int[] myCallStack;

    private InstructionKey(int offset, @NotNull int[] callStack) {
        this.myOffset = offset;
        this.myCallStack = callStack;
    }

    @NotNull
    static InstructionKey create(int offset) {
        return new InstructionKey(offset, ArrayUtil.EMPTY_INT_ARRAY);
    }

    @NotNull
    InstructionKey next(int nextOffset) {
        return new InstructionKey(nextOffset, this.myCallStack);
    }

    @NotNull
    InstructionKey push(int nextOffset, int returnOffset) {
        if (this.myCallStack.length > 100) {
            throw new OverflowException(this.myOffset);
        }
        int[] nextStack = ArrayUtil.append((int[])this.myCallStack, (int)returnOffset);
        return new InstructionKey(nextOffset, nextStack);
    }

    @NotNull
    InstructionKey pop(int overriddenOffset) {
        int returnOffset = this.myCallStack[this.myCallStack.length - 1];
        int[] nextStack = ArrayUtil.realloc((int[])this.myCallStack, (int)(this.myCallStack.length - 1));
        int nextOffset = overriddenOffset != 0 ? overriddenOffset : returnOffset;
        return new InstructionKey(nextOffset, nextStack);
    }

    int getOffset() {
        return this.myOffset;
    }

    @NotNull
    int[] getCallStack() {
        return this.myCallStack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstructionKey key2 = (InstructionKey)o;
        return this.myOffset == key2.myOffset && Arrays.equals(this.myCallStack, key2.myCallStack);
    }

    public int hashCode() {
        return 31 * this.myOffset + Arrays.hashCode(this.myCallStack);
    }

    public String toString() {
        if (this.myCallStack.length == 0) {
            return String.valueOf(this.myOffset);
        }
        StringBuilder s = new StringBuilder();
        for (int offset : this.myCallStack) {
            if (s.length() != 0) {
                s.append(',');
            }
            s.append(offset);
        }
        return this.myOffset + "[" + s + "]";
    }

    @Override
    public int compareTo(@NotNull InstructionKey key2) {
        int c = this.myOffset - key2.myOffset;
        if (c != 0) {
            return c;
        }
        int len = Math.min(this.myCallStack.length, key2.myCallStack.length);
        for (int i = 0; i < len; ++i) {
            c = this.myCallStack[i] - key2.myCallStack[i];
            if (c == 0) continue;
            return c;
        }
        c = this.myCallStack.length - key2.myCallStack.length;
        return c;
    }

    static class OverflowException
    extends RuntimeException {
        OverflowException(int offset) {
            super("Instruction key overflow at offset " + offset);
        }
    }
}

