/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.CallChunkBlockBuilder;
import com.intellij.psi.formatter.java.ChainedCallChunk;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.impl.source.tree.JavaElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ChainMethodCallsBlockBuilder {
    private final CommonCodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentSettings;
    private final JavaCodeStyleSettings myJavaSettings;
    private final Wrap myBlockWrap;
    private final Alignment myBlockAlignment;
    private final Indent myBlockIndent;
    private final FormattingMode myFormattingMode;

    ChainMethodCallsBlockBuilder(Alignment alignment, Wrap wrap, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        this.myBlockWrap = wrap;
        this.myBlockAlignment = alignment;
        this.myBlockIndent = indent;
        this.mySettings = settings;
        this.myIndentSettings = settings.getIndentOptions();
        this.myJavaSettings = javaSettings;
        this.myFormattingMode = formattingMode;
    }

    public Block build(List<? extends ASTNode> nodes) {
        List<Block> blocks = this.buildBlocksFrom(nodes);
        Indent indent = this.myBlockIndent != null ? this.myBlockIndent : Indent.getContinuationWithoutFirstIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
        return new SyntheticCodeBlock(blocks, this.myBlockAlignment, this.mySettings, this.myJavaSettings, indent, this.myBlockWrap);
    }

    private List<Block> buildBlocksFrom(List<? extends ASTNode> nodes) {
        List<ChainedCallChunk> methodCall = ChainMethodCallsBlockBuilder.splitMethodCallOnChunksByDots(nodes);
        Wrap wrap = null;
        Alignment chainedCallsAlignment = null;
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int i = 0; i < methodCall.size(); ++i) {
            ChainedCallChunk currentCallChunk = methodCall.get(i);
            if (ChainMethodCallsBlockBuilder.isMethodCall(currentCallChunk) || ChainMethodCallsBlockBuilder.isComment(currentCallChunk)) {
                if (wrap == null) {
                    wrap = this.createCallChunkWrap(i, methodCall);
                }
                if (chainedCallsAlignment == null) {
                    chainedCallsAlignment = this.createCallChunkAlignment(i, methodCall);
                }
            } else {
                wrap = null;
                chainedCallsAlignment = null;
            }
            CallChunkBlockBuilder builder = new CallChunkBlockBuilder(this.mySettings, this.myJavaSettings, this.myFormattingMode);
            blocks.add(builder.create(currentCallChunk.nodes, wrap, chainedCallsAlignment));
        }
        return blocks;
    }

    private static boolean isComment(ChainedCallChunk chunk) {
        List<ASTNode> nodes = chunk.nodes;
        if (nodes.size() == 1) {
            return nodes.get(0).getPsi() instanceof PsiComment;
        }
        return false;
    }

    private Wrap createCallChunkWrap(int chunkIndex, @NotNull List<? extends ChainedCallChunk> methodCall) {
        if (this.mySettings.WRAP_FIRST_METHOD_IN_CALL_CHAIN) {
            ChainedCallChunk next;
            ChainedCallChunk chainedCallChunk = next = chunkIndex + 1 < methodCall.size() ? methodCall.get(chunkIndex + 1) : null;
            if (next != null && ChainMethodCallsBlockBuilder.isMethodCall(next)) {
                return Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.METHOD_CALL_CHAIN_WRAP), (boolean)true);
            }
        }
        return Wrap.createWrap((WrapType)JavaFormatterUtil.getWrapType(this.mySettings.METHOD_CALL_CHAIN_WRAP), (boolean)false);
    }

    private boolean shouldAlignMethod(ChainedCallChunk currentMethodChunk, List<ChainedCallChunk> methodCall) {
        return this.mySettings.ALIGN_MULTILINE_CHAINED_METHODS && !currentMethodChunk.isEmpty() && !ChainMethodCallsBlockBuilder.chunkIsFirstInChainMethodCall(currentMethodChunk, methodCall);
    }

    private static boolean chunkIsFirstInChainMethodCall(@NotNull ChainedCallChunk callChunk, @NotNull List<ChainedCallChunk> methodCall) {
        return !methodCall.isEmpty() && callChunk == methodCall.get(0);
    }

    @NotNull
    private static List<ChainedCallChunk> splitMethodCallOnChunksByDots(@NotNull List<? extends ASTNode> nodes) {
        ArrayList<ChainedCallChunk> result = new ArrayList<ChainedCallChunk>();
        ArrayList<Object> current = new ArrayList<ASTNode>();
        for (ASTNode aSTNode : nodes) {
            if (aSTNode.getElementType() == JavaTokenType.DOT || aSTNode.getPsi() instanceof PsiComment) {
                if (!current.isEmpty()) {
                    result.add(new ChainedCallChunk(current));
                }
                current = new ArrayList();
            }
            current.add(aSTNode);
        }
        if (!current.isEmpty()) {
            result.add(new ChainedCallChunk(current));
        }
        return result;
    }

    private Alignment createCallChunkAlignment(int chunkIndex, @NotNull List<ChainedCallChunk> methodCall) {
        ChainedCallChunk current = methodCall.get(chunkIndex);
        return this.shouldAlignMethod(current, methodCall) ? AbstractJavaBlock.createAlignment(this.mySettings.ALIGN_MULTILINE_CHAINED_METHODS, null) : null;
    }

    private static boolean isMethodCall(@NotNull ChainedCallChunk callChunk) {
        List<ASTNode> nodes = callChunk.nodes;
        return nodes.size() >= 3 && nodes.get(2).getElementType() == JavaElementType.EXPRESSION_LIST;
    }
}

