/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.PsiAwareDefaultLineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLineWrapPositionStrategy
extends PsiAwareDefaultLineWrapPositionStrategy {
    private static final IElementType[] ALLOWED_TYPES = new IElementType[]{JavaTokenType.C_STYLE_COMMENT, JavaTokenType.END_OF_LINE_COMMENT, JavaTokenType.STRING_LITERAL, JavaDocTokenType.DOC_COMMENT_DATA, JavaTokenType.EQ, JavaTokenType.COMMA, JavaTokenType.QUEST, JavaTokenType.COLON};
    public static final String A_LINK_START = "<a";
    public static final String A_LINK_END = "</a>";

    public JavaLineWrapPositionStrategy() {
        super(true, ALLOWED_TYPES);
    }

    protected int doCalculateWrapPosition(@NotNull Document document, @Nullable Project project, @NotNull PsiElement element, int startOffset, int endOffset, int maxPreferredOffset, boolean isSoftWrap) {
        CharSequence docChars;
        int refStart;
        if (element.getNode().getElementType() == JavaDocTokenType.DOC_COMMENT_DATA && (refStart = CharArrayUtil.indexOf((CharSequence)(docChars = document.getCharsSequence()), (CharSequence)A_LINK_START, (int)startOffset, (int)endOffset)) >= 0 && refStart < maxPreferredOffset) {
            int refEnd = CharArrayUtil.indexOf((CharSequence)docChars, (CharSequence)A_LINK_END, (int)refStart, (int)endOffset);
            if (refEnd >= 0 && refEnd < maxPreferredOffset) {
                return refEnd + A_LINK_END.length();
            }
            return refStart;
        }
        int wrapPos = super.doCalculateWrapPosition(document, project, element, startOffset, endOffset, maxPreferredOffset, isSoftWrap);
        if (element.getNode().getElementType() == JavaTokenType.STRING_LITERAL) {
            TextRange range = element.getTextRange();
            if (range.getEndOffset() - wrapPos <= 1) {
                wrapPos = range.getEndOffset();
            } else if (wrapPos - range.getStartOffset() <= 1) {
                wrapPos = range.getStartOffset();
            }
        }
        return wrapPos;
    }
}

