/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleJavaBlock
extends AbstractJavaBlock {
    private final Map<IElementType, Wrap> myReservedWrap = ContainerUtil.newHashMap();
    private int myStartOffset = -1;
    private int myCurrentOffset;
    private Indent myCurrentIndent;
    private ASTNode myCurrentChild;

    public SimpleJavaBlock(ASTNode node, Wrap wrap, AlignmentStrategy alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        super(node, wrap, alignment, indent, settings, javaSettings, formattingMode);
    }

    protected List<Block> buildChildren() {
        this.myCurrentChild = this.myNode.getFirstChildNode();
        this.myCurrentOffset = this.myStartOffset;
        if (this.myCurrentOffset == -1) {
            this.myCurrentOffset = this.myCurrentChild != null ? this.myCurrentChild.getTextRange().getStartOffset() : 0;
        }
        ArrayList<Block> result = new ArrayList<Block>();
        this.myCurrentIndent = null;
        this.processHeadCommentsAndWhiteSpaces(result);
        this.calculateReservedAlignments();
        Wrap childWrap = this.createChildWrap();
        this.processRemainingChildren(result, childWrap);
        return result;
    }

    private void calculateReservedAlignments() {
        this.myReservedAlignment = this.createChildAlignment();
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JavaElementType.CONDITIONAL_EXPRESSION && this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION) {
            this.myReservedAlignment2 = this.myReservedAlignment != null ? Alignment.createChildAlignment((Alignment)this.myReservedAlignment) : Alignment.createAlignment();
        }
    }

    private void processRemainingChildren(List<Block> result, Wrap childWrap) {
        while (this.myCurrentChild != null) {
            if (SimpleJavaBlock.isNotEmptyNode(this.myCurrentChild)) {
                ASTNode astNode = this.myCurrentChild;
                AlignmentStrategy alignmentStrategyToUse = AlignmentStrategy.wrap((Alignment)this.chooseAlignment(this.myReservedAlignment, this.myReservedAlignment2, this.myCurrentChild), (IElementType[])new IElementType[0]);
                if (this.myNode.getElementType() == JavaElementType.FIELD || this.myNode.getElementType() == JavaElementType.DECLARATION_STATEMENT || this.myNode.getElementType() == JavaElementType.LOCAL_VARIABLE) {
                    alignmentStrategyToUse = this.myAlignmentStrategy;
                }
                this.myCurrentChild = this.processChild(result, astNode, alignmentStrategyToUse, childWrap, this.myCurrentIndent, this.myCurrentOffset);
                if (astNode != this.myCurrentChild && this.myCurrentChild != null) {
                    this.myCurrentOffset = this.myCurrentChild.getTextRange().getStartOffset();
                }
                if (this.myCurrentIndent != null && !(this.myNode.getPsi() instanceof PsiFile) && this.myCurrentChild != null && this.myCurrentChild.getElementType() != JavaElementType.MODIFIER_LIST) {
                    this.myCurrentIndent = Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
                }
            }
            if (this.myCurrentChild == null) continue;
            this.myCurrentOffset += this.myCurrentChild.getTextLength();
            this.myCurrentChild = this.myCurrentChild.getTreeNext();
        }
    }

    private void processHeadCommentsAndWhiteSpaces(@NotNull List<? super Block> result) {
        while (this.myCurrentChild != null) {
            if (StdTokenSets.COMMENT_BIT_SET.contains(this.myCurrentChild.getElementType()) || this.myCurrentChild.getElementType() == JavaDocElementType.DOC_COMMENT) {
                Block commentBlock = this.createJavaBlock(this.myCurrentChild, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), null, AlignmentStrategy.getNullStrategy(), this.getFormattingMode());
                result.add((Block)commentBlock);
                this.myCurrentIndent = Indent.getNoneIndent();
            } else if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)this.myCurrentChild)) break;
            this.myCurrentOffset += this.myCurrentChild.getTextLength();
            this.myCurrentChild = this.myCurrentChild.getTreeNext();
        }
    }

    private static boolean isNotEmptyNode(@NotNull ASTNode child) {
        return !FormatterUtil.containsWhiteSpacesOnly((ASTNode)child) && child.getTextLength() > 0;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.myStartOffset == -1 ? super.getTextRange() : new TextRange(this.myStartOffset, this.myStartOffset + this.myNode.getTextLength());
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.myNode.getElementType() == JavaElementType.CONDITIONAL_EXPRESSION && this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION) {
            Alignment usedAlignment = this.getUsedAlignment(newChildIndex);
            if (usedAlignment != null) {
                return new ChildAttributes(null, usedAlignment);
            }
            return super.getChildAttributes(newChildIndex);
        }
        if (this.myNode.getElementType() == JavaElementType.SWITCH_LABEL_STATEMENT) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        return super.getChildAttributes(newChildIndex);
    }

    @Override
    public Wrap getReservedWrap(IElementType elementType) {
        return this.myReservedWrap.get(elementType);
    }

    @Override
    public void setReservedWrap(Wrap reservedWrap, IElementType operationType) {
        this.myReservedWrap.put(operationType, reservedWrap);
    }

    public void setStartOffset(int startOffset) {
        this.myStartOffset = startOffset;
    }
}

