/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.formatter.java.CompositeAligner;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SubsequentVariablesAlignerConfigurations {
    private static final Set<IElementType> LOCAL_VAR_TYPES_TO_ALIGN = ContainerUtil.newHashSet((Object[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.EQ});
    private static final Set<IElementType> ASSIGN_TYPES_TO_ALIGN = ContainerUtil.newHashSet((Object[])new IElementType[]{JavaElementType.REFERENCE_EXPRESSION, JavaTokenType.EQ});
    static final CompositeAligner.AlignerConfiguration subsequentVariableAligner = new SubsequentVariableAligner();
    static final CompositeAligner.AlignerConfiguration subsequentAssignmentAligner = new SubsequentAssignmentAligner();

    private static class SubsequentAssignmentAligner
    implements CompositeAligner.AlignerConfiguration {
        private SubsequentAssignmentAligner() {
        }

        @Override
        public boolean shouldAlign(@NotNull ASTNode child) {
            ASTNode expressionNode;
            IElementType childType = child.getElementType();
            return childType == JavaElementType.EXPRESSION_STATEMENT && (expressionNode = child.getFirstChildNode()) != null && expressionNode.getElementType() == JavaElementType.ASSIGNMENT_EXPRESSION;
        }

        @Override
        @NotNull
        public AlignmentStrategy createStrategy() {
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)ASSIGN_TYPES_TO_ALIGN, (IElementType)JavaElementType.ASSIGNMENT_EXPRESSION, (boolean)true);
        }
    }

    private static class SubsequentVariableAligner
    implements CompositeAligner.AlignerConfiguration {
        private SubsequentVariableAligner() {
        }

        @Override
        public boolean shouldAlign(@NotNull ASTNode child) {
            return child.getElementType() == JavaElementType.DECLARATION_STATEMENT && StringUtil.countNewLines((CharSequence)child.getChars()) == 0;
        }

        @Override
        @NotNull
        public AlignmentStrategy createStrategy() {
            return AlignmentStrategy.createAlignmentPerTypeStrategy((Collection)LOCAL_VAR_TYPES_TO_ALIGN, (IElementType)JavaElementType.LOCAL_VARIABLE, (boolean)true);
        }
    }
}

