/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeShortNamesCache
extends PsiShortNamesCache {
    private final List<PsiShortNamesCache> myCaches;

    public CompositeShortNamesCache(Project project) {
        this.myCaches = project.isDefault() ? Collections.emptyList() : PsiShortNamesCache.EP_NAME.getExtensionList((AreaInstance)project);
    }

    @NotNull
    public PsiFile[] getFilesByName(@NotNull String name) {
        Merger<PsiFile> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiFile[] classes2 = cache.getFilesByName(name);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiFile>();
            }
            merger.add(classes2);
        }
        PsiFile[] result = merger == null ? null : (PsiFile[])merger.getResult();
        return result != null ? result : PsiFile.EMPTY_ARRAY;
    }

    @NotNull
    public String[] getAllFileNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCaches) {
            merger.add(cache.getAllFileNames());
        }
        String[] result = (String[])merger.getResult();
        return result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        Merger<PsiClass> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiClass[] classes2 = cache.getClassesByName(name, scope);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiClass>();
            }
            merger.add(classes2);
        }
        PsiClass[] result = merger == null ? null : (PsiClass[])merger.getResult();
        return result != null ? result : PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public String[] getAllClassNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCaches) {
            String[] names = cache.getAllClassNames();
            merger.add(names);
        }
        String[] result = (String[])merger.getResult();
        return result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public boolean processAllClassNames(@NotNull Processor<String> processor) {
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor);
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processAllClassNames((Processor)uniqueProcessor)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllClassNames(@NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processAllClassNames(processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllMethodNames(@NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processAllMethodNames(processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllFieldNames(@NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processAllFieldNames(processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiMethod[] methods = cache.getMethodsByName(name, scope);
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        PsiMethod[] result = merger == null ? null : (PsiMethod[])merger.getResult();
        return result == null ? PsiMethod.EMPTY_ARRAY : result;
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiMethod[] methods = cache.getMethodsByNameIfNotMoreThan(name, scope, maxCount);
            if (methods.length == maxCount) {
                return methods;
            }
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        PsiMethod[] result = merger == null ? null : (PsiMethod[])merger.getResult();
        return result == null ? PsiMethod.EMPTY_ARRAY : result;
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiField[] fields = cache.getFieldsByNameIfNotMoreThan(name, scope, maxCount);
            if (fields.length == maxCount) {
                return fields;
            }
            if (fields.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(fields);
        }
        PsiField[] result = merger == null ? null : (PsiField[])merger.getResult();
        return result == null ? PsiField.EMPTY_ARRAY : result;
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        return this.processMethodsWithName(name, processor, scope, null);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processMethodsWithName(name, processor, scope, idFilter)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String[] getAllMethodNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.myCaches) {
            merger.add(cache.getAllMethodNames());
        }
        String[] result = (String[])merger.getResult();
        return result != null ? result : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            PsiField[] classes2 = cache.getFieldsByName(name, scope);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(classes2);
        }
        PsiField[] result = merger == null ? null : (PsiField[])merger.getResult();
        return result == null ? PsiField.EMPTY_ARRAY : result;
    }

    @NotNull
    public String[] getAllFieldNames() {
        Merger<String> merger = null;
        for (PsiShortNamesCache cache : this.myCaches) {
            String[] classes2 = cache.getAllFieldNames();
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<String>();
            }
            merger.add(classes2);
        }
        String[] result = merger == null ? null : (String[])merger.getResult();
        return result == null ? ArrayUtil.EMPTY_STRING_ARRAY : result;
    }

    public boolean processFieldsWithName(@NotNull String key2, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processFieldsWithName(key2, processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processClassesWithName(@NotNull String key2, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        for (PsiShortNamesCache cache : this.myCaches) {
            if (cache.processClassesWithName(key2, processor, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Composite cache: " + Arrays.asList(this.myCaches);
    }

    private static class Merger<T> {
        private T[] mySingleItem;
        private Set<T> myAllItems;

        private Merger() {
        }

        public void add(@NotNull T[] items) {
            if (items.length == 0) {
                return;
            }
            if (this.mySingleItem == null) {
                this.mySingleItem = items;
                return;
            }
            if (this.myAllItems == null) {
                Object[] elements = this.mySingleItem;
                this.myAllItems = (Set)ContainerUtil.addAll((Collection)new THashSet(elements.length), (Object[])elements);
            }
            ContainerUtil.addAll(this.myAllItems, (Object[])items);
        }

        public T[] getResult() {
            if (this.myAllItems == null) {
                return this.mySingleItem;
            }
            return this.myAllItems.toArray(this.mySingleItem);
        }
    }
}

