/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessorBase;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class JavaCodeBlockModificationListener
extends PsiTreeChangePreprocessorBase {
    public JavaCodeBlockModificationListener(@NotNull PsiManager psiManager) {
        super(psiManager);
    }

    protected boolean acceptsEvent(@NotNull PsiTreeChangeEventImpl event) {
        return event.getFile() instanceof PsiClassOwner;
    }

    protected boolean isOutOfCodeBlock(@NotNull PsiElement element) {
        for (PsiElement e : SyntaxTraverser.psiApi().parents((Object)element)) {
            if (e instanceof PsiModifiableCodeBlock && !((PsiModifiableCodeBlock)e).shouldChangeModificationCount(element)) {
                return false;
            }
            if (!(e instanceof PsiClass) && !(e instanceof PsiClassOwner) && !(e instanceof JspDirective)) continue;
            break;
        }
        return true;
    }

    protected boolean isOutOfCodeBlock(@NotNull PsiFileSystemItem file) {
        if (file instanceof PsiModifiableCodeBlock) {
            return ((PsiModifiableCodeBlock)file).shouldChangeModificationCount((PsiElement)file);
        }
        return super.isOutOfCodeBlock(file);
    }

    protected boolean containsStructuralElements(@NotNull PsiElement element) {
        return JavaCodeBlockModificationListener.mayHaveModifiedJavaStructureInside(element);
    }

    protected void onTreeChanged(@NotNull PsiTreeChangeEventImpl event) {
        Set<PsiElement> changedChildren = JavaCodeBlockModificationListener.getChangedChildren(event);
        PsiModificationTrackerImpl tracker = (PsiModificationTrackerImpl)this.myPsiManager.getModificationTracker();
        if (!changedChildren.isEmpty() && changedChildren.stream().anyMatch(JavaCodeBlockModificationListener::mayHaveModifiedJavaStructureInside)) {
            tracker.incCounter();
        }
        if (this.isOutOfCodeBlockChangeEvent(event)) {
            if (changedChildren.isEmpty() || changedChildren.stream().anyMatch(e -> !JavaCodeBlockModificationListener.isWhiteSpaceOrComment(e))) {
                tracker.incCounter();
            } else {
                tracker.incOutOfCodeBlockModificationCounter();
            }
        }
    }

    private static boolean isWhiteSpaceOrComment(@NotNull PsiElement e) {
        return e instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)e, PsiComment.class, (boolean)false) != null;
    }

    private static Set<PsiElement> getChangedChildren(@NotNull PsiTreeChangeEventImpl event) {
        PsiElement parent;
        PsiTreeChangeEventImpl.PsiEventType code = event.getCode();
        if (code == PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED || code == PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED || code == PsiTreeChangeEventImpl.PsiEventType.CHILD_REPLACED) {
            return StreamEx.of((Object[])new PsiElement[]{event.getOldChild(), event.getChild(), event.getNewChild()}).nonNull().toSet();
        }
        if (code == PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REMOVAL || code == PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT) {
            return StreamEx.of((Object[])new PsiElement[]{event.getOldChild(), event.getChild()}).nonNull().toSet();
        }
        if (!(code != PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE || event.isGenericChange() || (parent = event.getParent()) instanceof PsiFileSystemItem || TreeUtil.isCollapsedChameleon((ASTNode)parent.getNode()))) {
            return ContainerUtil.newHashSet((Object[])parent.getChildren());
        }
        return Collections.emptySet();
    }

    private static boolean mayHaveModifiedJavaStructureInside(@NotNull PsiElement root) {
        return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)root).expand(e -> !TreeUtil.isCollapsedChameleon((ASTNode)e.getNode()))).traverse().filter(e -> !(e instanceof PsiModifiableCodeBlock) || ((PsiModifiableCodeBlock)e).shouldChangeModificationCount(e)).filter(e -> e instanceof PsiClass || e instanceof PsiLambdaExpression || TreeUtil.isCollapsedChameleon((ASTNode)e.getNode())).isNotEmpty();
    }
}

