/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.MemberOrderService;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiImplementationHelperImpl
extends JavaPsiImplementationHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.JavaPsiImplementationHelperImpl");
    private final Project myProject;

    public JavaPsiImplementationHelperImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public PsiClass getOriginalClass(@NotNull PsiClass psiClass) {
        return this.findCompiledElement(psiClass, scope -> {
            String fqn = psiClass.getQualifiedName();
            return fqn != null ? Arrays.asList(JavaPsiFacade.getInstance((Project)this.myProject).findClasses(fqn, scope)) : Collections.emptyList();
        });
    }

    @Override
    @NotNull
    public PsiJavaModule getOriginalModule(@NotNull PsiJavaModule module) {
        return this.findCompiledElement(module, scope -> JavaPsiFacade.getInstance((Project)this.myProject).findModules(module.getName(), scope));
    }

    private <T extends PsiElement> T findCompiledElement(T original, Function<? super GlobalSearchScope, ? extends Collection<T>> candidateFinder) {
        PsiCompiledElement cls = (PsiCompiledElement)original.getUserData(ClsElementImpl.COMPILED_ELEMENT);
        if (cls != null && cls.isValid()) {
            PsiCompiledElement t = cls;
            return (T)t;
        }
        if (!DumbService.isDumb((Project)this.myProject)) {
            VirtualFile vFile = original.getContainingFile().getVirtualFile();
            ProjectFileIndex idx = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            if (vFile != null && idx.isInLibrarySource(vFile)) {
                GlobalSearchScope librariesScope = LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope();
                HashSet originalEntries = ContainerUtil.newHashSet((Iterable)idx.getOrderEntriesForFile(vFile));
                for (PsiElement candidate : candidateFinder.apply((GlobalSearchScope)librariesScope)) {
                    VirtualFile candidateVFile;
                    PsiFile candidateFile = candidate.getContainingFile();
                    if (candidateFile == null || (candidateVFile = candidateFile.getVirtualFile()) == null) continue;
                    for (OrderEntry candidateEntry : idx.getOrderEntriesForFile(candidateVFile)) {
                        if (!originalEntries.contains(candidateEntry)) continue;
                        return (T)candidate;
                    }
                }
            }
        }
        return original;
    }

    @Override
    @NotNull
    public PsiElement getClsFileNavigationElement(@NotNull PsiJavaFile clsFile) {
        Function<VirtualFile, VirtualFile> finder = null;
        Predicate<PsiFile> filter = null;
        PsiClass[] classes2 = clsFile.getClasses();
        if (classes2.length > 0) {
            String sourceFileName = ((ClsClassImpl)classes2[0]).getSourceFileName();
            String packageName = clsFile.getPackageName();
            String relativePath = packageName.isEmpty() ? sourceFileName : packageName.replace('.', '/') + '/' + sourceFileName;
            finder = root -> root.findFileByRelativePath(relativePath);
            filter = PsiClassOwner.class::isInstance;
        } else {
            PsiJavaModule module = clsFile.getModuleDeclaration();
            if (module != null) {
                String moduleName = module.getName();
                finder = root -> !JrtFileSystem.isModuleRoot((VirtualFile)root) || moduleName.equals(root.getName()) ? root.findChild("module-info.java") : null;
                filter = psi -> {
                    PsiJavaModule candidate = psi instanceof PsiJavaFile ? ((PsiJavaFile)psi).getModuleDeclaration() : null;
                    return candidate != null && moduleName.equals(candidate.getName());
                };
            }
        }
        if (finder == null) {
            return clsFile;
        }
        return (PsiElement)this.findSourceRoots(clsFile.getContainingFile().getVirtualFile()).map(finder).filter(source -> source != null && source.isValid()).map(arg_0 -> ((PsiManager)PsiManager.getInstance((Project)this.myProject)).findFile(arg_0)).filter(filter).findFirst().orElse((PsiFile)clsFile);
    }

    private Stream<VirtualFile> findSourceRoots(VirtualFile file) {
        Stream modelRoots = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getOrderEntriesForFile(file).stream().filter(entry -> entry instanceof LibraryOrSdkOrderEntry && entry.isValid()).flatMap(entry -> Stream.of(entry.getFiles(OrderRootType.SOURCES)));
        Stream synthRoots = AdditionalLibraryRootsProvider.EP_NAME.getExtensionList().stream().flatMap(provider -> provider.getAdditionalProjectLibraries(this.myProject).stream()).filter(library -> library.contains(file, false, true)).flatMap(library -> library.getSourceRoots().stream());
        return Stream.concat(modelRoots, synthRoots);
    }

    @Override
    @NotNull
    public LanguageLevel getEffectiveLanguageLevel(@Nullable VirtualFile virtualFile) {
        LanguageLevel level;
        if (virtualFile == null || this.myProject.isDefault()) {
            return PsiUtil.getLanguageLevel((Project)this.myProject);
        }
        VirtualFile parent = virtualFile.getParent();
        if (parent != null && (level = (LanguageLevel)parent.getUserData(LanguageLevel.KEY)) != null) {
            return level;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        Module module = index.getModuleForFile(virtualFile);
        if (module != null && index.isInSourceContent(virtualFile)) {
            return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
        }
        LanguageLevel classesLanguageLevel = this.getClassesLanguageLevel(virtualFile);
        return classesLanguageLevel != null ? classesLanguageLevel : PsiUtil.getLanguageLevel((Project)this.myProject);
    }

    @Nullable
    private LanguageLevel getClassesLanguageLevel(VirtualFile virtualFile) {
        VirtualFile folder;
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile sourceRoot = index.getSourceRootForFile(virtualFile);
        VirtualFile virtualFile2 = folder = virtualFile.isDirectory() ? virtualFile : virtualFile.getParent();
        if (sourceRoot != null && sourceRoot.isDirectory() && folder != null) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)folder, (VirtualFile)sourceRoot, (char)'/');
            if (relativePath == null) {
                LOG.error("Null relative path: folder=" + folder + "; root=" + sourceRoot);
                return null;
            }
            String className = virtualFile.getNameWithoutExtension();
            HashSet visitedRoots = ContainerUtil.newHashSet();
            for (OrderEntry entry : index.getOrderEntriesForFile(virtualFile)) {
                for (VirtualFile rootFile : entry.getFiles(OrderRootType.CLASSES)) {
                    PsiJavaFile javaFile;
                    if (!visitedRoots.add(rootFile)) continue;
                    VirtualFile classFile = rootFile.findFileByRelativePath(relativePath);
                    PsiJavaFile psiJavaFile = javaFile = classFile == null ? null : this.getPsiFileInRoot(classFile, className);
                    if (javaFile == null) continue;
                    return javaFile.getLanguageLevel();
                }
            }
            return LanguageLevelProjectExtension.getInstance((Project)this.myProject).getLanguageLevel();
        }
        return null;
    }

    @Nullable
    private PsiJavaFile getPsiFileInRoot(VirtualFile dirFile, @Nullable String className) {
        VirtualFile[] children;
        PsiFile psiFile;
        VirtualFile classFile;
        if (className != null && (classFile = dirFile.findChild(StringUtil.getQualifiedName((String)className, (String)StdFileTypes.CLASS.getDefaultExtension()))) != null && (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(classFile)) instanceof PsiJavaFile) {
            return (PsiJavaFile)psiFile;
        }
        for (VirtualFile child : children = dirFile.getChildren()) {
            PsiFile psiFile2;
            if (!StdFileTypes.CLASS.equals(child.getFileType()) || !child.isValid() || !((psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(child)) instanceof PsiJavaFile)) continue;
            return (PsiJavaFile)psiFile2;
        }
        return null;
    }

    @Override
    public ASTNode getDefaultImportAnchor(@NotNull PsiImportList list, @NotNull PsiImportStatementBase statement) {
        ImportHelper importHelper = new ImportHelper(JavaCodeStyleSettings.getInstance(statement.getContainingFile()));
        return importHelper.getDefaultAnchor(list, statement);
    }

    @Override
    @Nullable
    public PsiElement getDefaultMemberAnchor(@NotNull PsiClass aClass, @NotNull PsiMember member) {
        PsiElement lBrace;
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)aClass.getContainingFile());
        MemberOrderService service = (MemberOrderService)ServiceManager.getService(MemberOrderService.class);
        PsiElement anchor = service.getAnchor((PsiElement)member, settings.getCommonSettings((Language)JavaLanguage.INSTANCE), (PsiElement)aClass);
        PsiElement newAnchor = JavaPsiImplementationHelperImpl.skipWhitespaces(aClass, anchor);
        if (newAnchor != null) {
            return newAnchor;
        }
        if (anchor != null && anchor != aClass) {
            anchor = anchor.getNextSibling();
            while (anchor instanceof PsiJavaToken && (anchor.getText().equals(",") || anchor.getText().equals(";"))) {
                boolean afterComma = anchor.getText().equals(",");
                anchor = anchor.getNextSibling();
                if (!afterComma || (newAnchor = JavaPsiImplementationHelperImpl.skipWhitespaces(aClass, anchor)) == null) continue;
                return newAnchor;
            }
            if (anchor != null) {
                return anchor;
            }
        }
        if ((lBrace = aClass.getLBrace()) != null) {
            PsiElement result = lBrace.getNextSibling();
            while (result instanceof PsiWhiteSpace) {
                result = result.getNextSibling();
            }
            return result;
        }
        return aClass.getRBrace();
    }

    private static PsiElement skipWhitespaces(PsiClass aClass, PsiElement anchor) {
        if (anchor != null && PsiTreeUtil.skipWhitespacesForward((PsiElement)anchor) == aClass.getRBrace()) {
            return aClass.getRBrace();
        }
        return null;
    }

    @Override
    public void setupCatchBlock(@NotNull String exceptionName, @NotNull PsiType exceptionType, PsiElement context, @NotNull PsiCatchSection catchSection) {
        PsiDirectory directory;
        FileTemplate template = FileTemplateManager.getInstance((Project)catchSection.getProject()).getCodeTemplate("Catch Statement Body.java");
        FileTemplate declarationTemplate = FileTemplateManager.getInstance((Project)catchSection.getProject()).getCodeTemplate("Catch Statement Declaration.java");
        Properties props = FileTemplateManager.getInstance((Project)this.myProject).getDefaultProperties();
        props.setProperty("EXCEPTION", exceptionName);
        props.setProperty("EXCEPTION_TYPE", exceptionType.getCanonicalText());
        if (context != null && context.isPhysical() && (directory = context.getContainingFile().getContainingDirectory()) != null) {
            JavaTemplateUtil.setPackageNameAttribute(props, directory);
        }
        try {
            String parameterName;
            PsiTryStatement tryStmt = (PsiTryStatement)PsiElementFactory.SERVICE.getInstance((Project)this.myProject).createStatementFromText("try {} catch (" + declarationTemplate.getText(props) + ") {\n}", null);
            PsiParameter parameter2 = tryStmt.getCatchSections()[0].getParameter();
            String string = parameterName = parameter2 == null ? null : parameter2.getName();
            if (parameterName != null) {
                PsiParameter sectionParameter;
                if (!exceptionName.equals(parameterName)) {
                    parameterName = JavaCodeStyleManager.getInstance((Project)this.myProject).suggestUniqueVariableName(parameterName, context, false);
                    props.setProperty("EXCEPTION", parameterName);
                    parameter2.setName(parameterName);
                }
                if ((sectionParameter = catchSection.getParameter()) != null) {
                    sectionParameter.replace((PsiElement)parameter2);
                }
            }
            PsiCodeBlock block = PsiElementFactory.SERVICE.getInstance((Project)this.myProject).createCodeBlockFromText("{\n" + template.getText(props) + "\n}", null);
            Objects.requireNonNull(catchSection.getCatchBlock()).replace((PsiElement)block);
        }
        catch (ProcessCanceledException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Incorrect file template", (Throwable)e);
        }
    }
}

