/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaParserFacadeImpl
implements PsiJavaParserFacade {
    private static final String DUMMY_FILE_NAME = "_Dummy_." + JavaFileType.INSTANCE.getDefaultExtension();
    private static final JavaParserUtil.ParserWrapper ANNOTATION = builder -> JavaParser.INSTANCE.getDeclarationParser().parseAnnotation(builder);
    private static final JavaParserUtil.ParserWrapper PARAMETER = builder -> JavaParser.INSTANCE.getDeclarationParser().parseParameter(builder, true, false, false);
    private static final JavaParserUtil.ParserWrapper RESOURCE = builder -> JavaParser.INSTANCE.getDeclarationParser().parseResource(builder);
    private static final JavaParserUtil.ParserWrapper TYPE = builder -> {
        int flags = 151;
        JavaParser.INSTANCE.getReferenceParser().parseType(builder, flags);
    };
    public static final JavaParserUtil.ParserWrapper REFERENCE = builder -> JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, false, true, false, false);
    private static final JavaParserUtil.ParserWrapper DIAMOND_REF = builder -> JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, false, true, false, true);
    private static final JavaParserUtil.ParserWrapper STATIC_IMPORT_REF = builder -> JavaParser.INSTANCE.getReferenceParser().parseImportCodeReference(builder, true);
    private static final JavaParserUtil.ParserWrapper TYPE_PARAMETER = builder -> JavaParser.INSTANCE.getReferenceParser().parseTypeParameter(builder);
    private static final JavaParserUtil.ParserWrapper DECLARATION = builder -> JavaParser.INSTANCE.getDeclarationParser().parse(builder, DeclarationParser.Context.CLASS);
    private static final JavaParserUtil.ParserWrapper CODE_BLOCK = builder -> JavaParser.INSTANCE.getStatementParser().parseCodeBlockDeep(builder, true);
    private static final JavaParserUtil.ParserWrapper STATEMENT = builder -> JavaParser.INSTANCE.getStatementParser().parseStatement(builder);
    private static final JavaParserUtil.ParserWrapper EXPRESSION = builder -> JavaParser.INSTANCE.getExpressionParser().parse(builder);
    private static final JavaParserUtil.ParserWrapper ENUM_CONSTANT = builder -> JavaParser.INSTANCE.getDeclarationParser().parseEnumConstant(builder);
    private static final JavaParserUtil.ParserWrapper MODULE = builder -> JavaParser.INSTANCE.getModuleParser().parse(builder);
    private static final Map<String, PsiPrimitiveType> PRIMITIVE_TYPES = new HashMap<String, PsiPrimitiveType>();
    protected final PsiManager myManager;

    public PsiJavaParserFacadeImpl(PsiManager manager) {
        this.myManager = manager;
    }

    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, ANNOTATION, PsiJavaParserFacadeImpl.level(context)), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect annotation '" + text2 + "'", holder);
        }
        return (PsiAnnotation)element;
    }

    @NotNull
    public PsiDocTag createDocTagFromText(@NotNull String text2) throws IncorrectOperationException {
        return this.createDocCommentFromText(StringUtil.join((String[])new String[]{"/**\n", text2, "\n */"})).getTags()[0];
    }

    @NotNull
    public PsiDocComment createDocCommentFromText(@NotNull String docCommentText) throws IncorrectOperationException {
        return this.createDocCommentFromText(docCommentText, null);
    }

    @NotNull
    public PsiDocComment createDocCommentFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiMethod method = this.createMethodFromText(text2.trim() + "void m();", context);
        PsiDocComment comment = method.getDocComment();
        if (comment == null) {
            throw new IncorrectOperationException("Incorrect comment '" + text2 + "'");
        }
        return comment;
    }

    @NotNull
    public PsiClass createClassFromText(@NotNull String body2, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile(StringUtil.join((String[])new String[]{"class _Dummy_ {\n", body2, "\n}"}));
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length != 1) {
            throw new IncorrectOperationException("Incorrect class '" + body2 + "'");
        }
        return classes2[0];
    }

    @NotNull
    public PsiField createFieldFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, DECLARATION, PsiJavaParserFacadeImpl.level(context)), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiField)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect field '" + text2 + "'", holder);
        }
        return (PsiField)element;
    }

    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text2, @Nullable PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, DECLARATION, level), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiMethod)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect method '" + text2 + "'", holder);
        }
        return (PsiMethod)element;
    }

    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        LanguageLevel level = LanguageLevelProjectExtension.getInstance((Project)this.myManager.getProject()).getLanguageLevel();
        return this.createMethodFromText(text2, context, level);
    }

    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, PARAMETER, PsiJavaParserFacadeImpl.level(context)), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiParameter)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect parameter '" + text2 + "'", holder);
        }
        return (PsiParameter)element;
    }

    @NotNull
    public PsiResourceVariable createResourceFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, RESOURCE, PsiJavaParserFacadeImpl.level(context)), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiResourceVariable)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect resource '" + text2 + "'", holder);
        }
        return (PsiResourceVariable)element;
    }

    @NotNull
    public PsiType createTypeFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        return this.createTypeInner(text2, context, false);
    }

    @NotNull
    public PsiTypeElement createTypeElementFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        LanguageLevel level = PsiJavaParserFacadeImpl.level(context);
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, TYPE, level), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiTypeElement)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect type '" + text2 + "' (" + level + ")", holder);
        }
        return (PsiTypeElement)element;
    }

    PsiType createTypeInner(String text2, @Nullable PsiElement context, boolean markAsCopy) throws IncorrectOperationException {
        PsiPrimitiveType primitiveType = PRIMITIVE_TYPES.get(text2);
        if (primitiveType != null) {
            return primitiveType;
        }
        PsiTypeElement element = this.createTypeElementFromText(text2, context);
        if (markAsCopy) {
            GeneratedMarkerVisitor.markGenerated((PsiElement)element);
        }
        return element.getType();
    }

    @NotNull
    public PsiJavaCodeReferenceElement createReferenceFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        boolean mayHaveDiamonds;
        boolean isStaticImport = context instanceof PsiImportStaticStatement && !((PsiImportStaticStatement)context).isOnDemand();
        boolean bl = mayHaveDiamonds = context instanceof PsiNewExpression && PsiUtil.getLanguageLevel((PsiElement)context).isAtLeast(LanguageLevel.JDK_1_7);
        JavaParserUtil.ParserWrapper wrapper = isStaticImport ? STATIC_IMPORT_REF : (mayHaveDiamonds ? DIAMOND_REF : REFERENCE);
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, wrapper, PsiJavaParserFacadeImpl.level(context)), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect reference '" + text2 + "'", holder);
        }
        return (PsiJavaCodeReferenceElement)element;
    }

    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, CODE_BLOCK, PsiJavaParserFacadeImpl.level(context), true), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiCodeBlock)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect code block '" + text2 + "'", holder);
        }
        return (PsiCodeBlock)element;
    }

    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, STATEMENT, PsiJavaParserFacadeImpl.level(context)), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiStatement)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect statement '" + text2 + "'", holder);
        }
        return (PsiStatement)element;
    }

    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, EXPRESSION, PsiJavaParserFacadeImpl.level(context)), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiExpression)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect expression '" + text2 + "'", holder);
        }
        return (PsiExpression)element;
    }

    PsiJavaFile createDummyJavaFile(@NonNls String text2) {
        return (PsiJavaFile)PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText(DUMMY_FILE_NAME, (FileType)JavaFileType.INSTANCE, (CharSequence)text2);
    }

    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, TYPE_PARAMETER, PsiJavaParserFacadeImpl.level(context)), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiTypeParameter)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect type parameter '" + text2 + "'", holder);
        }
        return (PsiTypeParameter)element;
    }

    @NotNull
    public PsiComment createCommentFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile(text2);
        for (PsiElement aChildren : aFile.getChildren()) {
            if (!(aChildren instanceof PsiComment)) continue;
            if (!aChildren.getText().equals(text2)) break;
            PsiComment comment = (PsiComment)aChildren;
            DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)comment)), (PsiElement)context);
            return comment;
        }
        throw new IncorrectOperationException("Incorrect comment '" + text2 + "'");
    }

    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, ENUM_CONSTANT, PsiJavaParserFacadeImpl.level(context)), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiEnumConstant)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect enum constant '" + text2 + "'", holder);
        }
        return (PsiEnumConstant)element;
    }

    @NotNull
    public PsiType createPrimitiveTypeFromText(@NotNull String text2) throws IncorrectOperationException {
        PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType(text2);
        if (primitiveType == null) {
            throw new IncorrectOperationException("Incorrect primitive type '" + text2 + "'");
        }
        return primitiveType;
    }

    @NotNull
    public PsiJavaModule createModuleFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text2, MODULE, LanguageLevel.JDK_1_9), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiJavaModule)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect module declaration '" + text2 + "'", holder);
        }
        return (PsiJavaModule)element;
    }

    @NotNull
    public PsiStatement createModuleStatementFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        String template = "module M { " + text2 + "; }";
        PsiJavaModule module = this.createModuleFromText(template, context);
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getChildOfType((PsiElement)module, PsiStatement.class);
        if (statement == null) {
            throw new IncorrectOperationException("Incorrect module statement '" + text2 + "'");
        }
        return statement;
    }

    @NotNull
    public PsiJavaModuleReferenceElement createModuleReferenceFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        return this.createModuleFromText("module " + text2 + " {}", context).getNameIdentifier();
    }

    public static PsiPrimitiveType getPrimitiveType(String text2) {
        return PRIMITIVE_TYPES.get(text2);
    }

    protected static LanguageLevel level(@Nullable PsiElement context) {
        return context != null && context.isValid() ? PsiUtil.getLanguageLevel((PsiElement)context) : LanguageLevel.HIGHEST;
    }

    private static IncorrectOperationException newException(String msg, DummyHolder holder) {
        Throwable cause;
        FileElement root = holder.getTreeElement();
        if (root instanceof JavaDummyElement && (cause = ((JavaDummyElement)root).getParserError()) != null) {
            return new IncorrectOperationException(msg, cause);
        }
        return new IncorrectOperationException(msg);
    }

    static {
        PRIMITIVE_TYPES.put(PsiType.BYTE.getCanonicalText(), PsiType.BYTE);
        PRIMITIVE_TYPES.put(PsiType.CHAR.getCanonicalText(), PsiType.CHAR);
        PRIMITIVE_TYPES.put(PsiType.DOUBLE.getCanonicalText(), PsiType.DOUBLE);
        PRIMITIVE_TYPES.put(PsiType.FLOAT.getCanonicalText(), PsiType.FLOAT);
        PRIMITIVE_TYPES.put(PsiType.INT.getCanonicalText(), PsiType.INT);
        PRIMITIVE_TYPES.put(PsiType.LONG.getCanonicalText(), PsiType.LONG);
        PRIMITIVE_TYPES.put(PsiType.SHORT.getCanonicalText(), PsiType.SHORT);
        PRIMITIVE_TYPES.put(PsiType.BOOLEAN.getCanonicalText(), PsiType.BOOLEAN);
        PRIMITIVE_TYPES.put(PsiType.VOID.getCanonicalText(), PsiType.VOID);
        PRIMITIVE_TYPES.put(PsiType.NULL.getCanonicalText(), PsiType.NULL);
    }
}

