/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.java.stubs.index.JavaFieldNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaMethodNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaShortClassNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiShortNamesCacheImpl
extends PsiShortNamesCache {
    private final Project myProject;

    public PsiShortNamesCacheImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public PsiFile[] getFilesByName(@NotNull String name) {
        return FilenameIndex.getFilesByName((Project)this.myProject, (String)name, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
    }

    @NotNull
    public String[] getAllFileNames() {
        return FilenameIndex.getAllFilenames((Project)this.myProject);
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        Collection<PsiClass> classes2 = JavaShortClassNameIndex.getInstance().get(name, this.myProject, scope);
        if (classes2.isEmpty()) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(classes2.size());
        THashMap uniqueQName2Classes = new THashMap(classes2.size());
        Set hiddenClassesToRemove = null;
        block0: for (PsiClass aClass : classes2) {
            VirtualFile vFile = aClass.getContainingFile().getVirtualFile();
            if (!scope.contains(vFile)) continue;
            String qName = aClass.getQualifiedName();
            if (qName != null) {
                List previousQNamedClasses = (List)uniqueQName2Classes.get(qName);
                SmartList qNamedClasses = new SmartList();
                if (previousQNamedClasses != null) {
                    for (PsiClass previousClass : previousQNamedClasses) {
                        VirtualFile previousClassVFile = previousClass.getContainingFile().getVirtualFile();
                        int res = scope.compare(previousClassVFile, vFile);
                        if (res > 0) continue block0;
                        if (res < 0) {
                            if (hiddenClassesToRemove == null) {
                                hiddenClassesToRemove = new THashSet();
                            }
                            hiddenClassesToRemove.add(previousClass);
                            qNamedClasses.add(aClass);
                            continue;
                        }
                        qNamedClasses.add(aClass);
                    }
                } else {
                    qNamedClasses.add(aClass);
                }
                uniqueQName2Classes.put(qName, qNamedClasses);
            }
            result.add(aClass);
        }
        if (hiddenClassesToRemove != null) {
            result.removeAll(hiddenClassesToRemove);
        }
        return result.toArray(PsiClass.EMPTY_ARRAY);
    }

    @NotNull
    public String[] getAllClassNames() {
        return ArrayUtil.toStringArray((Collection)JavaShortClassNameIndex.getInstance().getAllKeys(this.myProject));
    }

    public boolean processAllClassNames(@NotNull Processor<String> processor) {
        return JavaShortClassNameIndex.getInstance().processAllKeys(this.myProject, processor);
    }

    public boolean processAllClassNames(@NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.CLASS_SHORT_NAMES, processor, scope, filter);
    }

    public boolean processAllMethodNames(@NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.METHODS, processor, scope, filter);
    }

    public boolean processAllFieldNames(@NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.FIELDS, processor, scope, filter);
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        Collection<PsiMethod> methods = JavaMethodNameIndex.getInstance().get(name, this.myProject, scope);
        return (PsiMethod[])this.filterMembers(methods, scope, (PsiMember[])PsiMethod.EMPTY_ARRAY);
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        SmartList methods = new SmartList();
        CommonProcessors.CollectProcessor<PsiMethod> processor = new CommonProcessors.CollectProcessor<PsiMethod>((Collection)methods, (List)methods, maxCount){
            final /* synthetic */ List val$methods;
            final /* synthetic */ int val$maxCount;
            {
                this.val$methods = list;
                this.val$maxCount = n;
                super(x0);
            }

            public boolean process(PsiMethod method) {
                return this.val$methods.size() != this.val$maxCount && super.process((Object)method);
            }
        };
        StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name, this.myProject, scope, PsiMethod.class, (Processor)processor);
        return (PsiMethod[])this.filterMembers((Collection)methods, scope, (PsiMember[])PsiMethod.EMPTY_ARRAY);
    }

    public boolean processMethodsWithName(@NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name, this.myProject, scope, PsiMethod.class, processor);
    }

    @NotNull
    public String[] getAllMethodNames() {
        return ArrayUtil.toStringArray((Collection)JavaMethodNameIndex.getInstance().getAllKeys(this.myProject));
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        SmartList fields = new SmartList();
        CommonProcessors.CollectProcessor<PsiField> processor = new CommonProcessors.CollectProcessor<PsiField>((Collection)fields, (List)fields, maxCount){
            final /* synthetic */ List val$fields;
            final /* synthetic */ int val$maxCount;
            {
                this.val$fields = list;
                this.val$maxCount = n;
                super(x0);
            }

            public boolean process(PsiField method) {
                return this.val$fields.size() != this.val$maxCount && super.process((Object)method);
            }
        };
        StubIndex.getInstance().processElements(JavaStubIndexKeys.FIELDS, (Object)name, this.myProject, scope, PsiField.class, (Processor)processor);
        return (PsiField[])this.filterMembers((Collection)fields, scope, (PsiMember[])PsiField.EMPTY_ARRAY);
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        Collection<PsiField> fields = JavaFieldNameIndex.getInstance().get(name, this.myProject, scope);
        return (PsiField[])this.filterMembers(fields, scope, (PsiMember[])PsiField.EMPTY_ARRAY);
    }

    @NotNull
    public String[] getAllFieldNames() {
        return ArrayUtil.toStringArray((Collection)JavaFieldNameIndex.getInstance().getAllKeys(this.myProject));
    }

    public boolean processFieldsWithName(@NotNull String name, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.FIELDS, (Object)name, this.myProject, (GlobalSearchScope)new JavaSourceFilterScope(scope), filter, PsiField.class, processor);
    }

    public boolean processMethodsWithName(@NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name, this.myProject, (GlobalSearchScope)new JavaSourceFilterScope(scope), filter, PsiMethod.class, processor);
    }

    public boolean processClassesWithName(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)name, this.myProject, (GlobalSearchScope)new JavaSourceFilterScope(scope), filter, PsiClass.class, processor);
    }

    @NotNull
    private <T extends PsiMember> T[] filterMembers(@NotNull Collection<T> members, @NotNull GlobalSearchScope scope, @NotNull T[] emptyArray) {
        if (members.isEmpty()) {
            return emptyArray;
        }
        final PsiManager myManager = PsiManager.getInstance((Project)this.myProject);
        THashSet set = new THashSet(members.size(), (TObjectHashingStrategy)new TObjectHashingStrategy<PsiMember>(){

            public int computeHashCode(PsiMember member) {
                int code = 0;
                PsiClass clazz = member.getContainingClass();
                if (clazz != null) {
                    String name = clazz.getName();
                    code = name != null ? (code += name.hashCode()) : (code += clazz.hashCode());
                }
                if (member instanceof PsiMethod) {
                    code += 37 * ((PsiMethod)member).getParameterList().getParametersCount();
                }
                return code;
            }

            public boolean equals(PsiMember object, PsiMember object1) {
                return myManager.areElementsEquivalent((PsiElement)object, (PsiElement)object1);
            }
        });
        ArrayList<PsiMember> result = new ArrayList<PsiMember>(members.size());
        for (PsiMember member : members) {
            ProgressIndicatorProvider.checkCanceled();
            if (!scope.contains(member.getContainingFile().getVirtualFile()) || !set.add(member)) continue;
            result.add(member);
        }
        return (PsiMember[])result.toArray(emptyArray);
    }
}

