/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.EmptySubstitutorImpl;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UnmodifiableTHashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSubstitutorImpl
implements PsiSubstitutor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiSubstitutorImpl");
    private static final TObjectHashingStrategy<PsiTypeParameter> PSI_EQUIVALENCE = new TObjectHashingStrategy<PsiTypeParameter>(){

        public int computeHashCode(PsiTypeParameter parameter2) {
            return Comparing.hashcode((Object)parameter2.getName());
        }

        public boolean equals(PsiTypeParameter element1, PsiTypeParameter element2) {
            return element1.getManager().areElementsEquivalent((PsiElement)element1, (PsiElement)element2);
        }
    };
    private final Map<PsiTypeParameter, PsiType> mySubstitutionMap;
    private final SubstitutionVisitor mySimpleSubstitutionVisitor = new SubstitutionVisitor();
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"substituteGuard");

    private PsiSubstitutorImpl(@NotNull Map<PsiTypeParameter, PsiType> map2) {
        this.mySubstitutionMap = new UnmodifiableTHashMap(PSI_EQUIVALENCE, map2);
    }

    private PsiSubstitutorImpl(@NotNull Map<PsiTypeParameter, PsiType> map2, @NotNull PsiTypeParameter additionalKey, @Nullable PsiType additionalValue) {
        this.mySubstitutionMap = new UnmodifiableTHashMap(PSI_EQUIVALENCE, map2, (Object)additionalKey, (Object)additionalValue);
    }

    PsiSubstitutorImpl(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        this.mySubstitutionMap = new UnmodifiableTHashMap(PSI_EQUIVALENCE, (Object)typeParameter, (Object)mapping);
    }

    PsiSubstitutorImpl(@NotNull PsiClass parentClass, PsiType[] mappings) {
        this(PsiSubstitutorImpl.putAllInternal(Collections.emptyMap(), parentClass, mappings));
    }

    public PsiType substitute(@NotNull PsiTypeParameter typeParameter) {
        return this.containsInMap(typeParameter) ? this.getFromMap(typeParameter) : JavaPsiFacade.getElementFactory((Project)typeParameter.getProject()).createType((PsiClass)typeParameter);
    }

    private boolean containsInMap(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.containsKey(typeParameter);
    }

    private PsiType getFromMap(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.get(typeParameter);
    }

    public PsiType substitute(PsiType type2) {
        if (type2 == null) {
            return null;
        }
        PsiUtil.ensureValidType((PsiType)type2);
        PsiType substituted = (PsiType)type2.accept((PsiTypeVisitor)this.mySimpleSubstitutionVisitor);
        return this.correctExternalSubstitution(substituted, type2);
    }

    public PsiType substituteWithBoundsPromotion(@NotNull PsiTypeParameter typeParameter) {
        PsiType substituted = this.substitute(typeParameter);
        if (substituted instanceof PsiWildcardType && !((PsiWildcardType)substituted).isSuper()) {
            PsiWildcardType wildcard;
            PsiWildcardType wildcardType = (PsiWildcardType)substituted;
            PsiType glb = PsiCapturedWildcardType.captureUpperBound((PsiTypeParameter)typeParameter, (PsiWildcardType)wildcardType, (PsiSubstitutor)this);
            if (glb instanceof PsiWildcardType) {
                return glb;
            }
            if (glb instanceof PsiCapturedWildcardType && !(wildcard = ((PsiCapturedWildcardType)glb).getWildcard()).isSuper()) {
                return wildcard;
            }
            if (glb != null) {
                return PsiWildcardType.createExtends((PsiManager)typeParameter.getManager(), (PsiType)glb);
            }
        }
        return substituted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiSubstitutorImpl)) {
            return false;
        }
        PsiSubstitutorImpl that = (PsiSubstitutorImpl)o;
        return !(this.mySubstitutionMap != null ? !this.mySubstitutionMap.equals(that.mySubstitutionMap) : that.mySubstitutionMap != null);
    }

    public int hashCode() {
        return this.mySubstitutionMap != null ? this.mySubstitutionMap.hashCode() : 0;
    }

    private PsiType rawTypeForTypeParameter(@NotNull PsiTypeParameter typeParameter) {
        PsiClassType[] extendsTypes = typeParameter.getExtendsListTypes();
        if (extendsTypes.length > 0) {
            return (PsiType)ourGuard.doPreventingRecursion((Object)extendsTypes[0], true, () -> this.substitute((PsiType)extendsTypes[0]));
        }
        return PsiType.getJavaLangObject((PsiManager)typeParameter.getManager(), (GlobalSearchScope)typeParameter.getResolveScope());
    }

    @NotNull
    private static TypeAnnotationProvider getMergedProvider(@NotNull PsiType type1, @NotNull PsiType type2) {
        if (type1.getAnnotationProvider() == TypeAnnotationProvider.EMPTY && !(type1 instanceof PsiClassReferenceType)) {
            return type2.getAnnotationProvider();
        }
        if (type2.getAnnotationProvider() == TypeAnnotationProvider.EMPTY && !(type2 instanceof PsiClassReferenceType)) {
            return type1.getAnnotationProvider();
        }
        return () -> (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])type1.getAnnotations(), (Object[])type2.getAnnotations());
    }

    private PsiType correctExternalSubstitution(PsiType substituted, @NotNull PsiType original) {
        if (substituted != null) {
            return substituted;
        }
        return (PsiType)original.accept((PsiTypeVisitor)new PsiTypeVisitor<PsiType>(){

            public PsiType visitArrayType(PsiArrayType arrayType) {
                return new PsiArrayType((PsiType)arrayType.getComponentType().accept((PsiTypeVisitor)this));
            }

            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                return new PsiEllipsisType((PsiType)ellipsisType.getComponentType().accept((PsiTypeVisitor)this));
            }

            public PsiType visitClassType(PsiClassType classType) {
                PsiClass aClass = classType.resolve();
                if (aClass == null) {
                    return classType;
                }
                if (aClass instanceof PsiTypeParameter) {
                    return PsiSubstitutorImpl.this.rawTypeForTypeParameter((PsiTypeParameter)aClass);
                }
                return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass);
            }

            public PsiType visitType(PsiType type2) {
                return null;
            }
        });
    }

    protected PsiSubstitutorImpl clone() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiSubstitutor put(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (mapping != null && !mapping.isValid()) {
            LOG.error("Invalid type in substitutor: " + mapping + "; " + mapping.getClass());
        }
        return new PsiSubstitutorImpl(this.mySubstitutionMap, typeParameter, mapping);
    }

    private static Map<PsiTypeParameter, PsiType> putAllInternal(Map<PsiTypeParameter, PsiType> originalMap, @NotNull PsiClass parentClass, PsiType[] mappings) {
        PsiTypeParameter[] params = parentClass.getTypeParameters();
        if (params.length == 0) {
            return originalMap;
        }
        THashMap newMap = new THashMap(originalMap);
        for (int i = 0; i < params.length; ++i) {
            PsiTypeParameter param = params[i];
            assert (param != null);
            if (mappings != null && mappings.length > i) {
                PsiType mapping = mappings[i];
                newMap.put(param, mapping);
                if (mapping == null || mapping.isValid()) continue;
                LOG.error("Invalid type in substitutor: " + mapping);
                continue;
            }
            newMap.put(param, null);
        }
        return newMap;
    }

    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiClass parentClass, PsiType[] mappings) {
        return new PsiSubstitutorImpl(PsiSubstitutorImpl.putAllInternal(this.mySubstitutionMap, parentClass, mappings));
    }

    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiSubstitutor another) {
        if (another instanceof EmptySubstitutorImpl) {
            return this;
        }
        PsiSubstitutorImpl anotherImpl = (PsiSubstitutorImpl)another;
        THashMap newMap = new THashMap(this.mySubstitutionMap, PSI_EQUIVALENCE);
        newMap.putAll(anotherImpl.mySubstitutionMap);
        return PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)newMap);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<PsiTypeParameter, PsiType>> set = this.mySubstitutionMap.entrySet();
        for (Map.Entry<PsiTypeParameter, PsiType> entry : set) {
            PsiTypeParameter typeParameter = entry.getKey();
            buffer.append(typeParameter.getName());
            PsiTypeParameterListOwner owner = typeParameter.getOwner();
            if (owner instanceof PsiClass) {
                buffer.append(" of ");
                buffer.append(((PsiClass)owner).getQualifiedName());
            } else if (owner instanceof PsiMethod) {
                buffer.append(" of ");
                buffer.append(((PsiMethod)owner).getName());
                buffer.append(" in ");
                PsiClass aClass = ((PsiMethod)owner).getContainingClass();
                buffer.append(aClass != null ? aClass.getQualifiedName() : "<no class>");
            }
            buffer.append(" -> ");
            if (entry.getValue() != null) {
                buffer.append(entry.getValue().getCanonicalText());
            } else {
                buffer.append("null");
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    @NotNull
    public static PsiSubstitutor createSubstitutor(@Nullable Map<PsiTypeParameter, PsiType> map2) {
        if (map2 == null || map2.isEmpty()) {
            return EMPTY;
        }
        return new PsiSubstitutorImpl(map2);
    }

    public boolean isValid() {
        for (PsiType type2 : this.mySubstitutionMap.values()) {
            if (type2 == null || type2.isValid()) continue;
            return false;
        }
        return true;
    }

    public void ensureValid() {
        for (PsiType type2 : this.mySubstitutionMap.values()) {
            if (type2 == null) continue;
            PsiUtil.ensureValidType((PsiType)type2);
        }
    }

    @NotNull
    public Map<PsiTypeParameter, PsiType> getSubstitutionMap() {
        return this.mySubstitutionMap;
    }

    private class SubstitutionVisitor
    extends PsiTypeMapper {
        private SubstitutionVisitor() {
        }

        @Override
        public PsiType visitType(PsiType type2) {
            return null;
        }

        @Override
        public PsiType visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound == null) {
                return wildcardType;
            }
            PsiType newBound = (PsiType)bound.accept((PsiTypeVisitor)this);
            if (newBound == null) {
                return null;
            }
            assert (newBound.isValid()) : newBound.getClass() + "; " + bound.isValid();
            if (newBound instanceof PsiWildcardType) {
                PsiType newBoundBound = ((PsiWildcardType)newBound).getBound();
                return !((PsiWildcardType)newBound).isBounded() ? PsiWildcardType.createUnbounded((PsiManager)wildcardType.getManager()) : this.rebound(wildcardType, newBoundBound);
            }
            return newBound == PsiType.NULL ? newBound : this.rebound(wildcardType, newBound);
        }

        @NotNull
        private PsiWildcardType rebound(@NotNull PsiWildcardType type2, @NotNull PsiType newBound) {
            LOG.assertTrue(type2.getBound() != null);
            LOG.assertTrue(newBound.isValid());
            if (type2.isExtends()) {
                if (newBound.equalsToText("java.lang.Object")) {
                    return PsiWildcardType.createUnbounded((PsiManager)type2.getManager());
                }
                return PsiWildcardType.createExtends((PsiManager)type2.getManager(), (PsiType)newBound);
            }
            return PsiWildcardType.createSuper((PsiManager)type2.getManager(), (PsiType)newBound);
        }

        @Override
        public PsiType visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return classType;
            }
            PsiUtilCore.ensureValid((PsiElement)aClass);
            if (aClass instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
                if (PsiSubstitutorImpl.this.containsInMap(typeParameter)) {
                    PsiType result = this.substituteTypeParameter(typeParameter);
                    if (result != null) {
                        PsiUtil.ensureValidType((PsiType)result);
                        if (result instanceof PsiClassType || result instanceof PsiArrayType || result instanceof PsiWildcardType) {
                            return result.annotate(PsiSubstitutorImpl.getMergedProvider((PsiType)classType, result));
                        }
                    }
                    return result;
                }
                return classType;
            }
            HashMap<PsiTypeParameter, PsiType> hashMap = new HashMap<PsiTypeParameter, PsiType>(2);
            if (!this.processClass(aClass, resolveResult.getSubstitutor(), hashMap)) {
                return null;
            }
            PsiClassType result = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, PsiSubstitutorImpl.createSubstitutor(hashMap), classType.getLanguageLevel());
            PsiUtil.ensureValidType((PsiType)result);
            return result.annotate(classType.getAnnotationProvider());
        }

        private PsiType substituteTypeParameter(@NotNull PsiTypeParameter typeParameter) {
            return PsiSubstitutorImpl.this.getFromMap(typeParameter);
        }

        private PsiType substituteInternal(@NotNull PsiType type2) {
            return (PsiType)type2.accept((PsiTypeVisitor)this);
        }

        private boolean processClass(@NotNull PsiClass resolve, @NotNull PsiSubstitutor originalSubstitutor, @NotNull Map<PsiTypeParameter, PsiType> substMap) {
            PsiTypeParameter[] params;
            for (PsiTypeParameter param : params = resolve.getTypeParameters()) {
                PsiType original = originalSubstitutor.substitute(param);
                if (original == null) {
                    substMap.put(param, null);
                    continue;
                }
                substMap.put(param, this.substituteInternal(original));
            }
            if (resolve.hasModifierProperty("static")) {
                return true;
            }
            PsiClass containingClass = resolve.getContainingClass();
            return containingClass == null || this.processClass(containingClass, originalSubstitutor, substMap);
        }
    }
}

