/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.java.lexer.JavaDocLexer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.ModifierFlags;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class RecordUtil {
    private static final String DEPRECATED_ANNOTATION_NAME = "Deprecated";
    private static final String DEPRECATED_TAG = "@deprecated";

    private RecordUtil() {
    }

    public static boolean isDeprecatedByAnnotation(@NotNull LighterAST tree, @NotNull LighterASTNode modList) {
        for (LighterASTNode child : tree.getChildren(modList)) {
            String name;
            LighterASTNode id;
            LighterASTNode ref;
            if (child.getTokenType() != JavaElementType.ANNOTATION || (ref = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)child, (IElementType)JavaElementType.JAVA_CODE_REFERENCE)) == null || (id = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)ref, (IElementType)JavaTokenType.IDENTIFIER)) == null || !DEPRECATED_ANNOTATION_NAME.equals(name = RecordUtil.intern(tree.getCharTable(), id))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeprecatedByDocComment(@NotNull LighterAST tree, @NotNull LighterASTNode comment) {
        String text2 = LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)comment, null);
        if (text2.contains(DEPRECATED_TAG)) {
            IElementType token;
            JavaDocLexer lexer = new JavaDocLexer(LanguageLevel.HIGHEST);
            lexer.start(text2);
            while ((token = lexer.getTokenType()) != null) {
                if (token == JavaDocTokenType.DOC_TAG_NAME && DEPRECATED_TAG.equals(lexer.getTokenText())) {
                    return true;
                }
                lexer.advance();
            }
        }
        return false;
    }

    public static int packModifierList(@NotNull LighterAST tree, @NotNull LighterASTNode modList) {
        int packed = 0;
        for (LighterASTNode child : tree.getChildren(modList)) {
            packed |= ModifierFlags.KEYWORD_TO_MODIFIER_FLAG_MAP.get((Object)child.getTokenType());
        }
        return packed;
    }

    @NotNull
    public static String intern(@NotNull CharTable table, @NotNull LighterASTNode node) {
        assert (node instanceof LighterASTTokenNode) : node;
        return table.intern(((LighterASTTokenNode)node).getText()).toString();
    }

    public static boolean isStaticNonPrivateMember(@NotNull StubElement<?> stub) {
        PsiModifierListStub type2 = (PsiModifierListStub)stub.findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        if (type2 == null) {
            return false;
        }
        int mask = type2.getModifiersMask();
        if (ModifierFlags.hasModifierProperty("private", mask)) {
            return false;
        }
        if (ModifierFlags.hasModifierProperty("static", mask)) {
            return true;
        }
        return stub instanceof PsiFieldStub && stub.getStubType() == JavaElementType.ENUM_CONSTANT || stub.getParentStub() instanceof PsiClassStub && ((PsiClassStub)stub.getParentStub()).isInterface();
    }
}

