/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClassFileStubBuilder");
    public static final int STUB_VERSION = 22;
    private static final Comparator<Object> CLASS_NAME_COMPARATOR = Comparator.comparing(o -> o.getClass().getName());

    public boolean acceptsFile(@NotNull VirtualFile file) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public StubElement buildStubTree(@NotNull FileContent fileContent) {
        byte[] content;
        VirtualFile file;
        block11: {
            file = fileContent.getFile();
            content = fileContent.getContent();
            file.setPreloadedContentHint(content);
            ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find((VirtualFile)file);
            if (!(decompiler instanceof ClassFileDecompilers.Full)) break block11;
            PsiFileStub psiFileStub = ((ClassFileDecompilers.Full)decompiler).getStubBuilder().buildFileStub(fileContent);
            file.setPreloadedContentHint(null);
            return psiFileStub;
        }
        try {
            block14: {
                break block14;
                catch (ClsFormatException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(file.getPath(), (Throwable)e);
                    }
                    LOG.info(file.getPath() + ": " + e.getMessage());
                }
            }
            try {
                PsiJavaFileStub stub = ClsFileImpl.buildFileStub(file, content);
                if (stub == null && fileContent.getFileName().indexOf(36) < 0) {
                    LOG.info("No stub built for file " + fileContent);
                }
                PsiJavaFileStub psiJavaFileStub = stub;
                return psiJavaFileStub;
            }
            catch (ClsFormatException e) {
                block12: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(file.getPath(), (Throwable)e);
                        break block12;
                    }
                    LOG.info(file.getPath() + ": " + e.getMessage());
                }
                file.setPreloadedContentHint(null);
            }
        }
        finally {
            file.setPreloadedContentHint(null);
        }
        return null;
    }

    public int getStubVersion() {
        int version = 22;
        ArrayList decompilers = ContainerUtil.newArrayList((Object[])ClassFileDecompilers.EP_NAME.getExtensions());
        decompilers.sort(CLASS_NAME_COMPARATOR);
        for (ClassFileDecompilers.Decompiler decompiler : decompilers) {
            if (!(decompiler instanceof ClassFileDecompilers.Full)) continue;
            version = version * 31 + ((ClassFileDecompilers.Full)decompiler).getStubBuilder().getStubVersion() + decompiler.getClass().getName().hashCode();
        }
        return version;
    }
}

