/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import com.intellij.psi.impl.compiled.ClsNameValuePairImpl;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

public class ClsAnnotationParameterListImpl
extends ClsElementImpl
implements PsiAnnotationParameterList {
    private final PsiAnnotation myParent;
    private final ClsNameValuePairImpl[] myAttributes;

    public ClsAnnotationParameterListImpl(@NotNull PsiAnnotation parent, @NotNull PsiNameValuePair[] psiAttributes) {
        this.myParent = parent;
        this.myAttributes = new ClsNameValuePairImpl[psiAttributes.length];
        for (int i = 0; i < psiAttributes.length; ++i) {
            String name = psiAttributes[i].getName();
            Object value2 = psiAttributes[i].getValue();
            if (value2 == null) {
                String anno = parent instanceof ClsAnnotationImpl ? ((PsiAnnotationStub)((ClsAnnotationImpl)parent).getStub()).getText() : parent.getText();
                Logger.getInstance(((Object)((Object)this)).getClass()).error("name=" + name + " anno=[" + anno + "] file=" + parent.getContainingFile());
                value2 = new ClsLiteralExpressionImpl(this, "null", (PsiType)PsiType.NULL, null);
            }
            if (psiAttributes.length == 1 && "value".equals(name)) {
                name = null;
            }
            this.myAttributes[i] = new ClsNameValuePairImpl(this, name, (PsiAnnotationMemberValue)value2);
        }
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (this.myAttributes.length != 0) {
            buffer.append("(");
            for (int i = 0; i < this.myAttributes.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                this.myAttributes[i].appendMirrorText(indentLevel, buffer);
            }
            buffer.append(")");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, null);
        ClsAnnotationParameterListImpl.setMirrors((PsiElement[])this.myAttributes, (PsiElement[])((PsiAnnotationParameterList)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element)).getAttributes());
    }

    @NotNull
    public PsiElement[] getChildren() {
        return this.myAttributes;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationParameterList((PsiAnnotationParameterList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiNameValuePair[] getAttributes() {
        return this.myAttributes;
    }
}

