/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ClsAnnotationValueImpl
extends ClsElementImpl
implements PsiAnnotation,
Navigatable {
    private final ClsElementImpl myParent;
    private final ClsJavaCodeReferenceElementImpl myReferenceElement;
    private final ClsAnnotationParameterListImpl myParameterList;

    ClsAnnotationValueImpl(@NotNull ClsElementImpl parent) {
        this.myParent = parent;
        this.myReferenceElement = this.createReference();
        this.myParameterList = this.createParameterList();
    }

    protected abstract ClsAnnotationParameterListImpl createParameterList();

    protected abstract ClsJavaCodeReferenceElementImpl createReference();

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        buffer.append("@").append(this.myReferenceElement.getCanonicalText());
        this.myParameterList.appendMirrorText(indentLevel, buffer);
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, null);
        PsiAnnotation mirror = (PsiAnnotation)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element);
        ClsAnnotationValueImpl.setMirror(this.getNameReferenceElement(), mirror.getNameReferenceElement());
        ClsAnnotationValueImpl.setMirror(this.getParameterList(), mirror.getParameterList());
    }

    @NotNull
    public PsiElement[] getChildren() {
        return new PsiElement[]{this.myReferenceElement, this.myParameterList};
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotation((PsiAnnotation)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        return this.myParameterList;
    }

    @Nullable
    public String getQualifiedName() {
        return this.myReferenceElement != null ? this.myReferenceElement.getCanonicalText() : null;
    }

    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        return this.myReferenceElement;
    }

    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, T value2) {
        throw ClsAnnotationValueImpl.cannotModifyException(this);
    }

    @Override
    public String getText() {
        StringBuilder buffer = new StringBuilder();
        this.appendMirrorText(0, buffer);
        return buffer.toString();
    }
}

