/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsDocCommentImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ClsDocTagImpl
extends ClsElementImpl
implements PsiDocTag {
    private final ClsDocCommentImpl myDocComment;
    private final PsiElement myNameElement;

    ClsDocTagImpl(ClsDocCommentImpl docComment, @NonNls String name) {
        this.myDocComment = docComment;
        this.myNameElement = new NameElement(this, name);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        buffer.append(this.myNameElement.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, JavaDocElementType.DOC_TAG);
    }

    @Override
    public String getText() {
        return this.myNameElement.getText();
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        return this.myNameElement.textToCharArray();
    }

    @NotNull
    public String getName() {
        return this.getNameElement().getText().substring(1);
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text2) {
        return this.myNameElement.textMatches(text2);
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        return this.myNameElement.textMatches(element);
    }

    @Override
    public int getTextLength() {
        return this.myNameElement.getTextLength();
    }

    @NotNull
    public PsiElement[] getChildren() {
        return new PsiElement[]{this.myNameElement};
    }

    public PsiElement getParent() {
        return this.getContainingComment();
    }

    public PsiDocComment getContainingComment() {
        return this.myDocComment;
    }

    public PsiElement getNameElement() {
        return this.myNameElement;
    }

    @NotNull
    public PsiElement[] getDataElements() {
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiDocTagValue getValueElement() {
        return null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDocTag((PsiDocTag)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiImplUtil.setName(this.getNameElement(), name);
        return this;
    }

    private static class NameElement
    extends ClsElementImpl {
        private final ClsDocTagImpl myParent;
        private final String myText;

        NameElement(ClsDocTagImpl parent, String text2) {
            this.myParent = parent;
            this.myText = text2;
        }

        @Override
        public String getText() {
            return this.myText;
        }

        @Override
        @NotNull
        public char[] textToCharArray() {
            return this.myText.toCharArray();
        }

        @NotNull
        public PsiElement[] getChildren() {
            return PsiElement.EMPTY_ARRAY;
        }

        @Override
        public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        }

        @Override
        public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
            this.setMirrorCheckingType(element, null);
        }

        public PsiElement getParent() {
            return this.myParent;
        }
    }
}

