/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaModuleReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsJavaModuleImpl
extends ClsRepositoryPsiElement<PsiJavaModuleStub>
implements PsiJavaModule {
    private final PsiJavaModuleReferenceElement myReference;

    public ClsJavaModuleImpl(PsiJavaModuleStub stub) {
        super(stub);
        this.myReference = new ClsJavaModuleReferenceElementImpl((PsiElement)this, stub.getName());
    }

    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        return JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.REQUIRES_STATEMENT, (PsiElement[])PsiRequiresStatement.EMPTY_ARRAY));
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        return JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.EXPORTS_STATEMENT, (PsiElement[])PsiPackageAccessibilityStatement.EMPTY_ARRAY));
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        return JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.OPENS_STATEMENT, (PsiElement[])PsiPackageAccessibilityStatement.EMPTY_ARRAY));
    }

    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        return JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.USES_STATEMENT, (PsiElement[])PsiUsesStatement.EMPTY_ARRAY));
    }

    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        return JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.PROVIDES_STATEMENT, (PsiElement[])PsiProvidesStatement.EMPTY_ARRAY));
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        ClsJavaModuleImpl.appendText((PsiElement)this.getModifierList(), indentLevel, buffer);
        buffer.append("module ").append(this.getName()).append(" {\n");
        int newIndentLevel = indentLevel + this.getIndentSize();
        int start = buffer.length();
        ClsJavaModuleImpl.appendChildren(this.getRequires(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getExports(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getOpens(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getUses(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getProvides(), buffer, newIndentLevel, start);
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indentLevel);
        buffer.append('}');
    }

    private static void appendChildren(Iterable<? extends PsiElement> children, StringBuilder buffer, int indentLevel, int start) {
        ArrayList statements = ContainerUtil.newArrayList(children);
        if (!statements.isEmpty()) {
            if (buffer.length() > start) {
                buffer.append('\n');
            }
            for (PsiElement statement : statements) {
                ClsJavaModuleImpl.appendText(statement, indentLevel, buffer);
            }
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, JavaElementType.MODULE);
        PsiJavaModule mirror = (PsiJavaModule)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element);
        ClsJavaModuleImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsJavaModuleImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsJavaModuleImpl.setMirrors(this.getRequires(), mirror.getRequires());
        ClsJavaModuleImpl.setMirrors(this.getExports(), mirror.getExports());
        ClsJavaModuleImpl.setMirrors(this.getOpens(), mirror.getOpens());
        ClsJavaModuleImpl.setMirrors(this.getUses(), mirror.getUses());
        ClsJavaModuleImpl.setMirrors(this.getProvides(), mirror.getProvides());
    }

    private static <T extends PsiElement> void setMirrors(Iterable<? extends T> stubs, Iterable<? extends T> mirrors) {
        ClsJavaModuleImpl.setMirrors(ContainerUtil.newArrayList(stubs), ContainerUtil.newArrayList(mirrors));
    }

    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        return this.myReference;
    }

    @NotNull
    public String getName() {
        return this.myReference.getReferenceText();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        throw ClsJavaModuleImpl.cannotModifyException(this);
    }

    public PsiModifierList getModifierList() {
        StubElement childStub = ((PsiJavaModuleStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        return childStub != null ? (PsiModifierList)childStub.getPsi() : null;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        PsiModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name);
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiJavaModule module;
        PsiElement file;
        PsiElement parent = this.getParent();
        if (parent instanceof PsiClassOwner && (file = parent.getNavigationElement()) != parent && file instanceof PsiJavaFile && (module = ((PsiJavaFile)file).getModuleDeclaration()) != null) {
            return module;
        }
        return this;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModule((PsiJavaModule)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }
}

