/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import com.intellij.psi.impl.compiled.ClsAnnotationValueImpl;
import com.intellij.psi.impl.compiled.ClsArrayInitializerMemberValueImpl;
import com.intellij.psi.impl.compiled.ClsBinaryExpressionImpl;
import com.intellij.psi.impl.compiled.ClsClassObjectAccessExpressionImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import com.intellij.psi.impl.compiled.ClsPrefixExpressionImpl;
import com.intellij.psi.impl.compiled.ClsReferenceExpressionImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.lang.JavaVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsParsingUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.impl.compiled.ClsParsingUtil");
    private static final JavaParserUtil.ParserWrapper ANNOTATION_VALUE = builder -> JavaParser.INSTANCE.getDeclarationParser().parseAnnotationValue(builder);

    private ClsParsingUtil() {
    }

    public static PsiExpression createExpressionFromText(@NotNull String exprText, @NotNull PsiManager manager, @NotNull ClsElementImpl parent) {
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)manager.getProject()).getParserFacade();
        try {
            PsiExpression expr = parserFacade.createExpressionFromText(exprText, null);
            return ClsParsingUtil.psiToClsExpression(expr, parent);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static PsiAnnotationMemberValue createMemberValueFromText(@NotNull String text2, @NotNull PsiManager manager, @NotNull ClsElementImpl parent) {
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)parent);
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)manager, (TreeElement)new JavaDummyElement(text2, ANNOTATION_VALUE, level), null);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotationMemberValue)) {
            LOG.error("Could not parse initializer:'" + text2 + "'");
            return null;
        }
        return ClsParsingUtil.getMemberValue(element, parent);
    }

    public static PsiAnnotationMemberValue getMemberValue(@NotNull PsiElement element, @NotNull ClsElementImpl parent) {
        if (element instanceof PsiExpression) {
            return ClsParsingUtil.psiToClsExpression((PsiExpression)element, parent);
        }
        if (element instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)element).getInitializers();
            PsiAnnotationMemberValue[] clsInitializers = new PsiAnnotationMemberValue[initializers.length];
            ClsArrayInitializerMemberValueImpl arrayValue = new ClsArrayInitializerMemberValueImpl(parent, clsInitializers);
            for (int i = 0; i < initializers.length; ++i) {
                clsInitializers[i] = ClsParsingUtil.getMemberValue((PsiElement)initializers[i], arrayValue);
            }
            return arrayValue;
        }
        if (element instanceof PsiAnnotation) {
            final PsiAnnotation psiAnnotation = (PsiAnnotation)element;
            PsiJavaCodeReferenceElement referenceElement = psiAnnotation.getNameReferenceElement();
            assert (referenceElement != null) : psiAnnotation;
            final String canonicalText = referenceElement.getText();
            return new ClsAnnotationValueImpl(parent){

                @Override
                protected ClsJavaCodeReferenceElementImpl createReference() {
                    return new ClsJavaCodeReferenceElementImpl((PsiElement)this, canonicalText);
                }

                @Override
                protected ClsAnnotationParameterListImpl createParameterList() {
                    PsiNameValuePair[] psiAttributes = psiAnnotation.getParameterList().getAttributes();
                    return new ClsAnnotationParameterListImpl(this, psiAttributes);
                }

                public PsiAnnotationOwner getOwner() {
                    return (PsiAnnotationOwner)this.getParent();
                }
            };
        }
        LOG.error("Unexpected source element for annotation member value: " + element);
        return null;
    }

    static PsiExpression psiToClsExpression(@NotNull PsiExpression expr, @NotNull ClsElementImpl parent) {
        String exprText;
        if (expr instanceof PsiLiteralExpression) {
            boolean forDecompiling = ((ClsFileImpl)parent.getContainingFile()).isForDecompiling();
            PsiPrimitiveType type2 = forDecompiling ? PsiType.NULL : expr.getType();
            Object value2 = forDecompiling ? null : ((PsiLiteralExpression)expr).getValue();
            return new ClsLiteralExpressionImpl(parent, expr.getText(), (PsiType)type2, value2);
        }
        if (expr instanceof PsiPrefixExpression) {
            PsiJavaToken sign = ((PsiPrefixExpression)expr).getOperationSign();
            PsiExpression operand2 = ((PsiPrefixExpression)expr).getOperand();
            if (operand2 == null) {
                LOG.error("Invalid prefix expression: " + expr + " [" + expr.getText() + "]");
                return null;
            }
            return new ClsPrefixExpressionImpl(parent, sign, operand2);
        }
        if (expr instanceof PsiClassObjectAccessExpression && StringUtil.endsWith((CharSequence)(exprText = expr.getText()), (CharSequence)".class")) {
            String classText = exprText.substring(0, exprText.length() - 6);
            return new ClsClassObjectAccessExpressionImpl(parent, classText);
        }
        if (expr instanceof PsiReferenceExpression) {
            return new ClsReferenceExpressionImpl(parent, (PsiReferenceExpression)expr);
        }
        if (expr instanceof PsiBinaryExpression) {
            PsiJavaToken sign = ((PsiBinaryExpression)expr).getOperationSign();
            PsiExpression left = ((PsiBinaryExpression)expr).getLOperand();
            PsiExpression right = ((PsiBinaryExpression)expr).getROperand();
            if (right == null) {
                LOG.error("Invalid binary expression: " + expr + " [" + expr.getText() + "]");
                return null;
            }
            return new ClsBinaryExpressionImpl(parent, sign, left, right);
        }
        if (((ClsFileImpl)parent.getContainingFile()).isForDecompiling()) {
            return new ClsLiteralExpressionImpl(parent, expr.getText(), (PsiType)PsiType.NULL, null);
        }
        PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance((Project)expr.getProject()).getConstantEvaluationHelper();
        Object value3 = evaluator.computeConstantExpression((PsiElement)expr);
        if (value3 != null) {
            return new ClsLiteralExpressionImpl(parent, expr.getText(), expr.getType(), value3);
        }
        LOG.error("Unable to compute expression value: " + expr + " [" + expr.getText() + "]");
        return null;
    }

    public static boolean isJavaIdentifier(@NotNull String identifier, @NotNull LanguageLevel level) {
        return StringUtil.isJavaIdentifier((String)identifier) && !JavaLexer.isKeyword(identifier, level);
    }

    @Nullable
    public static JavaSdkVersion getJdkVersionByBytecode(int major) {
        if (major == 196653 || major == 45) {
            return JavaSdkVersion.JDK_1_1;
        }
        if (major >= 46) {
            JavaVersion version = JavaVersion.compose((int)(major - 44));
            return JavaSdkVersion.fromJavaVersion((JavaVersion)version);
        }
        return null;
    }
}

