/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.core.CoreJavaDirectoryService;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavaDirectoryServiceImpl
extends CoreJavaDirectoryService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.JavaDirectoryServiceImpl");

    @Override
    public PsiPackage getPackage(@NotNull PsiDirectory dir) {
        VirtualFile virtualFile;
        Project project = dir.getProject();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        String packageName = projectFileIndex.getPackageNameByDirectory(virtualFile = dir.getVirtualFile());
        if (packageName == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
    }

    @Override
    @Nullable
    public PsiPackage getPackageInSources(@NotNull PsiDirectory dir) {
        VirtualFile virtualFile;
        ProjectFileIndex fileIndex;
        PsiPackage aPackage = this.getPackage(dir);
        if (aPackage != null && (fileIndex = ProjectRootManager.getInstance((Project)dir.getProject()).getFileIndex()).isInSourceContent(virtualFile = dir.getVirtualFile()) && !fileIndex.isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.RESOURCES)) {
            return aPackage;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        return JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, "Class");
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName) throws IncorrectOperationException {
        return JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
    }

    @Override
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables) throws IncorrectOperationException {
        return this.createClass(dir, name, templateName, askForUndefinedVariables, Collections.emptyMap());
    }

    @Override
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables, @NotNull Map<String, String> additionalProperties) throws IncorrectOperationException {
        return JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName, askForUndefinedVariables, additionalProperties);
    }

    @Override
    @NotNull
    public PsiClass createInterface(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        String templateName = "Interface";
        PsiClass someClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
        if (!someClass.isInterface()) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName, dir.getProject()));
        }
        return someClass;
    }

    @Override
    @NotNull
    public PsiClass createEnum(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        String templateName = "Enum";
        PsiClass someClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
        if (!someClass.isEnum()) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName, dir.getProject()));
        }
        return someClass;
    }

    @Override
    @NotNull
    public PsiClass createAnnotationType(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        String templateName = "AnnotationType";
        PsiClass someClass = JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName);
        if (!someClass.isAnnotationType()) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName, dir.getProject()));
        }
        return someClass;
    }

    private static PsiClass createClassFromTemplate(@NotNull PsiDirectory dir, String name, String templateName) throws IncorrectOperationException {
        return JavaDirectoryServiceImpl.createClassFromTemplate(dir, name, templateName, false, Collections.emptyMap());
    }

    private static PsiClass createClassFromTemplate(@NotNull PsiDirectory dir, String name, String templateName, boolean askToDefineVariables, @NotNull Map<String, String> additionalProperties) throws IncorrectOperationException {
        PsiElement element;
        if (askToDefineVariables) {
            LOG.assertTrue(!ApplicationManager.getApplication().isWriteAccessAllowed());
        }
        Project project = dir.getProject();
        FileTemplate template = FileTemplateManager.getInstance((Project)project).getInternalTemplate(templateName);
        Properties defaultProperties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
        Properties properties = new Properties(defaultProperties);
        properties.setProperty("NAME", name);
        for (Map.Entry<String, String> entry : additionalProperties.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        String ext = StdFileTypes.JAVA.getDefaultExtension();
        String fileName = name + "." + ext;
        try {
            element = askToDefineVariables ? new CreateFromTemplateDialog(project, dir, template, null, properties).create() : FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)dir);
        }
        catch (IncorrectOperationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
        if (element == null) {
            return null;
        }
        PsiJavaFile file = (PsiJavaFile)element.getContainingFile();
        PsiClass[] classes2 = file.getClasses();
        if (classes2.length < 1) {
            throw new IncorrectOperationException(JavaDirectoryServiceImpl.getIncorrectTemplateMessage(templateName, project));
        }
        if (template.isLiveTemplateEnabled()) {
            CreateFromTemplateActionBase.startLiveTemplate((PsiFile)file);
        }
        return classes2[0];
    }

    private static String getIncorrectTemplateMessage(String templateName, Project project) {
        return PsiBundle.message((String)"psi.error.incorrect.class.template.message", (Object[])new Object[]{FileTemplateManager.getInstance((Project)project).internalTemplateToSubject(templateName), templateName});
    }

    @Override
    public void checkCreateClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        JavaDirectoryServiceImpl.checkCreateClassOrInterface(dir, name);
    }

    public static void checkCreateClassOrInterface(@NotNull PsiDirectory directory, String name) throws IncorrectOperationException {
        String qualifiedName;
        PsiUtil.checkIsIdentifier((PsiManager)directory.getManager(), (String)name);
        String fileName = name + "." + StdFileTypes.JAVA.getDefaultExtension();
        directory.checkCreateFile(fileName);
        PsiNameHelper helper = PsiNameHelper.getInstance((Project)directory.getProject());
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        String string = qualifiedName = aPackage == null ? null : aPackage.getQualifiedName();
        if (!StringUtil.isEmpty((String)qualifiedName) && !helper.isQualifiedName(qualifiedName)) {
            throw new IncorrectOperationException("Cannot create class in invalid package: '" + qualifiedName + "'");
        }
    }

    @Override
    public boolean isSourceRoot(@NotNull PsiDirectory dir) {
        VirtualFile file = dir.getVirtualFile();
        VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)dir.getProject()).getFileIndex().getSourceRootForFile(file);
        return file.equals(sourceRoot);
    }

    @Override
    public LanguageLevel getLanguageLevel(@NotNull PsiDirectory dir) {
        return JavaPsiImplementationHelper.getInstance(dir.getProject()).getEffectiveLanguageLevel(dir.getVirtualFile());
    }
}

