/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaBinaryPlusExpressionIndex
extends FileBasedIndexExtension<Boolean, PlusOffsets>
implements PsiDependentIndex {
    public static final ID<Boolean, PlusOffsets> INDEX_ID = ID.create((String)"java.binary.plus.expression");

    @NotNull
    public ID<Boolean, PlusOffsets> getName() {
        return INDEX_ID;
    }

    @NotNull
    public DataIndexer<Boolean, PlusOffsets, FileContent> getIndexer() {
        return inputData -> {
            CharSequence text2 = inputData.getContentAsText();
            if (text2.chars().noneMatch(c -> c == 43)) {
                return Collections.emptyMap();
            }
            final LighterAST tree = ((FileContentImpl)inputData).getLighterASTForPsiDependentIndex();
            final TIntArrayList result = new TIntArrayList(1);
            new RecursiveLighterASTNodeWalkingVisitor(tree){

                public void visitNode(@NotNull LighterASTNode element) {
                    int[] offsets;
                    super.visitNode(element);
                    ProgressManager.checkCanceled();
                    if ((element.getTokenType() == JavaElementType.BINARY_EXPRESSION || element.getTokenType() == JavaElementType.POLYADIC_EXPRESSION) && (offsets = JavaBinaryPlusExpressionIndex.getStringConcatenationPlusOffsets(element, tree)) != null) {
                        result.add(offsets);
                    }
                }
            }.visitNode(tree.getRoot());
            THashMap resultMap = ContainerUtil.newTroveMap();
            resultMap.put((Object)Boolean.TRUE, (Object)new PlusOffsets(result.toNativeArray()));
            return resultMap;
        };
    }

    @NotNull
    public KeyDescriptor<Boolean> getKeyDescriptor() {
        return BooleanDataDescriptor.INSTANCE;
    }

    @NotNull
    public DataExternalizer<PlusOffsets> getValueExternalizer() {
        return new DataExternalizer<PlusOffsets>(){

            public void save(@NotNull DataOutput out, PlusOffsets value2) throws IOException {
                int[] offsets = value2.getOffsets();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)offsets.length);
                for (int i : offsets) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)i);
                }
            }

            public PlusOffsets read(@NotNull DataInput in) throws IOException {
                int[] result = new int[DataInputOutputUtil.readINT((DataInput)in)];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = DataInputOutputUtil.readINT((DataInput)in);
                }
                return new PlusOffsets(result);
            }
        };
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                return super.acceptInput(file) && JavaFileElementType.isInSourceContent(file);
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @Nullable
    private static int[] getStringConcatenationPlusOffsets(@NotNull LighterASTNode concatExpr, @NotNull LighterAST tree) {
        TIntArrayList result = null;
        boolean nonLiteralOccurred = false;
        for (LighterASTNode child : tree.getChildren(concatExpr)) {
            IElementType childTokenType = child.getTokenType();
            if (ElementType.EXPRESSION_BIT_SET.contains(childTokenType)) {
                if (nonLiteralOccurred || JavaElementType.LITERAL_EXPRESSION.equals(childTokenType)) continue;
                nonLiteralOccurred = true;
                continue;
            }
            if (!JavaTokenType.PLUS.equals(childTokenType)) continue;
            if (result == null) {
                result = new TIntArrayList();
            }
            result.add(child.getStartOffset());
        }
        return result == null || !nonLiteralOccurred ? null : result.toNativeArray();
    }

    public static class PlusOffsets {
        private final int[] offsets;

        PlusOffsets(int[] offsets) {
            this.offsets = offsets;
        }

        public int[] getOffsets() {
            return this.offsets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlusOffsets offsets1 = (PlusOffsets)o;
            return Arrays.equals(this.offsets, offsets1.offsets);
        }

        public int hashCode() {
            return Arrays.hashCode(this.offsets);
        }
    }
}

