/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionElementType;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.PsiLambdaExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LambdaExpressionElementType
extends FunctionalExpressionElementType<PsiLambdaExpression> {
    public LambdaExpressionElementType() {
        super("LAMBDA_EXPRESSION");
    }

    @Override
    public PsiLambdaExpression createPsi(@NotNull ASTNode node) {
        return new PsiLambdaExpressionImpl(node);
    }

    public PsiLambdaExpression createPsi(@NotNull FunctionalExpressionStub<PsiLambdaExpression> stub) {
        return new PsiLambdaExpressionImpl(stub);
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new CompositeElement((IElementType)this){

            public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
                super.replaceChildInternal(child, JavaSourceUtil.addParenthToReplacedChild(child, newElement, (PsiManager)this.getManager()));
            }

            public int getChildRole(@NotNull ASTNode child) {
                IElementType elType = child.getElementType();
                if (elType == JavaTokenType.ARROW) {
                    return 252;
                }
                if (elType == JavaElementType.PARAMETER_LIST) {
                    return 14;
                }
                if (elType == JavaElementType.CODE_BLOCK) {
                    return 18;
                }
                return 64;
            }
        };
    }

    @Override
    @NotNull
    protected String getPresentableText(@NotNull LighterAST tree, @NotNull LighterASTNode funExpr) {
        LighterASTNode parameterList = (LighterASTNode)ObjectUtils.notNull((Object)LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)funExpr, (IElementType)JavaStubElementTypes.PARAMETER_LIST));
        return LambdaExpressionElementType.getLambdaPresentableText(tree, parameterList);
    }

    private static String getLambdaPresentableText(@NotNull LighterAST tree, @NotNull LighterASTNode parameterList) {
        StringBuilder buf = new StringBuilder(parameterList.getEndOffset() - parameterList.getStartOffset());
        LambdaExpressionElementType.formatParameterList(tree, parameterList, buf);
        buf.append(" -> {...}");
        return buf.toString();
    }

    private static void formatParameterList(@NotNull LighterAST tree, @NotNull LighterASTNode parameterList, StringBuilder buf) {
        List children = tree.getChildren(parameterList);
        boolean isFirstParameter = true;
        boolean appendCloseBracket = false;
        for (LighterASTNode node : children) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaTokenType.LPARENTH) {
                buf.append('(');
                appendCloseBracket = true;
                continue;
            }
            if (tokenType != JavaStubElementTypes.PARAMETER) continue;
            if (!isFirstParameter) {
                buf.append(", ");
            }
            LambdaExpressionElementType.formatParameter(tree, node, buf);
            if (!isFirstParameter) continue;
            isFirstParameter = false;
        }
        if (appendCloseBracket) {
            buf.append(')');
        }
    }

    private static void formatParameter(@NotNull LighterAST tree, @NotNull LighterASTNode parameter2, StringBuilder buf) {
        List children = tree.getChildren(parameter2);
        for (LighterASTNode node : children) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaElementType.TYPE) {
                LambdaExpressionElementType.formatType(tree, node, buf);
                buf.append(' ');
                continue;
            }
            if (tokenType != JavaTokenType.IDENTIFIER) continue;
            buf.append(RecordUtil.intern(tree.getCharTable(), node));
        }
    }

    private static void formatType(LighterAST tree, LighterASTNode typeElement, StringBuilder buf) {
        for (LighterASTNode node : tree.getChildren(typeElement)) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaElementType.JAVA_CODE_REFERENCE) {
                LambdaExpressionElementType.formatCodeReference(tree, node, buf);
                continue;
            }
            if (tokenType == JavaElementType.TYPE) {
                LambdaExpressionElementType.formatType(tree, node, buf);
                continue;
            }
            if (tokenType == JavaTokenType.QUEST) {
                buf.append("? ");
                continue;
            }
            if (ElementType.KEYWORD_BIT_SET.contains(tokenType)) {
                buf.append(RecordUtil.intern(tree.getCharTable(), node));
                if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) continue;
                buf.append(" ");
                continue;
            }
            if (tokenType == JavaTokenType.ELLIPSIS) {
                buf.append("...");
                continue;
            }
            if (tokenType == JavaTokenType.RBRACKET) {
                buf.append("]");
                continue;
            }
            if (tokenType != JavaTokenType.LBRACKET) continue;
            buf.append("[");
        }
    }

    private static void formatCodeReference(LighterAST tree, LighterASTNode codeRef, StringBuilder buf) {
        for (LighterASTNode node : tree.getChildren(codeRef)) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaTokenType.IDENTIFIER) {
                buf.append(RecordUtil.intern(tree.getCharTable(), node));
                continue;
            }
            if (tokenType != JavaElementType.REFERENCE_PARAMETER_LIST) continue;
            LambdaExpressionElementType.formatTypeParameters(tree, node, buf);
        }
    }

    private static void formatTypeParameters(LighterAST tree, LighterASTNode typeParameters, StringBuilder buf) {
        List children = LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)typeParameters, (IElementType)JavaElementType.TYPE);
        if (children.isEmpty()) {
            return;
        }
        buf.append('<');
        for (int i = 0; i < children.size(); ++i) {
            LighterASTNode child = (LighterASTNode)children.get(i);
            LambdaExpressionElementType.formatType(tree, child, buf);
            if (i == children.size() - 1) continue;
            buf.append(", ");
        }
        buf.append('>');
    }
}

