/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.impl.PsiElementFactoryImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiAnnotationStubImpl
extends StubBase<PsiAnnotation>
implements PsiAnnotationStub {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl");
    private final String myText;
    private SoftReference<PsiAnnotation> myParsedFromRepository;

    public PsiAnnotationStubImpl(StubElement parent, @NotNull String text2) {
        super(parent, (IStubElementType)JavaStubElementTypes.ANNOTATION);
        CharSequence interned = CharTableImpl.getStaticInterned((CharSequence)text2);
        this.myText = interned == null ? text2 : interned.toString();
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public PsiAnnotation getPsiElement() {
        PsiAnnotation annotation = (PsiAnnotation)SoftReference.dereference(this.myParsedFromRepository);
        if (annotation != null) {
            return annotation;
        }
        String text2 = this.getText();
        try {
            PsiJavaParserFacade facade = JavaPsiFacade.getInstance((Project)this.getProject()).getParserFacade();
            annotation = facade instanceof PsiElementFactoryImpl ? ((PsiElementFactoryImpl)facade).createAnnotationFromText(text2, this.getPsi(), false) : facade.createAnnotationFromText(text2, this.getPsi());
            ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
            this.myParsedFromRepository = new SoftReference((Object)annotation);
            return annotation;
        }
        catch (IncorrectOperationException e) {
            LOG.error("Bad annotation in " + this.fileName(), (Throwable)e);
            return null;
        }
    }

    private String fileName() {
        PsiAnnotationStubImpl stub = this;
        while ((stub = stub.getParentStub()) != null) {
            PsiElement psi;
            if (!(stub instanceof PsiFileStub) || !((psi = stub.getPsi()) instanceof PsiFile)) continue;
            VirtualFile file = ((PsiFile)psi).getVirtualFile();
            return file != null ? file.getUrl() : ((PsiFile)psi).getName();
        }
        return "<unknown file>";
    }

    public String toString() {
        return "PsiAnnotationStub[" + this.myText + ']';
    }

    static {
        CharTableImpl.addStringsFromClassToStatics(AnnotationUtil.class);
        CharTableImpl.staticIntern((String)"@NotNull");
        CharTableImpl.staticIntern((String)"@Nullable");
        CharTableImpl.staticIntern((String)"@Override");
    }
}

