/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLightClass
extends LightElement
implements PsiClass {
    protected AbstractLightClass(PsiManager manager, Language language) {
        super(manager, language);
    }

    protected AbstractLightClass(PsiManager manager) {
        super(manager, (Language)JavaLanguage.INSTANCE);
    }

    @NotNull
    public abstract PsiClass getDelegate();

    @NotNull
    public abstract PsiElement copy();

    @NonNls
    @Nullable
    public String getName() {
        return this.getDelegate().getName();
    }

    @Nullable
    public PsiModifierList getModifierList() {
        return this.getDelegate().getModifierList();
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        return this.getDelegate().hasModifierProperty(name);
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return this.getDelegate().isDeprecated();
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    @Nullable
    public PsiTypeParameterList getTypeParameterList() {
        return this.getDelegate().getTypeParameterList();
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        return this.getDelegate().getTypeParameters();
    }

    @NonNls
    @Nullable
    public String getQualifiedName() {
        return this.getDelegate().getQualifiedName();
    }

    public boolean isInterface() {
        return this.getDelegate().isInterface();
    }

    public boolean isAnnotationType() {
        return this.getDelegate().isAnnotationType();
    }

    public boolean isEnum() {
        return this.getDelegate().isEnum();
    }

    @Nullable
    public PsiReferenceList getExtendsList() {
        return this.getDelegate().getExtendsList();
    }

    @Nullable
    public PsiReferenceList getImplementsList() {
        return this.getDelegate().getImplementsList();
    }

    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        return PsiClassImplUtil.getExtendsListTypes(this);
    }

    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        return PsiClassImplUtil.getImplementsListTypes(this);
    }

    @Nullable
    public PsiClass getSuperClass() {
        return this.getDelegate().getSuperClass();
    }

    @NotNull
    public PsiClass[] getInterfaces() {
        return this.getDelegate().getInterfaces();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.getDelegate().getNavigationElement();
    }

    @NotNull
    public PsiClass[] getSupers() {
        return this.getDelegate().getSupers();
    }

    @NotNull
    public PsiClassType[] getSuperTypes() {
        return this.getDelegate().getSuperTypes();
    }

    @NotNull
    public PsiField[] getFields() {
        return this.getDelegate().getFields();
    }

    @NotNull
    public PsiMethod[] getMethods() {
        return this.getDelegate().getMethods();
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        return this.getDelegate().getConstructors();
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        return this.getDelegate().getInnerClasses();
    }

    @NotNull
    public PsiClassInitializer[] getInitializers() {
        return this.getDelegate().getInitializers();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return PsiClassImplUtil.processDeclarationsInClass(this, processor, state, null, lastParent, place, PsiUtil.getLanguageLevel((PsiElement)place), false);
    }

    @NotNull
    public PsiField[] getAllFields() {
        return this.getDelegate().getAllFields();
    }

    @NotNull
    public PsiMethod[] getAllMethods() {
        return this.getDelegate().getAllMethods();
    }

    @NotNull
    public PsiClass[] getAllInnerClasses() {
        return this.getDelegate().getAllInnerClasses();
    }

    @Nullable
    public PsiField findFieldByName(@NonNls String name, boolean checkBases) {
        return PsiClassImplUtil.findFieldByName(this, name, checkBases);
    }

    @Nullable
    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
        return PsiClassImplUtil.findMethodsByName(this, name, checkBases);
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NonNls String name, boolean checkBases) {
        return PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name, checkBases);
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        return PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiClassImplUtil.MemberType.METHOD);
    }

    @Nullable
    public PsiClass findInnerClassByName(@NonNls String name, boolean checkBases) {
        return this.getDelegate().findInnerClassByName(name, checkBases);
    }

    @Nullable
    public PsiElement getLBrace() {
        return this.getDelegate().getLBrace();
    }

    @Nullable
    public PsiElement getRBrace() {
        return this.getDelegate().getRBrace();
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return this.getDelegate().getNameIdentifier();
    }

    public PsiElement getScope() {
        return this.getDelegate().getScope();
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        return this.getDelegate().isInheritor(baseClass, checkDeep);
    }

    public boolean isInheritorDeep(PsiClass baseClass, @Nullable PsiClass classToByPass) {
        return this.getDelegate().isInheritorDeep(baseClass, classToByPass);
    }

    @Nullable
    public PsiClass getContainingClass() {
        return this.getDelegate().getContainingClass();
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        return this.getDelegate().getVisibleSignatures();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        return this.getDelegate().setName(name);
    }

    public String toString() {
        return "PsiClass:" + this.getName();
    }

    public String getText() {
        return this.getDelegate().getText();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass((PsiClass)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiFile getContainingFile() {
        return this.getDelegate().getContainingFile();
    }

    public PsiElement getContext() {
        return this.getDelegate();
    }

    public boolean isValid() {
        return this.getDelegate().isValid();
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another || another instanceof AbstractLightClass && this.getDelegate().isEquivalentTo((PsiElement)((AbstractLightClass)another).getDelegate()) || this.getDelegate().isEquivalentTo(another);
    }
}

