/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.light.LightClassReferenceBase;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightClassReference
extends LightClassReferenceBase
implements PsiJavaCodeReferenceElement {
    private final String myClassName;
    private final PsiElement myContext;
    @NotNull
    private final GlobalSearchScope myResolveScope;
    private final PsiClass myRefClass;
    private final PsiSubstitutor mySubstitutor;

    private LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text2, @Nullable @NonNls String className, @Nullable PsiSubstitutor substitutor, @NotNull GlobalSearchScope resolveScope, @Nullable PsiElement context, @Nullable PsiClass refClass) {
        super(manager, text2);
        this.myClassName = className;
        this.myResolveScope = resolveScope;
        this.myContext = context;
        this.myRefClass = refClass;
        this.mySubstitutor = substitutor;
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text2, @NotNull @NonNls String className, @NotNull GlobalSearchScope resolveScope) {
        this(manager, text2, className, null, resolveScope, null, null);
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text2, @NotNull @NonNls String className, PsiSubstitutor substitutor, @NotNull PsiElement context) {
        this(manager, text2, className, substitutor, context.getResolveScope(), context, null);
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text2, @NotNull PsiClass refClass) {
        this(manager, text2, refClass, null);
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text2, @NotNull PsiClass refClass, PsiSubstitutor substitutor) {
        this(manager, text2, null, substitutor, refClass.getResolveScope(), null, refClass);
    }

    public PsiElement resolve() {
        if (this.myClassName != null) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
            if (this.myContext != null) {
                return facade.getResolveHelper().resolveReferencedClass(this.myClassName, this.myContext);
            }
            return facade.findClass(this.myClassName, this.myResolveScope);
        }
        return this.myRefClass;
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiElement resolved = this.resolve();
        if (resolved == null) {
            return JavaResolveResult.EMPTY;
        }
        PsiSubstitutor substitutor = this.mySubstitutor;
        if (substitutor == null) {
            substitutor = resolved instanceof PsiClass ? JavaPsiFacade.getElementFactory((Project)this.myManager.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)((PsiClass)resolved)) : PsiSubstitutor.EMPTY;
        }
        return new CandidateInfo(resolved, substitutor);
    }

    @Override
    public String getQualifiedName() {
        if (this.myClassName != null) {
            PsiClass psiClass;
            if (this.myContext != null && (psiClass = (PsiClass)this.resolve()) != null) {
                return psiClass.getQualifiedName();
            }
            return this.myClassName;
        }
        return this.myRefClass.getQualifiedName();
    }

    public String getReferenceName() {
        if (this.myClassName != null) {
            return PsiNameHelper.getShortClassName((String)this.myClassName);
        }
        if (this.myRefClass instanceof PsiAnonymousClass) {
            return ((PsiAnonymousClass)this.myRefClass).getBaseClassReference().getReferenceName();
        }
        return this.myRefClass.getName();
    }

    public PsiElement copy() {
        if (this.myClassName != null) {
            if (this.myContext != null) {
                return new LightClassReference(this.myManager, this.myText, this.myClassName, this.mySubstitutor, this.myContext);
            }
            return new LightClassReference(this.myManager, this.myText, this.myClassName, this.mySubstitutor, this.myResolveScope, null, null);
        }
        return new LightClassReference(this.myManager, this.myText, this.myRefClass, this.mySubstitutor);
    }

    public boolean isValid() {
        return this.myRefClass == null || this.myRefClass.isValid();
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return this.myResolveScope;
    }
}

