/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightReferenceParameterList;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

abstract class LightClassReferenceBase
extends LightElement
implements PsiJavaCodeReferenceElement {
    protected final String myText;
    private LightReferenceParameterList myParameterList;

    protected LightClassReferenceBase(@NotNull PsiManager manager, @NotNull String text2) {
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myText = text2;
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            return new JavaResolveResult[]{result};
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    public void processVariants(@NotNull PsiScopeProcessor processor) {
        throw new RuntimeException("Variants are not available for light references");
    }

    public PsiElement getReferenceNameElement() {
        return null;
    }

    public PsiReferenceParameterList getParameterList() {
        if (this.myParameterList == null) {
            this.myParameterList = new LightReferenceParameterList(this.myManager, PsiTypeElement.EMPTY_ARRAY);
        }
        return this.myParameterList;
    }

    public String getQualifiedName() {
        PsiClass psiClass = (PsiClass)this.resolve();
        if (psiClass != null) {
            return psiClass.getQualifiedName();
        }
        return null;
    }

    public String getText() {
        return this.myText;
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public String getCanonicalText() {
        String name = this.getQualifiedName();
        if (name == null) {
            return "";
        }
        PsiType[] types = this.getTypeParameters();
        if (types.length == 0) {
            return name;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(name);
        buf.append('<');
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(types[i].getCanonicalText());
        }
        buf.append('>');
        return buf.toString();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + this.getText();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        return element instanceof PsiClass && this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @NotNull
    public PsiElement getElement() {
        return this;
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        return PsiType.EMPTY_ARRAY;
    }

    public PsiElement getQualifier() {
        return null;
    }

    public boolean isQualified() {
        return false;
    }
}

